/*
 * Decompiled with CFR 0.152.
 */
package sf.util.clparser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import sf.util.clparser.BaseOption;
import sf.util.clparser.BooleanOption;
import sf.util.clparser.Option;
import sf.util.clparser.OptionValue;

public class CommandLineParser {
    private static final String DASH = "-";
    private final Map<String, Option<?>> optionsMap = new HashMap();
    private Map<Option<?>, OptionValue<?>> optionValues = new HashMap();

    public CommandLineParser(Option<?> ... options) {
        for (Option<?> option : options) {
            this.addOption(option);
        }
    }

    public final boolean getBooleanValue(String optionName) {
        OptionValue optionValue = this.getOptionValue(optionName);
        Boolean value = (Boolean)optionValue.getValue();
        if (value == null) {
            return false;
        }
        return value;
    }

    public final Integer getIntegerValue(String optionName) {
        OptionValue optionValue = this.getOptionValue(optionName);
        Number value = (Number)optionValue.getValue();
        if (value == null) {
            return null;
        }
        return value.intValue();
    }

    public final String getStringValue(String optionName) {
        OptionValue optionValue = this.getOptionValue(optionName);
        Object value = optionValue.getValue();
        if (value == null) {
            return null;
        }
        return String.valueOf(value);
    }

    public final <T> T getValue(String optionName) {
        OptionValue<T> optionValue = this.getOptionValue(optionName);
        return optionValue.getValue();
    }

    public final boolean hasOptionValue(String optionName) {
        Option<?> option = this.optionsMap.get(DASH + optionName);
        if (option != null) {
            return this.optionValues.containsKey(option);
        }
        return false;
    }

    public final String[] parse(String[] args) {
        this.optionValues = new HashMap();
        ArrayList<String> remainingArgs = new ArrayList<String>();
        int position = 0;
        while (position < args.length) {
            OptionValue optionValue;
            Option<?> option;
            String currentArg = args[position];
            String valueArg = null;
            int equalsPos = currentArg.indexOf(61);
            if (equalsPos != -1) {
                valueArg = currentArg.substring(equalsPos + 1);
                currentArg = currentArg.substring(0, equalsPos);
            }
            if ((option = this.optionsMap.get(currentArg)) == null || this.optionValues.containsKey(option)) {
                remainingArgs.add(args[position]);
                ++position;
                continue;
            }
            if (valueArg == null && ++position < args.length && (valueArg = args[position]).startsWith(DASH)) {
                --position;
                valueArg = null;
            }
            if (valueArg == null && option instanceof BooleanOption) {
                valueArg = Boolean.TRUE.toString();
            }
            if ((optionValue = ((BaseOption)option).parseValue(valueArg)) != null) {
                this.optionValues.put(option, optionValue);
            }
            ++position;
        }
        String[] unparsedArgs = remainingArgs.toArray(new String[remainingArgs.size()]);
        return unparsedArgs;
    }

    public String toString() {
        return this.optionValues.values().toString();
    }

    private final <T> OptionValue<T> getOptionValue(String optionName) {
        OptionValue<Object> optionValue = null;
        Option<?> option = this.optionsMap.get(DASH + optionName);
        if (option != null && (optionValue = this.optionValues.get(option)) == null) {
            optionValue = new OptionValue<Object>(option, null);
        }
        return optionValue;
    }

    protected void addOption(Option<?> option) {
        if (option == null) {
            return;
        }
        if (option.hasShortForm()) {
            this.optionsMap.put(DASH + option.getShortForm(), option);
        }
        if (option.hasLongForm()) {
            this.optionsMap.put(DASH + option.getLongForm(), option);
        }
    }
}

