/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.analysis.associations;

import java.util.ArrayList;
import schemacrawler.schema.Database;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.BaseDatabaseDecorator;
import schemacrawler.tools.analysis.associations.SimpleWeakAssociationsCollector;
import schemacrawler.tools.analysis.associations.WeakAssociationsAnalyzer;
import schemacrawler.tools.analysis.associations.WeakAssociationsCollector;

public final class DatabaseWithAssociations
extends BaseDatabaseDecorator {
    private static final long serialVersionUID = -3953296149824921463L;
    private final WeakAssociationsCollector collector;

    public DatabaseWithAssociations(Database database) {
        super(database);
        ArrayList<Table> allTables = new ArrayList<Table>();
        for (Schema schema : database.getSchemas()) {
            for (Table table : database.getTables(schema)) {
                allTables.add(table);
            }
        }
        this.collector = new SimpleWeakAssociationsCollector();
        WeakAssociationsAnalyzer weakAssociationsAnalyzer = new WeakAssociationsAnalyzer(allTables, this.collector);
        weakAssociationsAnalyzer.analyzeTables();
    }

    public WeakAssociationsCollector getCollector() {
        return this.collector;
    }
}

