/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.graph;

import java.io.File;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashSet;
import schemacrawler.schema.ColumnReference;
import schemacrawler.schema.Database;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Table;
import schemacrawler.tools.analysis.associations.DatabaseWithAssociations;
import schemacrawler.tools.analysis.associations.SimpleWeakAssociationsCollector;
import schemacrawler.tools.executable.BaseExecutable;
import schemacrawler.tools.integration.graph.DotWriter;
import schemacrawler.tools.integration.graph.GraphGenerator;
import schemacrawler.tools.options.InfoLevel;
import sf.util.Utility;

public final class GraphExecutable
extends BaseExecutable {
    static final String COMMAND = "graph";

    public GraphExecutable() {
        super(COMMAND);
    }

    @Override
    protected void executeOn(Database db, Connection connection) throws Exception {
        InfoLevel infoLevel;
        try {
            infoLevel = InfoLevel.valueOf(this.getSchemaCrawlerOptions().getSchemaInfoLevel().getTag());
        }
        catch (Exception e) {
            infoLevel = InfoLevel.unknown;
        }
        Object database = infoLevel == InfoLevel.maximum ? new DatabaseWithAssociations(db) : db;
        ArrayList<Table> tables = new ArrayList<Table>();
        HashSet<ColumnReference> weakAssociations = new HashSet<ColumnReference>();
        for (Schema schema : database.getSchemas()) {
            for (Table table : database.getTables(schema)) {
                tables.add(table);
                weakAssociations.addAll(SimpleWeakAssociationsCollector.getWeakAssociations(table));
            }
        }
        File dotFile = File.createTempFile("schemacrawler.", ".dot");
        DotWriter dotWriter = new DotWriter(dotFile);
        dotWriter.open();
        dotWriter.print(database.getSchemaCrawlerInfo(), database.getDatabaseInfo(), database.getJdbcDriverInfo());
        dotWriter.print(tables, weakAssociations);
        dotWriter.close();
        GraphGenerator dot = new GraphGenerator(dotFile, this.outputOptions.getOutputFormatValue(), this.outputOptions.getOutputFile());
        try {
            dot.generateDiagram();
        }
        catch (Exception e) {
            System.out.println(Utility.readResourceFully((String)"/dot.error.txt"));
            throw e;
        }
    }
}

