/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.reactor;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;
import org.apache.http.impl.nio.reactor.AbstractMultiworkerIOReactor;
import org.apache.http.impl.nio.reactor.ChannelEntry;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.nio.reactor.IOReactorExceptionHandler;
import org.apache.http.nio.reactor.ListeningIOReactor;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.concurrent.ThreadFactory;

public class DefaultListeningIOReactor
extends AbstractMultiworkerIOReactor
implements ListeningIOReactor {
    public static int TIMEOUT_CHECK_INTERVAL = 1000;
    private volatile boolean closed = false;
    private final HttpParams params;
    private final Selector selector;
    private IOReactorExceptionHandler exceptionHandler;

    public DefaultListeningIOReactor(int workerCount, ThreadFactory threadFactory, HttpParams params) throws IOReactorException {
        super(TIMEOUT_CHECK_INTERVAL, workerCount, threadFactory);
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.params = params;
        try {
            this.selector = Selector.open();
        }
        catch (IOException ex) {
            throw new IOReactorException("Failure opening selector", ex);
        }
    }

    public DefaultListeningIOReactor(int workerCount, HttpParams params) throws IOReactorException {
        this(workerCount, null, params);
    }

    public void setExceptionHandler(IOReactorExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public void execute(IOEventDispatch eventDispatch) throws InterruptedIOException, IOReactorException {
        if (eventDispatch == null) {
            throw new IllegalArgumentException("Event dispatcher may not be null");
        }
        this.startWorkers(eventDispatch);
        while (true) {
            int readyCount;
            try {
                readyCount = this.selector.select(TIMEOUT_CHECK_INTERVAL);
            }
            catch (InterruptedIOException ex) {
                throw ex;
            }
            catch (IOException ex) {
                throw new IOReactorException("Unexpected selector failure", ex);
            }
            if (this.closed) break;
            if (readyCount > 0) {
                this.processEvents(this.selector.selectedKeys());
            }
            this.verifyWorkers();
        }
    }

    private void processEvents(Set selectedKeys) throws IOReactorException {
        Iterator it = selectedKeys.iterator();
        while (it.hasNext()) {
            SelectionKey key = (SelectionKey)it.next();
            this.processEvent(key);
        }
        selectedKeys.clear();
    }

    private void processEvent(SelectionKey key) throws IOReactorException {
        block6: {
            try {
                SocketChannel socketChannel;
                block8: {
                    block7: {
                        if (!key.isAcceptable()) break block6;
                        ServerSocketChannel serverChannel = (ServerSocketChannel)key.channel();
                        socketChannel = null;
                        try {
                            socketChannel = serverChannel.accept();
                        }
                        catch (IOException ex) {
                            if (this.exceptionHandler != null && this.exceptionHandler.handle(ex)) break block7;
                            throw new IOReactorException("Failure accepting connection", ex);
                        }
                    }
                    if (socketChannel == null) break block6;
                    try {
                        this.prepareSocket(socketChannel.socket());
                    }
                    catch (IOException ex) {
                        if (this.exceptionHandler != null && this.exceptionHandler.handle(ex)) break block8;
                        throw new IOReactorException("Failure initalizing socket", ex);
                    }
                }
                ChannelEntry entry = new ChannelEntry(socketChannel);
                this.addChannel(entry);
            }
            catch (CancelledKeyException ex) {
                key.attach(null);
            }
        }
    }

    protected void prepareSocket(Socket socket) throws IOException {
        socket.setTcpNoDelay(HttpConnectionParams.getTcpNoDelay((HttpParams)this.params));
        socket.setSoTimeout(HttpConnectionParams.getSoTimeout((HttpParams)this.params));
        int linger = HttpConnectionParams.getLinger((HttpParams)this.params);
        if (linger >= 0) {
            socket.setSoLinger(linger > 0, linger);
        }
    }

    public SocketAddress listen(SocketAddress address) throws IOException {
        ServerSocketChannel serverChannel = ServerSocketChannel.open();
        serverChannel.configureBlocking(false);
        serverChannel.socket().bind(address);
        SelectionKey key = serverChannel.register(this.selector, 16);
        key.attach(null);
        return serverChannel.socket().getLocalSocketAddress();
    }

    public void shutdown() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.selector.close();
        this.stopWorkers(500);
    }
}

