/*
 * Decompiled with CFR 0.152.
 */
package sf.util.clparser;

import java.text.NumberFormat;
import java.text.ParseException;
import sf.util.clparser.BaseOption;
import sf.util.clparser.OptionValue;

public final class NumberOption
extends BaseOption<Number> {
    public NumberOption(Character shortForm, Number defaultValue) {
        super(shortForm, defaultValue);
    }

    public NumberOption(Character shortForm, String longForm, Number defaultValue) {
        super(shortForm, longForm, defaultValue);
    }

    public NumberOption(String longForm, Number defaultValue) {
        super(longForm, defaultValue);
    }

    @Override
    protected OptionValue<Number> parseValue(String arg) {
        try {
            Number number = NumberFormat.getNumberInstance().parse(arg);
            return new OptionValue<Number>(this, number);
        }
        catch (ParseException e) {
            return null;
        }
        catch (NullPointerException e) {
            return null;
        }
    }
}

