/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import schemacrawler.crawl.AbstractNamedObject;
import schemacrawler.schema.DatabaseObject;
import schemacrawler.schema.NamedObject;
import schemacrawler.schema.Schema;
import sf.util.Utility;

abstract class AbstractDatabaseObject
extends AbstractNamedObject
implements DatabaseObject {
    private static final long serialVersionUID = 3099561832386790624L;
    private final Schema schema;
    private transient String fullName;
    private transient int hashCode;

    AbstractDatabaseObject(Schema schema, String name) {
        super(name);
        this.schema = schema;
    }

    @Override
    public int compareTo(NamedObject obj) {
        int compareTo;
        if (obj == null) {
            return -1;
        }
        if (obj instanceof DatabaseObject && (compareTo = this.getSchema().compareTo(((DatabaseObject)obj).getSchema())) != 0) {
            return compareTo;
        }
        return super.compareTo(obj);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        AbstractDatabaseObject other = (AbstractDatabaseObject)obj;
        return !(this.schema == null ? other.schema != null : !this.schema.equals(other.schema));
    }

    @Override
    public String getFullName() {
        this.buildFullName();
        return this.fullName;
    }

    @Override
    public final Schema getSchema() {
        return this.schema;
    }

    @Override
    public int hashCode() {
        this.buildHashCode();
        return this.hashCode;
    }

    @Override
    public String toString() {
        return this.getFullName();
    }

    private void buildFullName() {
        if (this.fullName == null) {
            String quotedName;
            StringBuilder buffer = new StringBuilder();
            String schemaFullName = this.schema.getFullName();
            if (this.schema != null && !Utility.isBlank(schemaFullName)) {
                buffer.append(schemaFullName).append('.');
            }
            if (!Utility.isBlank(quotedName = this.getName())) {
                buffer.append(quotedName);
            }
            this.fullName = buffer.toString();
        }
    }

    private void buildHashCode() {
        if (this.hashCode == 0) {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.schema == null ? 0 : this.schema.hashCode());
            this.hashCode = result = 31 * result + super.hashCode();
        }
    }
}

