/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import schemacrawler.crawl.MutableColumnDataType;
import schemacrawler.crawl.MutableDatabase;
import schemacrawler.crawl.MutableRoutine;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.schema.DatabaseObject;
import schemacrawler.schema.Schema;
import schemacrawler.schema.SchemaReference;
import sf.util.Utility;

abstract class AbstractRetriever {
    static final String UNKNOWN = "<unknown>";
    private final RetrieverConnection retrieverConnection;
    final MutableDatabase database;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<String> readResultsVector(ResultSet results) throws SQLException {
        ArrayList<String> values = new ArrayList<String>();
        try {
            while (results.next()) {
                String value = results.getString(1);
                values.add(value);
            }
        }
        finally {
            results.close();
        }
        return values;
    }

    AbstractRetriever() throws SQLException {
        this(null, null);
    }

    AbstractRetriever(RetrieverConnection retrieverConnection, MutableDatabase database) throws SQLException {
        this.retrieverConnection = retrieverConnection;
        this.database = database;
    }

    boolean belongsToSchema(DatabaseObject dbObject, String catalogName, String schemaName) {
        if (dbObject == null) {
            return false;
        }
        boolean supportsCatalogs = this.retrieverConnection.isSupportsCatalogs();
        boolean belongsToCatalog = true;
        boolean belongsToSchema = true;
        if (supportsCatalogs) {
            String dbObjectCatalogName = dbObject.getSchema().getCatalogName();
            if (catalogName != null && !this.unquotedName(catalogName).equals(this.unquotedName(dbObjectCatalogName))) {
                belongsToCatalog = false;
            }
        }
        String dbObjectSchemaName = dbObject.getSchema().getName();
        if (schemaName != null && !this.unquotedName(schemaName).equals(this.unquotedName(dbObjectSchemaName))) {
            belongsToSchema = false;
        }
        return belongsToCatalog && belongsToSchema;
    }

    Connection getDatabaseConnection() {
        return this.retrieverConnection.getConnection();
    }

    DatabaseMetaData getMetaData() {
        return this.retrieverConnection.getMetaData();
    }

    RetrieverConnection getRetrieverConnection() {
        return this.retrieverConnection;
    }

    Collection<Schema> getSchemas() {
        return this.database.getSchemas();
    }

    MutableColumnDataType lookupOrCreateColumnDataType(Schema schema, int javaSqlType, String databaseSpecificTypeName) {
        MutableColumnDataType columnDataType = this.database.getColumnDataType(schema, databaseSpecificTypeName);
        if (columnDataType == null) {
            columnDataType = this.database.getSystemColumnDataType(databaseSpecificTypeName);
        }
        if (columnDataType == null) {
            columnDataType = new MutableColumnDataType(schema, databaseSpecificTypeName);
            columnDataType.setType(javaSqlType, null);
            this.database.addColumnDataType(columnDataType);
        }
        return columnDataType;
    }

    MutableRoutine lookupRoutine(String catalogName, String schemaName, String routineName, String specificName) {
        MutableRoutine routine = null;
        SchemaReference schema = new SchemaReference(catalogName, schemaName);
        if (schema != null) {
            String routineLookupName = !Utility.isBlank(specificName) ? specificName : routineName;
            routine = (MutableRoutine)this.database.getRoutine(new SchemaReference(catalogName, schemaName), routineLookupName);
        }
        return routine;
    }

    MutableTable lookupTable(String catalogName, String schemaName, String tableName) {
        MutableTable table = null;
        SchemaReference schema = new SchemaReference(catalogName, schemaName);
        if (schema != null) {
            table = this.database.getTable(new SchemaReference(catalogName, schemaName), tableName);
        }
        return table;
    }

    String quotedName(String name) {
        String quotedName;
        RetrieverConnection retrieverConnection = this.getRetrieverConnection();
        if (retrieverConnection != null && !Utility.isBlank(name)) {
            String identifierQuoteString = retrieverConnection.getIdentifierQuoteString();
            quotedName = retrieverConnection.needsToBeQuoted(name) ? identifierQuoteString + name + identifierQuoteString : name;
        } else {
            quotedName = name;
        }
        return quotedName;
    }

    String unquotedName(String name) {
        String unquotedName;
        RetrieverConnection retrieverConnection = this.getRetrieverConnection();
        if (retrieverConnection != null && !Utility.isBlank(name)) {
            String identifierQuoteString = retrieverConnection.getIdentifierQuoteString();
            if (name.startsWith(identifierQuoteString) && name.endsWith(identifierQuoteString)) {
                int quoteLength = identifierQuoteString.length();
                unquotedName = name.substring(quoteLength, name.length() - quoteLength);
            } else {
                unquotedName = name;
            }
        } else {
            unquotedName = name;
        }
        return unquotedName;
    }
}

