/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.ArrayList;
import java.util.List;
import schemacrawler.crawl.AbstractDependantObject;
import schemacrawler.crawl.MutableIndexColumn;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.schema.Index;
import schemacrawler.schema.IndexColumn;
import schemacrawler.schema.IndexType;
import schemacrawler.schema.NamedObject;
import schemacrawler.schema.Table;
import schemacrawler.utility.CompareUtility;

class MutableIndex
extends AbstractDependantObject<Table>
implements Index {
    private static final long serialVersionUID = 4051326747138079028L;
    private final NamedObjectList<MutableIndexColumn> columns = new NamedObjectList();
    private boolean isUnique;
    private IndexType indexType = IndexType.unknown;
    private int cardinality;
    private int pages;

    MutableIndex(Table parent, String name) {
        super(parent, name);
    }

    @Override
    public int compareTo(NamedObject obj) {
        if (obj == null) {
            return -1;
        }
        Index other = (Index)obj;
        List<IndexColumn> thisColumns = this.getColumns();
        List<IndexColumn> otherColumns = other.getColumns();
        return CompareUtility.compareLists(thisColumns, otherColumns);
    }

    @Override
    public final int getCardinality() {
        return this.cardinality;
    }

    @Override
    public List<IndexColumn> getColumns() {
        return new ArrayList<IndexColumn>(this.columns.values());
    }

    @Override
    public final IndexType getIndexType() {
        return this.indexType;
    }

    @Override
    public final int getPages() {
        return this.pages;
    }

    @Override
    public final IndexType getType() {
        return this.getIndexType();
    }

    @Override
    public boolean isUnique() {
        return this.isUnique;
    }

    void addColumn(MutableIndexColumn column) {
        this.columns.add(column);
    }

    final void setCardinality(int cardinality) {
        this.cardinality = cardinality;
    }

    final void setIndexType(IndexType indexType) {
        if (indexType == null) {
            throw new IllegalArgumentException("Null index type");
        }
        this.indexType = indexType;
    }

    final void setPages(int pages) {
        this.pages = pages;
    }

    final void setUnique(boolean unique) {
        this.isUnique = unique;
    }
}

