/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.analysis.associations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import schemacrawler.schema.ColumnReference;
import schemacrawler.schema.Table;
import schemacrawler.tools.analysis.associations.WeakAssociationsCollector;

public class SimpleWeakAssociationsCollector
implements WeakAssociationsCollector {
    private final Set<ColumnReference> weakAssociations = new HashSet<ColumnReference>();

    public static final List<ColumnReference> getWeakAssociations(Table table) {
        if (table == null) {
            return null;
        }
        Set weakAssociations = (Set)table.getAttribute("schemacrawler.weak_associations", new HashSet());
        ArrayList<ColumnReference> weakAssociationsList = new ArrayList<ColumnReference>(weakAssociations);
        Collections.sort(weakAssociationsList);
        return weakAssociationsList;
    }

    @Override
    public void addWeakAssociation(ColumnReference weakAssociation) {
        if (weakAssociation != null) {
            this.weakAssociations.add(weakAssociation);
            this.addWeakAssociation((Table)weakAssociation.getPrimaryKeyColumn().getParent(), weakAssociation);
            this.addWeakAssociation((Table)weakAssociation.getForeignKeyColumn().getParent(), weakAssociation);
        }
    }

    @Override
    public void clear() {
        this.weakAssociations.clear();
    }

    @Override
    public Collection<ColumnReference> getCollection() {
        return new HashSet<ColumnReference>(this.weakAssociations);
    }

    @Override
    public boolean isEmpty() {
        return this.weakAssociations.isEmpty();
    }

    @Override
    public Iterator<ColumnReference> iterator() {
        return this.weakAssociations.iterator();
    }

    @Override
    public int size() {
        return this.weakAssociations.size();
    }

    private void addWeakAssociation(Table table, ColumnReference weakAssociation) {
        if (table != null && weakAssociation != null) {
            this.weakAssociations.add(weakAssociation);
            Collection tableWeakAssociations = (Collection)table.getAttribute("schemacrawler.weak_associations", new HashSet());
            tableWeakAssociations.add(weakAssociation);
            table.setAttribute("schemacrawler.weak_associations", (Object)tableWeakAssociations);
        }
    }
}

