/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline;

import java.util.logging.Level;
import schemacrawler.tools.commandline.BaseOptionsParser;
import schemacrawler.tools.options.ApplicationOptions;
import sf.util.Utility;
import sf.util.clparser.BooleanOption;
import sf.util.clparser.StringOption;

public final class ApplicationOptionsParser
extends BaseOptionsParser<ApplicationOptions> {
    public ApplicationOptionsParser() {
        super(new StringOption("loglevel", "OFF"), new BooleanOption(Character.valueOf('?'), "help"), new BooleanOption(Character.valueOf('h'), "-help"), new BooleanOption(Character.valueOf('V'), "-version"));
    }

    @Override
    public ApplicationOptions getOptions() {
        ApplicationOptions options = new ApplicationOptions();
        String logLevelString = this.getStringValue("loglevel");
        if (!Utility.isBlank((String)logLevelString)) {
            Level applicationLogLevel = Level.parse(logLevelString.toUpperCase());
            options.setApplicationLogLevel(applicationLogLevel);
        }
        if (this.getBooleanValue("?") || this.getBooleanValue("h")) {
            options.setShowHelp(true);
        }
        if (this.getBooleanValue("V") || this.getBooleanValue("-version")) {
            options.setShowHelp(true);
            options.setShowVersionOnly(true);
        }
        return options;
    }
}

