/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.graph;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.tools.integration.graph.ProcessExecutor;
import sf.util.Utility;

final class GraphGenerator {
    private static final Logger LOGGER = Logger.getLogger(GraphGenerator.class.getName());
    private final String graphVizOptions;
    private final File dotFile;
    private final String graphOutputFormat;
    private final File diagramFile;
    private final boolean echo;

    GraphGenerator(String graphVizOptions, File dotFile, String outputFormat, File diagramOutputFile) throws IOException {
        this.graphVizOptions = graphVizOptions == null ? "" : graphVizOptions;
        if (dotFile == null || dotFile.isDirectory() || !dotFile.exists() || !dotFile.canRead()) {
            throw new IOException("Cannot read the input DOT file, " + dotFile);
        }
        this.dotFile = dotFile;
        this.echo = "echo".equals(outputFormat);
        this.graphOutputFormat = this.determineGraphOutputFormat(outputFormat);
        this.diagramFile = this.determineDiagramFile(diagramOutputFile);
    }

    void generateDiagram() throws IOException {
        if (this.echo) {
            Utility.copyFile((File)this.dotFile, (File)this.diagramFile);
            return;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add("dot");
        command.addAll(Arrays.asList(this.graphVizOptions.split("\\s+")));
        command.add("-T");
        command.add(this.graphOutputFormat);
        command.add("-o");
        command.add(this.diagramFile.getAbsolutePath());
        command.add(this.dotFile.getAbsolutePath());
        ProcessExecutor processExecutor = new ProcessExecutor(command);
        int exitCode = processExecutor.execute();
        String processOutput = processExecutor.getProcessOutput();
        if (!Utility.isBlank((String)processOutput)) {
            LOGGER.log(Level.INFO, processOutput);
        }
        String processError = processExecutor.getProcessError();
        if (exitCode != 0) {
            throw new IOException(String.format("Process returned exit code %d%n%s", exitCode, processError));
        }
        if (!Utility.isBlank((String)processError)) {
            LOGGER.log(Level.WARNING, processError);
        }
    }

    private File determineDiagramFile(File diagramOutputFile) {
        File diagramFile = diagramOutputFile == null ? new File(".", "schemacrawler." + UUID.randomUUID() + "." + this.graphOutputFormat) : diagramOutputFile;
        return diagramFile;
    }

    private String determineGraphOutputFormat(String outputFormat) {
        String graphOutputFormat = outputFormat;
        List<String> outputFormats = Arrays.asList("canon", "cmap", "cmapx", "cmapx_np", "dot", "eps", "fig", "gd", "gd2", "gif", "gv", "imap", "imap_np", "ismap", "jpe", "jpeg", "jpg", "pdf", "plain", "plain-ext", "png", "ps", "ps2", "svg", "svgz", "tk", "vml", "vmlz", "vrml", "wbmp", "xdot");
        if (Utility.isBlank((String)graphOutputFormat) || !outputFormats.contains(graphOutputFormat)) {
            graphOutputFormat = "png";
        }
        return graphOutputFormat;
    }
}

