/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.DatabaseInfoRetriever;
import schemacrawler.crawl.MutableDatabase;
import schemacrawler.crawl.MutableFunction;
import schemacrawler.crawl.MutableProcedure;
import schemacrawler.crawl.MutableRoutine;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.MutableView;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.ResultsRetriever;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.crawl.RoutineExRetriever;
import schemacrawler.crawl.RoutineFilter;
import schemacrawler.crawl.RoutineRetriever;
import schemacrawler.crawl.SchemaRetriever;
import schemacrawler.crawl.SynonymRetriever;
import schemacrawler.crawl.TableExRetriever;
import schemacrawler.crawl.TableFilter;
import schemacrawler.crawl.TableRetriever;
import schemacrawler.crawl.TablesGraph;
import schemacrawler.schema.Database;
import schemacrawler.schema.ResultsColumns;
import schemacrawler.schema.RoutineType;
import schemacrawler.schema.Schema;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerSQLException;
import schemacrawler.schemacrawler.SchemaInfoLevel;

public final class SchemaCrawler {
    private static final Logger LOGGER = Logger.getLogger(SchemaCrawler.class.getName());
    private final Connection connection;

    public static ResultsColumns getResultColumns(ResultSet resultSet) {
        ResultsColumns resultColumns = null;
        try {
            ResultsRetriever resultsRetriever = new ResultsRetriever(resultSet);
            resultColumns = resultsRetriever.retrieveResults();
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, e.getMessage(), e);
            resultColumns = null;
        }
        return resultColumns;
    }

    private static void crawlColumnDataTypes(MutableDatabase database, RetrieverConnection retrieverConnection, SchemaCrawlerOptions options) throws SchemaCrawlerException {
        try {
            SchemaInfoLevel infoLevel = options.getSchemaInfoLevel();
            DatabaseInfoRetriever retriever = new DatabaseInfoRetriever(retrieverConnection, database);
            if (infoLevel.isRetrieveColumnDataTypes()) {
                retriever.retrieveSystemColumnDataTypes();
            }
            if (infoLevel.isRetrieveUserDefinedColumnDataTypes()) {
                for (Schema schema : retriever.getSchemas()) {
                    retriever.retrieveUserDefinedColumnDataTypes(schema.getCatalogName(), schema.getName());
                }
            }
        }
        catch (SQLException e) {
            throw new SchemaCrawlerException("Exception retrieving column data type information", e);
        }
    }

    private static void crawlDatabaseInfo(MutableDatabase database, RetrieverConnection retrieverConnection, SchemaCrawlerOptions options) throws SchemaCrawlerException {
        try {
            SchemaInfoLevel infoLevel = options.getSchemaInfoLevel();
            DatabaseInfoRetriever retriever = new DatabaseInfoRetriever(retrieverConnection, database);
            if (infoLevel.isRetrieveSchemaCrawlerInfo()) {
                retriever.retrieveSchemaCrawlerInfo();
                if (infoLevel.isRetrieveAdditionalSchemaCrawlerInfo()) {
                    retriever.retrieveAdditionalSchemaCrawlerInfo();
                }
            }
            if (infoLevel.isRetrieveDatabaseInfo()) {
                retriever.retrieveDatabaseInfo();
                if (infoLevel.isRetrieveAdditionalDatabaseInfo()) {
                    retriever.retrieveAdditionalDatabaseInfo();
                }
            }
            if (infoLevel.isRetrieveJdbcDriverInfo()) {
                retriever.retrieveJdbcDriverInfo();
                if (infoLevel.isRetrieveAdditionalJdbcDriverInfo()) {
                    retriever.retrieveAdditionalJdbcDriverInfo();
                }
            }
        }
        catch (SQLException e) {
            throw new SchemaCrawlerException("Exception retrieving database information", e);
        }
    }

    private static void crawlRoutines(MutableDatabase database, RetrieverConnection retrieverConnection, SchemaCrawlerOptions options) throws SchemaCrawlerException {
        SchemaInfoLevel infoLevel = options.getSchemaInfoLevel();
        boolean retrieveRoutines = infoLevel.isRetrieveRoutines();
        if (!retrieveRoutines) {
            return;
        }
        try {
            RoutineRetriever retriever = new RoutineRetriever(retrieverConnection, database);
            RoutineExRetriever retrieverExtra = new RoutineExRetriever(retrieverConnection, database);
            Collection<RoutineType> routineTypes = options.getRoutineTypes();
            for (Schema schema : retriever.getSchemas()) {
                if (routineTypes.contains((Object)RoutineType.procedure)) {
                    retriever.retrieveProcedures(schema.getCatalogName(), schema.getName(), options.getRoutineInclusionRule());
                }
                if (!routineTypes.contains((Object)RoutineType.function)) continue;
                retriever.retrieveFunctions(schema.getCatalogName(), schema.getName(), options.getRoutineInclusionRule());
            }
            NamedObjectList<MutableRoutine> allRoutines = database.getAllRoutines();
            for (MutableRoutine routine : allRoutines) {
                if (!infoLevel.isRetrieveRoutineColumns()) continue;
                if (routine instanceof MutableProcedure && routineTypes.contains((Object)RoutineType.procedure)) {
                    retriever.retrieveProcedureColumns((MutableProcedure)routine, options.getRoutineColumnInclusionRule());
                }
                if (!(routine instanceof MutableFunction) || !routineTypes.contains((Object)RoutineType.function)) continue;
                retriever.retrieveFunctionColumns((MutableFunction)routine, options.getRoutineColumnInclusionRule());
            }
            RoutineFilter routineFiter = new RoutineFilter(options, allRoutines);
            routineFiter.filter();
            if (infoLevel.isRetrieveRoutineInformation()) {
                retrieverExtra.retrieveRoutineInformation();
            }
        }
        catch (SQLException e) {
            if (e instanceof SchemaCrawlerSQLException) {
                Throwable cause = e.getCause();
                throw new SchemaCrawlerException(e.getMessage() + ": " + cause.getMessage(), cause);
            }
            throw new SchemaCrawlerException("Exception retrieving routines", e);
        }
    }

    private static void crawlSchemas(MutableDatabase database, RetrieverConnection retrieverConnection, SchemaCrawlerOptions options) throws SchemaCrawlerException {
        try {
            SchemaRetriever retriever = new SchemaRetriever(retrieverConnection, database);
            retriever.retrieveSchemas(options.getSchemaInclusionRule());
        }
        catch (SQLException e) {
            throw new SchemaCrawlerException("Exception retrieving database information", e);
        }
    }

    private static void crawlSynonyms(MutableDatabase database, RetrieverConnection retrieverConnection, SchemaCrawlerOptions options) throws SchemaCrawlerException {
        SchemaInfoLevel infoLevel = options.getSchemaInfoLevel();
        boolean retrieveSynonyms = infoLevel.isRetrieveSynonymInformation();
        if (!retrieveSynonyms) {
            return;
        }
        try {
            SynonymRetriever retrieverExtra = new SynonymRetriever(retrieverConnection, database);
            retrieverExtra.retrieveSynonymInformation(options.getSynonymInclusionRule());
        }
        catch (SQLException e) {
            if (e instanceof SchemaCrawlerSQLException) {
                Throwable cause = e.getCause();
                throw new SchemaCrawlerException(e.getMessage() + ": " + cause.getMessage(), cause);
            }
            throw new SchemaCrawlerException("Exception retrieving schemas", e);
        }
    }

    private static void crawlTables(MutableDatabase database, RetrieverConnection retrieverConnection, SchemaCrawlerOptions options) throws SchemaCrawlerException {
        SchemaInfoLevel infoLevel = options.getSchemaInfoLevel();
        boolean retrieveTables = infoLevel.isRetrieveTables();
        if (!retrieveTables) {
            return;
        }
        try {
            TableRetriever retriever = new TableRetriever(retrieverConnection, database);
            TableExRetriever retrieverExtra = new TableExRetriever(retrieverConnection, database);
            for (Schema schema : retriever.getSchemas()) {
                retriever.retrieveTables(schema.getCatalogName(), schema.getName(), options.getTableNamePattern(), options.getTableTypes(), options.getTableInclusionRule());
            }
            NamedObjectList<MutableTable> allTables = database.getAllTables();
            for (MutableTable table : allTables) {
                if (!infoLevel.isRetrieveTableColumns()) continue;
                retriever.retrieveColumns(table, options.getColumnInclusionRule());
            }
            if (!infoLevel.isRetrieveForeignKeys()) {
                LOGGER.log(Level.WARNING, "Foreign-keys are not being retrieved, so tables cannot be sorted using the natural sort order");
            }
            for (MutableTable table : allTables) {
                boolean isView = table instanceof MutableView;
                if (isView || !infoLevel.isRetrieveTableColumns()) continue;
                retriever.retrievePrimaryKey(table);
                if (infoLevel.isRetrieveIndices()) {
                    retriever.retrieveIndices(table, true);
                    retriever.retrieveIndices(table, false);
                    table.replacePrimaryKey();
                }
                if (!infoLevel.isRetrieveForeignKeys()) continue;
                retriever.retrieveForeignKeys(table);
            }
            TablesGraph tablesGraph = new TablesGraph(allTables);
            tablesGraph.setTablesSortIndices();
            TableFilter tableFiter = new TableFilter(options, allTables);
            tableFiter.filter();
            if (infoLevel.isRetrieveCheckConstraintInformation()) {
                retrieverExtra.retrieveCheckConstraintInformation();
            }
            if (infoLevel.isRetrieveTriggerInformation()) {
                retrieverExtra.retrieveTriggerInformation();
            }
            if (infoLevel.isRetrieveViewInformation()) {
                retrieverExtra.retrieveViewInformation();
            }
            if (infoLevel.isRetrieveAdditionalTableAttributes()) {
                retrieverExtra.retrieveAdditionalTableAttributes();
            }
            if (infoLevel.isRetrieveTablePrivileges()) {
                retrieverExtra.retrieveTablePrivileges();
            }
            if (infoLevel.isRetrieveAdditionalColumnAttributes()) {
                retrieverExtra.retrieveAdditionalColumnAttributes();
            }
            if (infoLevel.isRetrieveTableColumnPrivileges()) {
                retrieverExtra.retrieveTableColumnPrivileges();
            }
        }
        catch (SQLException e) {
            if (e instanceof SchemaCrawlerSQLException) {
                Throwable cause = e.getCause();
                throw new SchemaCrawlerException(e.getMessage() + ": " + cause.getMessage(), cause);
            }
            throw new SchemaCrawlerException("Exception retrieving tables", e);
        }
    }

    public SchemaCrawler(Connection connection) throws SchemaCrawlerException {
        if (connection == null) {
            throw new SchemaCrawlerException("No connection specified");
        }
        this.connection = connection;
    }

    public Database crawl(SchemaCrawlerOptions options) throws SchemaCrawlerException {
        MutableDatabase database = new MutableDatabase("database");
        RetrieverConnection retrieverConnection = null;
        try {
            SchemaCrawlerOptions schemaCrawlerOptions = options;
            if (schemaCrawlerOptions == null) {
                schemaCrawlerOptions = new SchemaCrawlerOptions();
            }
            retrieverConnection = new RetrieverConnection(this.connection, schemaCrawlerOptions);
            SchemaCrawler.crawlSchemas(database, retrieverConnection, schemaCrawlerOptions);
            SchemaCrawler.crawlDatabaseInfo(database, retrieverConnection, schemaCrawlerOptions);
            SchemaCrawler.crawlColumnDataTypes(database, retrieverConnection, schemaCrawlerOptions);
            SchemaCrawler.crawlTables(database, retrieverConnection, schemaCrawlerOptions);
            SchemaCrawler.crawlRoutines(database, retrieverConnection, schemaCrawlerOptions);
            SchemaCrawler.crawlSynonyms(database, retrieverConnection, schemaCrawlerOptions);
            return database;
        }
        catch (SQLException e) {
            throw new SchemaCrawlerException("Database access exception", e);
        }
    }
}

