/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schemacrawler.Options;
import sf.util.ObjectToString;
import sf.util.Utility;

public final class Config
extends HashMap<String, String>
implements Options {
    private static final long serialVersionUID = 8720699738076915453L;
    private static final Logger LOGGER = Logger.getLogger(Config.class.getName());

    public static Config load(String ... configFilenames) {
        Properties configProperties = new Properties();
        if (configFilenames != null) {
            for (String configFilename : configFilenames) {
                if (Utility.isBlank(configFilename)) continue;
                configProperties = Config.loadProperties(configProperties, new File(configFilename));
            }
        }
        return new Config(configProperties);
    }

    public static Config loadResource(String resource) {
        Properties configProperties = new Properties();
        InputStream stream = !Utility.isBlank(resource) ? Config.class.getResourceAsStream(resource) : null;
        if (stream != null) {
            configProperties = Config.loadProperties(configProperties, new InputStreamReader(stream));
        }
        return new Config(configProperties);
    }

    private static Properties loadProperties(Properties properties, File propertiesFile) {
        try {
            Config.loadProperties(properties, new FileReader(propertiesFile));
        }
        catch (FileNotFoundException e) {
            LOGGER.log(Level.WARNING, "Cannot load properties from file, " + propertiesFile.getAbsolutePath());
            LOGGER.log(Level.FINEST, e.getMessage(), e);
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(Properties properties, Reader reader) {
        if (properties == null || reader == null) {
            LOGGER.log(Level.WARNING, "No properties provided");
        }
        try {
            properties.load(new BufferedReader(reader));
            reader.close();
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Error loading properties", e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Error closing stream", e);
            }
        }
        return properties;
    }

    private static Map<String, String> propertiesMap(Properties properties) {
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        if (properties != null) {
            Set<Map.Entry<Object, Object>> entries = properties.entrySet();
            for (Map.Entry<Object, Object> entry : entries) {
                propertiesMap.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return propertiesMap;
    }

    public Config() {
    }

    public Config(Config config) {
        if (config != null) {
            this.putAll(config);
        }
    }

    public Config(Properties properties) {
        super(Config.propertiesMap(properties));
    }

    public boolean getBooleanValue(String propertyName) {
        return this.getBooleanValue(propertyName, false);
    }

    public boolean getBooleanValue(String propertyName, boolean defaultValue) {
        return Boolean.parseBoolean(this.getStringValue(propertyName, Boolean.toString(defaultValue)));
    }

    public <E extends Enum<E>> E getEnumValue(String propertyName, E defaultValue) {
        Object enumValue;
        String value = this.getStringValue(propertyName, defaultValue.name());
        if (value == null || defaultValue == null) {
            enumValue = defaultValue;
        } else {
            try {
                enumValue = Enum.valueOf(defaultValue.getClass(), value);
            }
            catch (Exception e) {
                enumValue = defaultValue;
            }
        }
        return enumValue;
    }

    public int getIntegerValue(String propertyName, int defaultValue) {
        return Integer.parseInt(this.getStringValue(propertyName, String.valueOf(defaultValue)));
    }

    public String getStringValue(String propertyName, String defaultValue) {
        String value = (String)this.get(propertyName);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public boolean hasValue(String propertyName) {
        return super.containsKey(propertyName);
    }

    @Override
    public String toString() {
        return ObjectToString.toString(this);
    }
}

