/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.ArrayList;
import java.util.List;
import schemacrawler.crawl.MutableFunctionColumn;
import schemacrawler.crawl.MutableRoutine;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.schema.Function;
import schemacrawler.schema.FunctionColumn;
import schemacrawler.schema.FunctionReturnType;
import schemacrawler.schema.RoutineBodyType;
import schemacrawler.schema.RoutineType;
import schemacrawler.schema.Schema;

final class MutableFunction
extends MutableRoutine
implements Function {
    private static final long serialVersionUID = 3906925686089134130L;
    private FunctionReturnType returnType;
    private final NamedObjectList<MutableFunctionColumn> columns = new NamedObjectList();
    private RoutineBodyType routineBodyType;

    MutableFunction(Schema schema, String name) {
        super(schema, name);
        this.returnType = FunctionReturnType.unknown;
        this.routineBodyType = RoutineBodyType.unknown;
    }

    @Override
    public MutableFunctionColumn getColumn(String name) {
        return this.columns.lookup(this, name);
    }

    @Override
    public List<FunctionColumn> getColumns() {
        return new ArrayList<FunctionColumn>(this.columns.values());
    }

    @Override
    public FunctionReturnType getReturnType() {
        return this.returnType;
    }

    @Override
    public RoutineBodyType getRoutineBodyType() {
        return this.routineBodyType;
    }

    @Override
    public RoutineType getRoutineType() {
        return RoutineType.function;
    }

    void addColumn(MutableFunctionColumn column) {
        this.columns.add(column);
    }

    void setReturnType(FunctionReturnType returnType) {
        if (returnType == null) {
            throw new IllegalArgumentException("Null function return type");
        }
        this.returnType = returnType;
    }

    @Override
    void setRoutineBodyType(RoutineBodyType routineBodyType) {
        this.routineBodyType = routineBodyType;
    }
}

