/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.filter;

import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.filter.NamedObjectFilter;
import schemacrawler.schema.Column;
import schemacrawler.schema.Table;
import schemacrawler.schema.Trigger;
import schemacrawler.schemacrawler.InclusionRule;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;

class TableGrepFilter
implements NamedObjectFilter<Table> {
    private static final Logger LOGGER = Logger.getLogger(TableGrepFilter.class.getName());
    private final boolean invertMatch;
    private final InclusionRule grepColumnInclusionRule;
    private final InclusionRule grepDefinitionInclusionRule;

    public TableGrepFilter(SchemaCrawlerOptions options) {
        this.invertMatch = options.isGrepInvertMatch();
        this.grepColumnInclusionRule = options.getGrepColumnInclusionRule();
        this.grepDefinitionInclusionRule = options.getGrepDefinitionInclusionRule();
    }

    @Override
    public boolean include(Table table) {
        boolean include;
        boolean checkIncludeForDefinitions;
        boolean checkIncludeForColumns = this.grepColumnInclusionRule != null;
        boolean bl = checkIncludeForDefinitions = this.grepDefinitionInclusionRule != null;
        if (!checkIncludeForColumns && !checkIncludeForDefinitions) {
            return true;
        }
        boolean includeForColumns = false;
        boolean includeForDefinitions = false;
        for (Column column : table.getColumns()) {
            if (checkIncludeForColumns && this.grepColumnInclusionRule.include(column.getFullName())) {
                includeForColumns = true;
                break;
            }
            if (!checkIncludeForDefinitions || !this.grepDefinitionInclusionRule.include(column.getRemarks())) continue;
            includeForDefinitions = true;
            break;
        }
        if (checkIncludeForDefinitions) {
            if (this.grepDefinitionInclusionRule.include(table.getRemarks())) {
                includeForDefinitions = true;
            }
            if (this.grepDefinitionInclusionRule.include(table.getDefinition())) {
                includeForDefinitions = true;
            }
            for (Trigger trigger : table.getTriggers()) {
                if (!this.grepDefinitionInclusionRule.include(trigger.getActionStatement())) continue;
                includeForDefinitions = true;
                break;
            }
        }
        boolean bl2 = include = checkIncludeForColumns && includeForColumns || checkIncludeForDefinitions && includeForDefinitions;
        if (this.invertMatch) {
            boolean bl3 = include = !include;
        }
        if (!include) {
            LOGGER.log(Level.FINE, "Removing table " + table + " since it does not match the grep pattern");
        }
        return include;
    }
}

