/*
 * Decompiled with CFR 0.152.
 */
package sf.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sf.util.GraphException;

public class DirectedGraph<T extends Comparable<? super T>> {
    private final Map<T, Vertex> verticesMap = new HashMap<T, Vertex>();
    private final Set<DirectedEdge> edges = new HashSet<DirectedEdge>();

    public void addDirectedEdge(T from, T to) {
        if (!from.equals(to)) {
            this.edges.add(new DirectedEdge(this.addVertex(from), this.addVertex(to)));
        }
    }

    public Vertex addVertex(T value) {
        Vertex vertex;
        if (this.verticesMap.containsKey(value)) {
            vertex = this.verticesMap.get(value);
        } else {
            vertex = new Vertex(this, value);
            this.verticesMap.put(value, vertex);
        }
        return vertex;
    }

    public boolean containsCycle() {
        Collection<Vertex> vertices = this.clearTraversalStates();
        for (Vertex vertex : vertices) {
            if (vertex.getTraversalState() != TraversalState.notStarted || !this.visitForCyles(vertex)) continue;
            return true;
        }
        return false;
    }

    public DirectedGraph<T> subGraph(T value) {
        return this.subGraph(value, -1);
    }

    public DirectedGraph<T> subGraph(T value, int depth) {
        Collection<Vertex> vertices = this.clearTraversalStates();
        this.visitForSubGraph(this.verticesMap.get(value), depth);
        HashSet<Vertex> subGraphVertices = new HashSet<Vertex>();
        for (Vertex currentVertex : vertices) {
            if (currentVertex.getTraversalState() != TraversalState.complete) continue;
            subGraphVertices.add(currentVertex);
        }
        DirectedGraph<T> subGraph = new DirectedGraph<T>();
        for (DirectedEdge edge : this.edges) {
            Vertex from = edge.getFrom();
            Vertex to = edge.getTo();
            if (!subGraphVertices.contains(from) || !subGraphVertices.contains(to)) continue;
            subGraph.addDirectedEdge(from.getValue(), to.getValue());
        }
        subGraph.addVertex(value);
        return subGraph;
    }

    public List<T> topologicalSort() throws GraphException {
        if (this.containsCycle()) {
            throw new GraphException("Graph contains a cycle, so cannot be topologically sorted");
        }
        int collectionSize = this.verticesMap.size();
        ArrayList<Vertex> vertices = new ArrayList<Vertex>(this.verticesMap.values());
        ArrayList<DirectedEdge> edges = new ArrayList<DirectedEdge>(this.edges);
        ArrayList sortedValues = new ArrayList(collectionSize);
        while (!vertices.isEmpty()) {
            ArrayList nodesAtLevel = new ArrayList(collectionSize);
            Iterator iterator = vertices.iterator();
            while (iterator.hasNext()) {
                Vertex vertex = (Vertex)iterator.next();
                if (!this.isUnattachedNode(vertex, edges)) continue;
                nodesAtLevel.add(vertex.getValue());
                iterator.remove();
            }
            ArrayList<Vertex> startNodes = new ArrayList<Vertex>(collectionSize);
            for (Vertex vertex : vertices) {
                if (!this.isStartNode(vertex, edges)) continue;
                startNodes.add(vertex);
            }
            for (Vertex vertex : startNodes) {
                nodesAtLevel.add(vertex.getValue());
                this.dropOutEdges(vertex, edges);
                vertices.remove(vertex);
            }
            Collections.sort(nodesAtLevel);
            sortedValues.addAll(nodesAtLevel);
        }
        return sortedValues;
    }

    private Collection<Vertex> clearTraversalStates() {
        Collection<Vertex> vertices = this.verticesMap.values();
        for (Vertex vertex : vertices) {
            vertex.setTraversalState(TraversalState.notStarted);
        }
        return vertices;
    }

    private void dropOutEdges(Vertex vertex, Collection<DirectedEdge> edges) {
        Iterator<DirectedEdge> iterator = edges.iterator();
        while (iterator.hasNext()) {
            DirectedEdge edge = iterator.next();
            if (!edge.isFrom(vertex)) continue;
            iterator.remove();
        }
    }

    private boolean isStartNode(Vertex vertex, Collection<DirectedEdge> edges) {
        for (DirectedEdge edge : edges) {
            if (!edge.isTo(vertex)) continue;
            return false;
        }
        return true;
    }

    private boolean isUnattachedNode(Vertex vertex, Collection<DirectedEdge> edges) {
        for (DirectedEdge edge : edges) {
            if (!edge.isTo(vertex) && !edge.isFrom(vertex)) continue;
            return false;
        }
        return true;
    }

    private boolean visitForCyles(Vertex vertex) {
        vertex.setTraversalState(TraversalState.inProgress);
        for (DirectedEdge edge : this.edges) {
            if (!edge.isFrom(vertex)) continue;
            Vertex to = edge.getTo();
            if (to.getTraversalState() == TraversalState.inProgress) {
                return true;
            }
            if (to.getTraversalState() != TraversalState.notStarted || !this.visitForCyles(to)) continue;
            return true;
        }
        vertex.setTraversalState(TraversalState.complete);
        return false;
    }

    private void visitForSubGraph(Vertex vertex, int depth) {
        vertex.setTraversalState(TraversalState.complete);
        if (depth == 0) {
            return;
        }
        for (DirectedEdge edge : this.edges) {
            if (!edge.isFrom(vertex)) continue;
            this.visitForSubGraph(edge.getTo(), depth - 1);
        }
    }

    private static enum TraversalState {
        notStarted,
        inProgress,
        complete;

    }

    public static class Vertex {
        private final T value;
        private TraversalState traversalState = TraversalState.notStarted;
        final /* synthetic */ DirectedGraph this$0;

        Vertex(T value) {
            this.this$0 = var1_1;
            this.value = value;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            Vertex other = (Vertex)obj;
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        public T getValue() {
            return this.value;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public String toString() {
            return this.value.toString();
        }

        TraversalState getTraversalState() {
            return this.traversalState;
        }

        void setTraversalState(TraversalState traversalState) {
            this.traversalState = traversalState;
        }
    }

    public class DirectedEdge {
        private final Vertex from;
        private final Vertex to;

        DirectedEdge(Vertex from, Vertex to) {
            this.from = from;
            this.to = to;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            DirectedEdge other = (DirectedEdge)obj;
            if (this.from == null ? other.from != null : !this.from.equals(other.from)) {
                return false;
            }
            return !(this.to == null ? other.to != null : !this.to.equals(other.to));
        }

        public Vertex getFrom() {
            return this.from;
        }

        public Vertex getTo() {
            return this.to;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.from == null ? 0 : this.from.hashCode());
            result = 31 * result + (this.to == null ? 0 : this.to.hashCode());
            return result;
        }

        public boolean isFrom(Vertex vertex) {
            return vertex != null && vertex.equals(this.from);
        }

        public boolean isTo(Vertex vertex) {
            return vertex != null && vertex.equals(this.to);
        }

        public String toString() {
            return "(" + this.from + " --> " + this.to + ")";
        }
    }
}

