/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.executable;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schema.Database;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.executable.BaseStagedExecutable;
import schemacrawler.tools.executable.CommandRegistry;
import schemacrawler.tools.executable.Executable;

abstract class BaseCommandChainExecutable
extends BaseStagedExecutable {
    private static final Logger LOGGER = Logger.getLogger(BaseCommandChainExecutable.class.getName());
    private final List<Executable> executables;
    private final CommandRegistry commandRegistry = new CommandRegistry();

    protected BaseCommandChainExecutable(String command) throws SchemaCrawlerException {
        super(command);
        this.executables = new ArrayList<Executable>();
    }

    public final Executable addNext(Executable executable) {
        if (executable != null) {
            this.executables.add(executable);
        }
        return executable;
    }

    public final Executable addNext(String command) throws SchemaCrawlerException {
        try {
            Executable executable = this.commandRegistry.configureNewExecutable(command, this.schemaCrawlerOptions, this.outputOptions);
            if (executable == null) {
                return executable;
            }
            executable.setAdditionalConfiguration(this.additionalConfiguration);
            return this.addNext(executable);
        }
        catch (Exception e) {
            throw new SchemaCrawlerException(String.format("Cannot chain executable, unknown command, %s", command));
        }
    }

    protected final void executeChain(Database database, Connection connection) throws Exception {
        if (this.executables.isEmpty()) {
            LOGGER.log(Level.INFO, "No commands to execute");
            return;
        }
        for (Executable executable : this.executables) {
            if (!(executable instanceof BaseStagedExecutable)) continue;
            ((BaseStagedExecutable)executable).executeOn(database, connection);
        }
    }
}

