/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.ColumnReference;
import schemacrawler.schema.ConditionTimingType;
import schemacrawler.schema.EventManipulationType;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.ForeignKeyColumnReference;
import schemacrawler.schema.ForeignKeyUpdateRule;
import schemacrawler.schema.Index;
import schemacrawler.schema.IndexColumn;
import schemacrawler.schema.IndexType;
import schemacrawler.schema.PrimaryKey;
import schemacrawler.schema.Privilege;
import schemacrawler.schema.Routine;
import schemacrawler.schema.RoutineColumn;
import schemacrawler.schema.Sequence;
import schemacrawler.schema.Synonym;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableConstraint;
import schemacrawler.schema.TableConstraintColumn;
import schemacrawler.schema.TableConstraintType;
import schemacrawler.schema.Trigger;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.analysis.associations.DatabaseWithAssociations;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.text.base.BaseJsonFormatter;
import schemacrawler.tools.text.schema.SchemaTextDetailType;
import schemacrawler.tools.text.schema.SchemaTextOptions;
import schemacrawler.tools.text.utility.org.json.JSONArray;
import schemacrawler.tools.text.utility.org.json.JSONException;
import schemacrawler.tools.text.utility.org.json.JSONObject;
import schemacrawler.tools.traversal.SchemaTraversalHandler;
import schemacrawler.utility.NamedObjectSort;

final class SchemaJsonFormatter
extends BaseJsonFormatter<SchemaTextOptions>
implements SchemaTraversalHandler {
    private final boolean isVerbose;
    private final boolean isList;

    SchemaJsonFormatter(SchemaTextDetailType schemaTextDetailType, SchemaTextOptions options, OutputOptions outputOptions) throws SchemaCrawlerException {
        super(options, schemaTextDetailType == SchemaTextDetailType.details, outputOptions);
        this.isVerbose = schemaTextDetailType == SchemaTextDetailType.details;
        this.isList = schemaTextDetailType == SchemaTextDetailType.list;
    }

    @Override
    public void handle(ColumnDataType columnDataType) throws SchemaCrawlerException {
        if (this.printVerboseDatabaseInfo && this.isVerbose) {
            try {
                JSONObject jsonColumnDataType = new JSONObject();
                this.jsonRoot.accumulate("columnDataypes", jsonColumnDataType);
                String databaseSpecificTypeName = ((SchemaTextOptions)this.options).isShowUnqualifiedNames() ? columnDataType.getName() : columnDataType.getFullName();
                jsonColumnDataType.put("databaseSpecificTypeName", databaseSpecificTypeName);
                jsonColumnDataType.put("basedOn", columnDataType.getBaseType() == null ? "" : columnDataType.getBaseType().getName());
                jsonColumnDataType.put("userDefined", columnDataType.isUserDefined());
                jsonColumnDataType.put("createParameters", columnDataType.getCreateParameters());
                jsonColumnDataType.put("nullable", columnDataType.isNullable());
                jsonColumnDataType.put("autoIncrementable", columnDataType.isAutoIncrementable());
                jsonColumnDataType.put("searchable", columnDataType.getSearchable().toString());
            }
            catch (JSONException e) {
                LOGGER.log(Level.FINER, "Error outputting ColumnDataType: " + e.getMessage(), e);
            }
        }
    }

    @Override
    public void handle(Routine routine) {
        try {
            JSONObject jsonRoutine = new JSONObject();
            this.jsonRoot.accumulate("routines", jsonRoutine);
            jsonRoutine.put("name", routine.getName());
            if (!((SchemaTextOptions)this.options).isShowUnqualifiedNames()) {
                jsonRoutine.put("fullName", routine.getFullName());
            }
            jsonRoutine.put("type", routine.getRoutineType());
            jsonRoutine.put("returnType", routine.getReturnType());
            if (!this.isList) {
                JSONArray jsonParameters = new JSONArray();
                jsonRoutine.put("parameters", jsonParameters);
                List columns = routine.getColumns();
                Collections.sort(columns, NamedObjectSort.getNamedObjectSort((boolean)((SchemaTextOptions)this.options).isAlphabeticalSortForRoutineColumns()));
                for (RoutineColumn column : columns) {
                    jsonParameters.put(this.handleRoutineColumn(column));
                }
                if (routine.hasDefinition()) {
                    jsonRoutine.put("definition", routine.getDefinition());
                }
                if (this.isVerbose) {
                    if (!((SchemaTextOptions)this.options).isHideRoutineSpecificNames()) {
                        jsonRoutine.put("specificName", routine.getSpecificName());
                    }
                    jsonRoutine.put("remarks", routine.getRemarks());
                }
            }
        }
        catch (JSONException e) {
            LOGGER.log(Level.FINER, "Error outputting Routine: " + e.getMessage(), e);
        }
    }

    @Override
    public void handle(Sequence sequence) {
        try {
            JSONObject jsonSequence = new JSONObject();
            this.jsonRoot.accumulate("sequences", jsonSequence);
            jsonSequence.put("name", sequence.getName());
            if (!((SchemaTextOptions)this.options).isShowUnqualifiedNames()) {
                jsonSequence.put("fullName", sequence.getFullName());
            }
            jsonSequence.put("increment", sequence.getIncrement());
            jsonSequence.put("minimumValue", sequence.getMinimumValue());
            jsonSequence.put("maximumValue", sequence.getMaximumValue());
            jsonSequence.put("cycle", sequence.isCycle());
            if (this.isVerbose) {
                jsonSequence.put("remarks", sequence.getRemarks());
            }
        }
        catch (JSONException e) {
            LOGGER.log(Level.FINER, "Error outputting Sequence: " + e.getMessage(), e);
        }
    }

    @Override
    public void handle(Synonym synonym) {
        try {
            JSONObject jsonSynonym = new JSONObject();
            this.jsonRoot.accumulate("synonyms", jsonSynonym);
            jsonSynonym.put("name", synonym.getName());
            if (!((SchemaTextOptions)this.options).isShowUnqualifiedNames()) {
                jsonSynonym.put("fullName", synonym.getFullName());
            }
            String referencedObjectName = ((SchemaTextOptions)this.options).isShowUnqualifiedNames() ? synonym.getReferencedObject().getName() : synonym.getReferencedObject().getFullName();
            jsonSynonym.put("referencedObject", referencedObjectName);
            if (this.isVerbose) {
                jsonSynonym.put("remarks", synonym.getRemarks());
            }
        }
        catch (JSONException e) {
            LOGGER.log(Level.FINER, "Error outputting Synonym: " + e.getMessage(), e);
        }
    }

    @Override
    public void handle(Table table) {
        JSONObject jsonTable = new JSONObject();
        try {
            this.jsonRoot.accumulate("tables", jsonTable);
            jsonTable.put("name", table.getName());
            if (!((SchemaTextOptions)this.options).isShowUnqualifiedNames()) {
                jsonTable.put("fullName", table.getFullName());
            }
            jsonTable.put("type", table.getTableType());
            if (!this.isList) {
                JSONArray jsonColumns = new JSONArray();
                jsonTable.put("columns", jsonColumns);
                List columns = table.getColumns();
                Collections.sort(columns, NamedObjectSort.getNamedObjectSort((boolean)((SchemaTextOptions)this.options).isAlphabeticalSortForTableColumns()));
                for (Column column : columns) {
                    jsonColumns.put(this.handleTableColumn(column));
                }
                jsonTable.put("primaryKey", this.handleIndex((Index)table.getPrimaryKey()));
                jsonTable.put("foreignKeys", this.handleForeignKeys(table.getForeignKeys()));
                if (this.isVerbose) {
                    Collection<ColumnReference> weakAssociationsCollection = DatabaseWithAssociations.getWeakAssociations(table);
                    ArrayList<ColumnReference> weakAssociations = new ArrayList<ColumnReference>(weakAssociationsCollection);
                    Collections.sort(weakAssociations);
                    jsonTable.put("weakAssociations", this.handleColumnReferences(weakAssociations));
                }
                JSONArray jsonIndices = new JSONArray();
                jsonTable.put("indices", jsonIndices);
                Collection indicesCollection = table.getIndices();
                ArrayList indices = new ArrayList(indicesCollection);
                Collections.sort(indices, NamedObjectSort.getNamedObjectSort((boolean)((SchemaTextOptions)this.options).isAlphabeticalSortForIndexes()));
                for (Index index : indices) {
                    jsonIndices.put(this.handleIndex(index));
                }
                if (table.hasDefinition()) {
                    jsonTable.put("definition", table.getDefinition());
                }
                jsonTable.put("triggers", this.handleTriggers(table.getTriggers()));
                JSONArray jsonTableConstraints = new JSONArray();
                jsonTable.put("tableConstraints", jsonTableConstraints);
                Collection tableConstraintsCollection = table.getTableConstraints();
                ArrayList tableConstraints = new ArrayList(tableConstraintsCollection);
                Collections.sort(tableConstraints, NamedObjectSort.getNamedObjectSort((boolean)((SchemaTextOptions)this.options).isAlphabeticalSortForIndexes()));
                for (TableConstraint tableConstraint : tableConstraints) {
                    jsonTableConstraints.put(this.handleTableConstraint(tableConstraint));
                }
                if (this.isVerbose) {
                    for (Privilege privilege : table.getPrivileges()) {
                        if (privilege == null) continue;
                        JSONObject jsonPrivilege = new JSONObject();
                        jsonTable.accumulate("privileges", jsonPrivilege);
                        jsonPrivilege.put("name", privilege.getName());
                        for (Privilege.Grant grant : privilege.getGrants()) {
                            JSONObject jsonGrant = new JSONObject();
                            jsonPrivilege.accumulate("grants", jsonGrant);
                            jsonGrant.put("grantor", grant.getGrantor());
                            jsonGrant.put("grantee", grant.getGrantee());
                            jsonGrant.put("grantable", grant.isGrantable());
                        }
                    }
                    jsonTable.put("remarks", table.getRemarks());
                }
            }
        }
        catch (JSONException e) {
            LOGGER.log(Level.FINER, "Error outputting Table: " + e.getMessage(), e);
        }
    }

    @Override
    public void handleColumnDataTypesEnd() {
    }

    @Override
    public void handleColumnDataTypesStart() {
    }

    @Override
    public void handleRoutinesEnd() throws SchemaCrawlerException {
    }

    @Override
    public void handleRoutinesStart() throws SchemaCrawlerException {
    }

    @Override
    public void handleSequencesEnd() throws SchemaCrawlerException {
    }

    @Override
    public void handleSequencesStart() throws SchemaCrawlerException {
    }

    @Override
    public void handleSynonymsEnd() throws SchemaCrawlerException {
    }

    @Override
    public void handleSynonymsStart() throws SchemaCrawlerException {
    }

    @Override
    public void handleTablesEnd() throws SchemaCrawlerException {
    }

    @Override
    public void handleTablesStart() throws SchemaCrawlerException {
    }

    private JSONArray handleColumnReferences(List<? extends ColumnReference> columnReferences) {
        JSONArray jsonColumnReferences = new JSONArray();
        for (ColumnReference columnReference : columnReferences) {
            try {
                JSONObject jsonColumnReference = new JSONObject();
                String pkColumnName = ((SchemaTextOptions)this.options).isShowUnqualifiedNames() ? columnReference.getPrimaryKeyColumn().getShortName() : columnReference.getPrimaryKeyColumn().getFullName();
                jsonColumnReference.put("pkColumn", pkColumnName);
                String fkColumnName = ((SchemaTextOptions)this.options).isShowUnqualifiedNames() ? columnReference.getForeignKeyColumn().getShortName() : columnReference.getForeignKeyColumn().getFullName();
                jsonColumnReference.put("fkColumn", fkColumnName);
                if (columnReference instanceof ForeignKeyColumnReference && ((SchemaTextOptions)this.options).isShowOrdinalNumbers()) {
                    int keySequence = ((ForeignKeyColumnReference)columnReference).getKeySequence();
                    jsonColumnReference.put("keySequence", keySequence);
                }
                jsonColumnReferences.put(jsonColumnReference);
            }
            catch (JSONException e) {
                LOGGER.log(Level.FINER, "Error outputting ColumnReference: " + e.getMessage(), e);
            }
        }
        return jsonColumnReferences;
    }

    private JSONArray handleForeignKeys(Collection<ForeignKey> foreignKeysCollection) {
        JSONArray jsonFks = new JSONArray();
        ArrayList<ForeignKey> foreignKeys = new ArrayList<ForeignKey>(foreignKeysCollection);
        Collections.sort(foreignKeys, NamedObjectSort.getNamedObjectSort((boolean)((SchemaTextOptions)this.options).isAlphabeticalSortForForeignKeys()));
        for (ForeignKey foreignKey : foreignKeys) {
            if (foreignKey == null) continue;
            try {
                ForeignKeyUpdateRule deleteRule;
                ForeignKeyUpdateRule updateRule;
                JSONObject jsonFk = new JSONObject();
                jsonFks.put(jsonFk);
                if (!((SchemaTextOptions)this.options).isHideForeignKeyNames()) {
                    jsonFk.put("name", foreignKey.getName());
                }
                if ((updateRule = foreignKey.getUpdateRule()) != null && updateRule != ForeignKeyUpdateRule.unknown) {
                    jsonFk.put("updateRule", updateRule.toString());
                }
                if ((deleteRule = foreignKey.getDeleteRule()) != null && deleteRule != ForeignKeyUpdateRule.unknown) {
                    jsonFk.put("deleteRule", deleteRule.toString());
                }
                List columnReferences = foreignKey.getColumnReferences();
                jsonFk.put("columnReferences", this.handleColumnReferences(columnReferences));
            }
            catch (JSONException e) {
                LOGGER.log(Level.FINER, "Error outputting ForeignKey: " + e.getMessage(), e);
            }
        }
        return jsonFks;
    }

    private JSONObject handleIndex(Index index) {
        JSONObject jsonIndex = new JSONObject();
        if (index == null) {
            return jsonIndex;
        }
        try {
            if (index instanceof PrimaryKey && !((SchemaTextOptions)this.options).isHidePrimaryKeyNames()) {
                jsonIndex.put("name", index.getName());
            } else if (!((SchemaTextOptions)this.options).isHideIndexNames()) {
                jsonIndex.put("name", index.getName());
            }
            IndexType indexType = index.getIndexType();
            if (indexType != IndexType.unknown && indexType != IndexType.other) {
                jsonIndex.put("type", indexType.toString());
            }
            jsonIndex.put("unique", index.isUnique());
            for (IndexColumn indexColumn : index.getColumns()) {
                jsonIndex.accumulate("columns", this.handleTableColumn((Column)indexColumn));
            }
            if (index.hasDefinition()) {
                jsonIndex.put("definition", index.getDefinition());
            }
        }
        catch (JSONException e) {
            LOGGER.log(Level.FINER, "Error outputting Index: " + e.getMessage(), e);
        }
        return jsonIndex;
    }

    private JSONObject handleRoutineColumn(RoutineColumn<?> column) {
        JSONObject jsonColumn = new JSONObject();
        try {
            jsonColumn.put("dataType", column.getColumnDataType().getTypeName());
            jsonColumn.put("databaseSpecificType", column.getColumnDataType().getDatabaseSpecificTypeName());
            jsonColumn.put("width", column.getWidth());
            jsonColumn.put("type", column.getColumnType().toString());
            if (((SchemaTextOptions)this.options).isShowOrdinalNumbers()) {
                jsonColumn.put("ordinal", column.getOrdinalPosition() + 1);
            }
        }
        catch (JSONException e) {
            LOGGER.log(Level.FINER, "Error outputting routine column: " + e.getMessage(), e);
        }
        return jsonColumn;
    }

    private JSONObject handleTableColumn(Column column) {
        JSONObject jsonColumn = new JSONObject();
        try {
            jsonColumn.put("name", column.getName());
            if (column instanceof IndexColumn) {
                jsonColumn.put("sortSequence", ((IndexColumn)column).getSortSequence().name());
            } else {
                jsonColumn.put("dataType", column.getColumnDataType().getTypeName());
                jsonColumn.put("databaseSpecificType", column.getColumnDataType().getDatabaseSpecificTypeName());
                jsonColumn.put("width", column.getWidth());
                jsonColumn.put("size", column.getSize());
                jsonColumn.put("decimalDigits", column.getDecimalDigits());
                jsonColumn.put("nullable", column.isNullable());
            }
            if (((SchemaTextOptions)this.options).isShowOrdinalNumbers()) {
                jsonColumn.put("ordinal", column.getOrdinalPosition());
            }
            if (this.isVerbose) {
                jsonColumn.put("remarks", column.getRemarks());
            }
        }
        catch (JSONException e) {
            LOGGER.log(Level.FINER, "Error outputting Column: " + e.getMessage(), e);
        }
        return jsonColumn;
    }

    private JSONObject handleTableConstraint(TableConstraint tableConstraint) {
        JSONObject jsonTableConstraint = new JSONObject();
        if (tableConstraint == null) {
            return jsonTableConstraint;
        }
        try {
            TableConstraintType tableConstraintType;
            if (!((SchemaTextOptions)this.options).isHideTableConstraintNames()) {
                jsonTableConstraint.put("name", tableConstraint.getName());
            }
            if ((tableConstraintType = tableConstraint.getTableConstraintType()) != TableConstraintType.unknown) {
                jsonTableConstraint.put("type", tableConstraintType.toString());
            }
            for (TableConstraintColumn tableConstraintColumn : tableConstraint.getColumns()) {
                jsonTableConstraint.accumulate("columns", this.handleTableColumn((Column)tableConstraintColumn));
            }
            if (tableConstraint.hasDefinition()) {
                jsonTableConstraint.put("definition", tableConstraint.getDefinition());
            }
        }
        catch (JSONException e) {
            LOGGER.log(Level.FINER, "Error outputting TableConstraint: " + e.getMessage(), e);
        }
        return jsonTableConstraint;
    }

    private JSONArray handleTriggers(Collection<Trigger> triggers) {
        JSONArray jsonTriggers = new JSONArray();
        for (Trigger trigger : triggers) {
            if (trigger == null) continue;
            try {
                JSONObject jsonTrigger = new JSONObject();
                jsonTriggers.put(jsonTrigger);
                if (!((SchemaTextOptions)this.options).isHideTriggerNames()) {
                    jsonTrigger.put("name", trigger.getName());
                }
                ConditionTimingType conditionTiming = trigger.getConditionTiming();
                EventManipulationType eventManipulationType = trigger.getEventManipulationType();
                if (conditionTiming != null && conditionTiming != ConditionTimingType.unknown && eventManipulationType != null && eventManipulationType != EventManipulationType.unknown) {
                    jsonTrigger.put("conditionTiming", conditionTiming);
                    jsonTrigger.put("eventManipulationType", eventManipulationType);
                }
                jsonTrigger.put("actionOrientation", trigger.getActionOrientation());
                jsonTrigger.put("actionCondition", trigger.getActionCondition());
                jsonTrigger.put("actionStatement", trigger.getActionStatement());
            }
            catch (JSONException e) {
                LOGGER.log(Level.FINER, "Error outputting Trigger: " + e.getMessage(), e);
            }
        }
        return jsonTriggers;
    }
}

