/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import schemacrawler.schema.ActionOrientationType;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.ColumnReference;
import schemacrawler.schema.ConditionTimingType;
import schemacrawler.schema.DefinedObject;
import schemacrawler.schema.EventManipulationType;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.ForeignKeyColumnReference;
import schemacrawler.schema.ForeignKeyUpdateRule;
import schemacrawler.schema.Index;
import schemacrawler.schema.IndexColumn;
import schemacrawler.schema.IndexType;
import schemacrawler.schema.Privilege;
import schemacrawler.schema.Routine;
import schemacrawler.schema.RoutineColumn;
import schemacrawler.schema.Sequence;
import schemacrawler.schema.Synonym;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableConstraint;
import schemacrawler.schema.TableConstraintColumn;
import schemacrawler.schema.TableConstraintType;
import schemacrawler.schema.Trigger;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.analysis.associations.DatabaseWithAssociations;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.text.base.BaseTabularFormatter;
import schemacrawler.tools.text.schema.SchemaTextDetailType;
import schemacrawler.tools.text.schema.SchemaTextOptions;
import schemacrawler.tools.text.utility.Alignment;
import schemacrawler.tools.text.utility.TextFormattingHelper;
import schemacrawler.tools.traversal.SchemaTraversalHandler;
import schemacrawler.utility.NamedObjectSort;
import sf.util.Utility;

final class SchemaTextFormatter
extends BaseTabularFormatter<SchemaTextOptions>
implements SchemaTraversalHandler {
    private final boolean isVerbose;
    private final boolean isList;

    private static String negate(boolean positive, String text) {
        String textValue = text;
        if (!positive) {
            textValue = "not " + textValue;
        }
        return textValue;
    }

    SchemaTextFormatter(SchemaTextDetailType schemaTextDetailType, SchemaTextOptions options, OutputOptions outputOptions) throws SchemaCrawlerException {
        super(options, schemaTextDetailType == SchemaTextDetailType.details, outputOptions);
        this.isVerbose = schemaTextDetailType == SchemaTextDetailType.details;
        this.isList = schemaTextDetailType == SchemaTextDetailType.list;
    }

    @Override
    public void handle(ColumnDataType columnDataType) throws SchemaCrawlerException {
        if (this.printVerboseDatabaseInfo && this.isVerbose) {
            this.out.append(this.formattingHelper.createObjectStart(""));
            this.printColumnDataType(columnDataType);
            this.out.append(this.formattingHelper.createObjectEnd());
        }
    }

    @Override
    public void handle(Routine routine) {
        String routineTypeDetail = String.format("%s, %s", routine.getRoutineType(), routine.getReturnType());
        String routineName = ((SchemaTextOptions)this.options).isShowUnqualifiedNames() ? routine.getName() : routine.getFullName();
        String routineType = "[" + routineTypeDetail + "]";
        if (this.isList) {
            this.out.println(this.formattingHelper.createNameValueRow(routineName, routineType, Alignment.right));
        } else {
            this.out.println(this.formattingHelper.createObjectStart(routineName));
            this.out.println(this.formattingHelper.createNameRow("", routineType));
            this.printRoutineColumns(routine.getColumns());
            this.printDefinition((DefinedObject)routine);
            if (this.isVerbose) {
                if (!((SchemaTextOptions)this.options).isHideRoutineSpecificNames()) {
                    this.printDefinition("specific name", "", routine.getSpecificName());
                }
                this.printDefinition("remarks", "", routine.getRemarks());
            }
            this.out.println(this.formattingHelper.createObjectEnd());
        }
        this.out.flush();
    }

    @Override
    public void handle(Sequence sequence) {
        String sequenceName = ((SchemaTextOptions)this.options).isShowUnqualifiedNames() ? sequence.getName() : sequence.getFullName();
        String sequenceType = "[sequence]";
        if (this.isList) {
            this.out.println(this.formattingHelper.createNameValueRow(sequenceName, "[sequence]", Alignment.right));
        } else {
            this.out.println(this.formattingHelper.createObjectStart(""));
            this.out.println(this.formattingHelper.createNameRow(sequenceName, "[sequence]"));
            this.out.println(this.formattingHelper.createDetailRow("", "increment", String.valueOf(sequence.getIncrement())));
            this.out.println(this.formattingHelper.createDetailRow("", "minimum value", String.valueOf(sequence.getMinimumValue())));
            this.out.println(this.formattingHelper.createDetailRow("", "maximum value", String.valueOf(sequence.getMaximumValue())));
            this.out.println(this.formattingHelper.createDetailRow("", "cycle", String.valueOf(sequence.isCycle())));
            if (this.isVerbose) {
                this.printDefinition("remarks", "", sequence.getRemarks());
            }
            this.out.println(this.formattingHelper.createObjectEnd());
        }
        this.out.flush();
    }

    @Override
    public void handle(Synonym synonym) {
        String synonymName = ((SchemaTextOptions)this.options).isShowUnqualifiedNames() ? synonym.getName() : synonym.getFullName();
        String synonymType = "[synonym]";
        if (this.isList) {
            this.out.println(this.formattingHelper.createNameValueRow(synonymName, "[synonym]", Alignment.right));
        } else {
            this.out.println(this.formattingHelper.createObjectStart(synonymName));
            this.out.println(this.formattingHelper.createNameRow("", "[synonym]"));
            String referencedObjectName = ((SchemaTextOptions)this.options).isShowUnqualifiedNames() ? synonym.getReferencedObject().getName() : synonym.getReferencedObject().getFullName();
            this.out.println(this.formattingHelper.createDetailRow("", synonym.getName() + this.formattingHelper.createArrow() + referencedObjectName, ""));
            if (this.isVerbose) {
                this.printDefinition("remarks", "", synonym.getRemarks());
            }
            this.out.println(this.formattingHelper.createObjectEnd());
        }
        this.out.flush();
    }

    @Override
    public void handle(Table table) {
        String tableName = ((SchemaTextOptions)this.options).isShowUnqualifiedNames() ? table.getName() : table.getFullName();
        String tableType = "[" + table.getTableType() + "]";
        if (this.isList) {
            this.out.println(this.formattingHelper.createNameValueRow(tableName, tableType, Alignment.right));
        } else {
            this.out.println(this.formattingHelper.createObjectStart(tableName));
            this.out.println(this.formattingHelper.createNameRow("", tableType));
            List columns = table.getColumns();
            this.printTableColumns(columns);
            this.printPrimaryKey((Index)table.getPrimaryKey());
            this.printForeignKeys(table);
            if (this.isVerbose) {
                this.printWeakAssociations(table);
            }
            this.printIndices(table.getIndices());
            this.printDefinition((DefinedObject)table);
            this.printTriggers(table.getTriggers());
            this.printTableConstraints(table.getTableConstraints());
            if (this.isVerbose) {
                String remarks;
                this.printPrivileges(table.getPrivileges());
                String tableRemarks = table.getRemarks();
                boolean hasColumnRemarks = false;
                for (Column column : columns) {
                    remarks = column.getRemarks();
                    if (Utility.isBlank((String)remarks)) continue;
                    hasColumnRemarks = true;
                    break;
                }
                if (Utility.isBlank((String)tableRemarks) && hasColumnRemarks) {
                    this.out.println(this.formattingHelper.createEmptyRow());
                    this.out.println(this.formattingHelper.createNameRow("", "[remarks]"));
                } else {
                    this.printDefinition("remarks", "", tableRemarks);
                }
                for (Column column : columns) {
                    remarks = column.getRemarks();
                    if (Utility.isBlank((String)remarks)) continue;
                    this.out.println(this.formattingHelper.createDetailRow("", column.getName(), remarks));
                }
            }
            this.out.println(this.formattingHelper.createObjectEnd());
        }
        this.out.flush();
    }

    @Override
    public void handleColumnDataTypesEnd() {
    }

    @Override
    public void handleColumnDataTypesStart() {
        if (this.printVerboseDatabaseInfo && this.isVerbose) {
            this.out.println(this.formattingHelper.createHeader(TextFormattingHelper.DocumentHeaderType.subTitle, "Data Types"));
        }
    }

    @Override
    public void handleRoutinesEnd() throws SchemaCrawlerException {
        if (this.isList) {
            this.out.append(this.formattingHelper.createObjectEnd());
        }
    }

    @Override
    public void handleRoutinesStart() throws SchemaCrawlerException {
        this.out.println(this.formattingHelper.createHeader(TextFormattingHelper.DocumentHeaderType.subTitle, "Routines"));
        if (this.isList) {
            this.out.append(this.formattingHelper.createObjectStart(""));
        }
    }

    @Override
    public void handleSequencesEnd() throws SchemaCrawlerException {
        if (this.isList) {
            this.out.append(this.formattingHelper.createObjectEnd());
        }
    }

    @Override
    public void handleSequencesStart() throws SchemaCrawlerException {
        this.out.println(this.formattingHelper.createHeader(TextFormattingHelper.DocumentHeaderType.subTitle, "Sequences"));
        if (this.isList) {
            this.out.append(this.formattingHelper.createObjectStart(""));
        }
    }

    @Override
    public void handleSynonymsEnd() throws SchemaCrawlerException {
        if (this.isList) {
            this.out.append(this.formattingHelper.createObjectEnd());
        }
    }

    @Override
    public void handleSynonymsStart() throws SchemaCrawlerException {
        this.out.println(this.formattingHelper.createHeader(TextFormattingHelper.DocumentHeaderType.subTitle, "Synonyms"));
        if (this.isList) {
            this.out.append(this.formattingHelper.createObjectStart(""));
        }
    }

    @Override
    public void handleTablesEnd() throws SchemaCrawlerException {
        if (this.isList) {
            this.out.append(this.formattingHelper.createObjectEnd());
        }
    }

    @Override
    public void handleTablesStart() throws SchemaCrawlerException {
        this.out.println(this.formattingHelper.createHeader(TextFormattingHelper.DocumentHeaderType.subTitle, "Tables"));
        if (this.isList) {
            this.out.append(this.formattingHelper.createObjectStart(""));
        }
    }

    private void printColumnDataType(ColumnDataType columnDataType) {
        String databaseSpecificTypeName = ((SchemaTextOptions)this.options).isShowUnqualifiedNames() ? columnDataType.getName() : columnDataType.getFullName();
        String typeName = columnDataType.getTypeName();
        String userDefined = SchemaTextFormatter.negate(columnDataType.isUserDefined(), "user defined");
        String nullable = SchemaTextFormatter.negate(columnDataType.isNullable(), "nullable");
        String autoIncrementable = SchemaTextFormatter.negate(columnDataType.isAutoIncrementable(), "auto-incrementable");
        String definedWith = "defined with ";
        definedWith = columnDataType.getCreateParameters() == null ? definedWith + "no parameters" : definedWith + columnDataType.getCreateParameters();
        this.out.println(this.formattingHelper.createNameRow(databaseSpecificTypeName, "[data type]"));
        this.out.println(this.formattingHelper.createDetailRow("", "based on", typeName));
        this.out.println(this.formattingHelper.createDescriptionRow(userDefined));
        this.out.println(this.formattingHelper.createDescriptionRow(definedWith));
        this.out.println(this.formattingHelper.createDescriptionRow(nullable));
        this.out.println(this.formattingHelper.createDescriptionRow(autoIncrementable));
        this.out.println(this.formattingHelper.createDescriptionRow(columnDataType.getSearchable().toString()));
    }

    private void printColumnReferences(String tableName, ColumnReference ... columnReferences) {
        for (ColumnReference columnReference : columnReferences) {
            Column pkColumn = columnReference.getPrimaryKeyColumn();
            Column fkColumn = columnReference.getForeignKeyColumn();
            String pkColumnName = ((Table)pkColumn.getParent()).getName().equals(tableName) ? pkColumn.getName() : (((SchemaTextOptions)this.options).isShowUnqualifiedNames() ? pkColumn.getShortName() : pkColumn.getFullName());
            String fkColumnName = ((Table)fkColumn.getParent()).getName().equals(tableName) ? fkColumn.getName() : (((SchemaTextOptions)this.options).isShowUnqualifiedNames() ? fkColumn.getShortName() : fkColumn.getFullName());
            String keySequenceString = "";
            if (columnReference instanceof ForeignKeyColumnReference && ((SchemaTextOptions)this.options).isShowOrdinalNumbers()) {
                int keySequence = ((ForeignKeyColumnReference)columnReference).getKeySequence();
                keySequenceString = String.format("%2d", keySequence);
            }
            this.out.println(this.formattingHelper.createDetailRow(keySequenceString, pkColumnName + this.formattingHelper.createArrow() + fkColumnName, ""));
        }
    }

    private void printDefinition(DefinedObject definedObject) {
        if (definedObject == null || !definedObject.hasDefinition()) {
            return;
        }
        this.out.println(this.formattingHelper.createEmptyRow());
        this.out.println(this.formattingHelper.createNameRow("", "[definition]"));
        this.out.println(this.formattingHelper.createDefinitionRow(definedObject.getDefinition()));
    }

    private void printDefinition(String heading, String name, String definition) {
        if (Utility.isBlank((String)definition)) {
            return;
        }
        String definitionName = Utility.isBlank((String)name) ? "" : name;
        this.out.println(this.formattingHelper.createEmptyRow());
        this.out.println(this.formattingHelper.createNameRow(definitionName, "[" + heading + "]"));
        this.out.println(this.formattingHelper.createDefinitionRow(definition));
    }

    private void printForeignKeys(Table table) {
        String tableName = table.getName();
        Collection foreignKeysCollection = table.getForeignKeys();
        ArrayList foreignKeys = new ArrayList(foreignKeysCollection);
        Collections.sort(foreignKeys, NamedObjectSort.getNamedObjectSort((boolean)((SchemaTextOptions)this.options).isAlphabeticalSortForForeignKeys()));
        for (ForeignKey foreignKey : foreignKeys) {
            if (foreignKey == null) continue;
            String name = foreignKey.getName();
            String updateRuleString = "";
            ForeignKeyUpdateRule updateRule = foreignKey.getUpdateRule();
            if (updateRule != null && updateRule != ForeignKeyUpdateRule.unknown) {
                updateRuleString = ", on update " + updateRule.toString();
            }
            String deleteRuleString = "";
            ForeignKeyUpdateRule deleteRule = foreignKey.getDeleteRule();
            if (deleteRule != null && deleteRule != ForeignKeyUpdateRule.unknown) {
                deleteRuleString = ", on delete " + deleteRule.toString();
            }
            String ruleString = updateRule == deleteRule && updateRule != ForeignKeyUpdateRule.unknown ? ", with " + deleteRule.toString() : updateRuleString + deleteRuleString;
            this.out.println(this.formattingHelper.createEmptyRow());
            String fkName = "";
            if (!((SchemaTextOptions)this.options).isHideForeignKeyNames()) {
                fkName = name;
            }
            String fkDetails = "[foreign key" + ruleString + "]";
            this.out.println(this.formattingHelper.createNameRow(fkName, fkDetails));
            this.printColumnReferences(tableName, foreignKey.getColumnReferences().toArray(new ColumnReference[0]));
        }
    }

    private void printIndices(Collection<Index> indicesCollection) {
        ArrayList<Index> indices = new ArrayList<Index>(indicesCollection);
        Collections.sort(indices, NamedObjectSort.getNamedObjectSort((boolean)((SchemaTextOptions)this.options).isAlphabeticalSortForIndexes()));
        for (Index index : indices) {
            if (index == null) continue;
            this.out.println(this.formattingHelper.createEmptyRow());
            String indexName = "";
            if (!((SchemaTextOptions)this.options).isHideIndexNames()) {
                indexName = index.getName();
            }
            IndexType indexType = index.getIndexType();
            String indexTypeString = "";
            if (indexType != IndexType.unknown && indexType != IndexType.other) {
                indexTypeString = indexType.toString() + " ";
            }
            String indexDetails = "[" + (index.isUnique() ? "" : "non-") + "unique " + indexTypeString + "index]";
            this.out.println(this.formattingHelper.createNameRow(indexName, indexDetails));
            this.printTableColumns(index.getColumns());
            if (!index.hasDefinition()) continue;
            this.out.println(this.formattingHelper.createDefinitionRow(index.getDefinition()));
        }
    }

    private void printPrimaryKey(Index primaryKey) {
        if (primaryKey != null) {
            String name = primaryKey.getName();
            this.out.println(this.formattingHelper.createEmptyRow());
            String pkName = "";
            if (!((SchemaTextOptions)this.options).isHidePrimaryKeyNames()) {
                pkName = name;
            }
            if (Utility.isBlank((String)pkName)) {
                pkName = "";
            }
            this.out.println(this.formattingHelper.createNameRow(pkName, "[primary key]"));
            this.printTableColumns(primaryKey.getColumns());
        }
    }

    private void printPrivileges(Collection<Privilege<Table>> privileges) {
        for (Privilege<Table> privilege : privileges) {
            if (privilege == null) continue;
            this.out.println(this.formattingHelper.createEmptyRow());
            this.out.println(this.formattingHelper.createNameRow(privilege.getName(), "[privilege]"));
            for (Privilege.Grant grant : privilege.getGrants()) {
                String grantedFrom = grant.getGrantor() + this.formattingHelper.createArrow() + grant.getGrantee() + (grant.isGrantable() ? " (grantable)" : "");
                this.out.println(this.formattingHelper.createDetailRow("", grantedFrom, ""));
            }
        }
    }

    private void printRoutineColumns(List<? extends RoutineColumn<?>> columns) {
        Collections.sort(columns, NamedObjectSort.getNamedObjectSort((boolean)((SchemaTextOptions)this.options).isAlphabeticalSortForRoutineColumns()));
        for (RoutineColumn<?> column : columns) {
            String columnTypeName = ((SchemaTextOptions)this.options).isShowStandardColumnTypeNames() ? column.getColumnDataType().getTypeName() : column.getColumnDataType().getDatabaseSpecificTypeName();
            StringBuilder columnType = new StringBuilder();
            columnType.append(columnTypeName).append(column.getWidth());
            if (column.getColumnType() != null) {
                columnType.append(", ").append(column.getColumnType().toString());
            }
            String ordinalNumberString = "";
            if (((SchemaTextOptions)this.options).isShowOrdinalNumbers()) {
                ordinalNumberString = String.valueOf(column.getOrdinalPosition() + 1);
            }
            this.out.println(this.formattingHelper.createDetailRow(ordinalNumberString, column.getName(), columnType.toString()));
        }
    }

    private void printTableColumns(List<? extends Column> columns) {
        Collections.sort(columns, NamedObjectSort.getNamedObjectSort((boolean)((SchemaTextOptions)this.options).isAlphabeticalSortForTableColumns()));
        for (Column column : columns) {
            String columnDetails;
            String columnName = column.getName();
            if (column instanceof IndexColumn) {
                columnDetails = ((IndexColumn)column).getSortSequence().name();
            } else if (column instanceof TableConstraintColumn) {
                columnDetails = "";
            } else {
                String columnTypeName = column.getColumnDataType().getDatabaseSpecificTypeName();
                if (((SchemaTextOptions)this.options).isShowStandardColumnTypeNames()) {
                    columnTypeName = column.getColumnDataType().getTypeName();
                }
                String columnType = columnTypeName + column.getWidth();
                String nullable = column.isNullable() ? "" : " not null";
                columnDetails = columnType + nullable;
            }
            String ordinalNumberString = "";
            if (((SchemaTextOptions)this.options).isShowOrdinalNumbers()) {
                ordinalNumberString = String.valueOf(column.getOrdinalPosition());
            }
            this.out.println(this.formattingHelper.createDetailRow(ordinalNumberString, columnName, columnDetails));
        }
    }

    private void printTableConstraints(Collection<TableConstraint> constraintsCollection) {
        ArrayList<TableConstraint> constraints = new ArrayList<TableConstraint>(constraintsCollection);
        Collections.sort(constraints, NamedObjectSort.getNamedObjectSort((boolean)((SchemaTextOptions)this.options).isAlphabeticalSortForIndexes()));
        for (TableConstraint constraint : constraints) {
            if (constraint == null) continue;
            String constraintName = "";
            if (!((SchemaTextOptions)this.options).isHideTableConstraintNames()) {
                constraintName = constraint.getName();
            }
            String constraintType = constraint.getTableConstraintType().getValue().toLowerCase();
            if (!EnumSet.of(TableConstraintType.check, TableConstraintType.unique).contains(constraint.getTableConstraintType()) && !constraint.hasDefinition()) continue;
            String constraintDetails = "[" + constraintType + " constraint]";
            this.out.println(this.formattingHelper.createEmptyRow());
            this.out.println(this.formattingHelper.createNameRow(constraintName, constraintDetails));
            this.printTableColumns(constraint.getColumns());
            if (!constraint.hasDefinition()) continue;
            this.out.println(this.formattingHelper.createDefinitionRow(constraint.getDefinition()));
        }
    }

    private void printTriggers(Collection<Trigger> triggers) {
        for (Trigger trigger : triggers) {
            if (trigger == null) continue;
            String timing = "";
            ConditionTimingType conditionTiming = trigger.getConditionTiming();
            EventManipulationType eventManipulationType = trigger.getEventManipulationType();
            if (conditionTiming != null && conditionTiming != ConditionTimingType.unknown && eventManipulationType != null && eventManipulationType != EventManipulationType.unknown) {
                timing = ", " + conditionTiming + " " + eventManipulationType;
            }
            String orientation = "";
            if (trigger.getActionOrientation() != null && trigger.getActionOrientation() != ActionOrientationType.unknown) {
                orientation = ", per " + trigger.getActionOrientation();
            }
            String triggerType = "[trigger" + timing + orientation + "]";
            triggerType = triggerType.toLowerCase(Locale.ENGLISH);
            String actionCondition = trigger.getActionCondition();
            String actionStatement = trigger.getActionStatement();
            this.out.println(this.formattingHelper.createEmptyRow());
            String triggerName = ((SchemaTextOptions)this.options).isHideTriggerNames() ? "" : trigger.getName();
            this.out.println(this.formattingHelper.createNameRow(triggerName, triggerType));
            if (!Utility.isBlank((String)actionCondition)) {
                this.out.println(this.formattingHelper.createDescriptionRow(actionCondition));
            }
            if (Utility.isBlank((String)actionStatement)) continue;
            this.out.println(this.formattingHelper.createDescriptionRow(actionStatement));
        }
    }

    private void printWeakAssociations(Table table) {
        String tableName = table.getName();
        Collection<ColumnReference> weakAssociationsCollection = DatabaseWithAssociations.getWeakAssociations(table);
        ArrayList<ColumnReference> weakAssociations = new ArrayList<ColumnReference>(weakAssociationsCollection);
        Collections.sort(weakAssociations);
        for (ColumnReference weakAssociation : weakAssociations) {
            this.out.println(this.formattingHelper.createEmptyRow());
            this.out.println(this.formattingHelper.createNameRow("", "[weak association]"));
            this.printColumnReferences(tableName, weakAssociation);
        }
    }
}

