/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.graph;

import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schemacrawler.Config;
import schemacrawler.tools.text.schema.SchemaTextDetailType;
import schemacrawler.tools.text.schema.SchemaTextOptions;
import sf.util.Utility;

public class GraphOptions
extends SchemaTextOptions {
    private static final long serialVersionUID = -5850945398335496207L;
    private static final String GRAPH_DETAILS = "schemacrawler.graph.details";
    private static final String GRAPH_GRAPHVIZ_OPTS = "schemacrawler.graph.graphviz_opts";
    private static final String SC_GRAPHVIZ_OPTS = "SC_GRAPHVIZ_OPTS";
    private static final Logger LOGGER = Logger.getLogger(GraphOptions.class.getName());

    public GraphOptions() {
        this(null);
    }

    public GraphOptions(Config config) {
        super(config);
        this.setSchemaTextDetailType((SchemaTextDetailType)this.getEnumValue(config, GRAPH_DETAILS, SchemaTextDetailType.details));
        this.setGraphVizOpts(this.readGraphVizOpts(config));
    }

    public String getGraphVizOpts() {
        return this.getStringValue(GRAPH_GRAPHVIZ_OPTS, "");
    }

    public SchemaTextDetailType getSchemaTextDetailType() {
        return (SchemaTextDetailType)this.getEnumValue(GRAPH_DETAILS, SchemaTextDetailType.details);
    }

    public void setGraphVizOpts(String graphVizOpts) {
        if (graphVizOpts == null) {
            throw new IllegalArgumentException("Cannot use null value in a setter");
        }
        this.setStringValue(GRAPH_GRAPHVIZ_OPTS, graphVizOpts);
    }

    public void setSchemaTextDetailType(SchemaTextDetailType schemaTextDetailType) {
        if (schemaTextDetailType == null) {
            throw new IllegalArgumentException("Cannot use null value in a setter");
        }
        this.setEnumValue(GRAPH_DETAILS, schemaTextDetailType);
    }

    private String readGraphVizOpts(Config config) {
        String scGraphVizOptsCfg = this.getStringValue(config, GRAPH_GRAPHVIZ_OPTS, "");
        if (!Utility.isBlank((String)scGraphVizOptsCfg)) {
            LOGGER.log(Level.CONFIG, "Using additional GraphViz command-line options from config, " + scGraphVizOptsCfg);
            return scGraphVizOptsCfg;
        }
        String scGraphVizOptsProp = System.getProperty(SC_GRAPHVIZ_OPTS);
        if (!Utility.isBlank((String)scGraphVizOptsProp)) {
            LOGGER.log(Level.CONFIG, "Using additional GraphViz command-line options from SC_GRAPHVIZ_OPTS system property, " + scGraphVizOptsProp);
            return scGraphVizOptsProp;
        }
        String scGraphVizOptsEnv = System.getenv(SC_GRAPHVIZ_OPTS);
        if (!Utility.isBlank((String)scGraphVizOptsEnv)) {
            LOGGER.log(Level.CONFIG, "Using additional GraphViz command-line options from SC_GRAPHVIZ_OPTS environmental variable, " + scGraphVizOptsEnv);
            return scGraphVizOptsEnv;
        }
        return "";
    }
}

