/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.schema;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.ColumnReference;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.NamedObject;
import schemacrawler.schema.Routine;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Synonym;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.analysis.associations.DatabaseWithAssociations;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.text.base.BaseDotFormatter;
import schemacrawler.tools.text.schema.SchemaTextDetailType;
import schemacrawler.tools.text.schema.SchemaTextOptions;
import schemacrawler.tools.traversal.SchemaTraversalHandler;
import schemacrawler.utility.MetaDataUtility;
import schemacrawler.utility.NamedObjectSort;
import sf.util.Utility;

public final class SchemaDotFormatter
extends BaseDotFormatter<SchemaTextOptions>
implements SchemaTraversalHandler {
    private final boolean isVerbose;
    private final boolean isList;
    private final Map<Schema, String> colorMap;

    public SchemaDotFormatter(SchemaTextDetailType schemaTextDetailType, SchemaTextOptions options, OutputOptions outputOptions) throws SchemaCrawlerException {
        super(options, schemaTextDetailType == SchemaTextDetailType.details, outputOptions);
        this.isVerbose = schemaTextDetailType == SchemaTextDetailType.details;
        this.isList = schemaTextDetailType == SchemaTextDetailType.list;
        this.colorMap = new HashMap<Schema, String>();
    }

    @Override
    public void handle(ColumnDataType columnDataType) throws SchemaCrawlerException {
    }

    @Override
    public void handle(Routine routine) {
    }

    @Override
    public void handle(Synonym synonym) {
    }

    @Override
    public void handle(Table table) {
        String tableNameBgColor;
        Schema schema = table.getSchema();
        String tableName = ((SchemaTextOptions)this.options).isShowUnqualifiedNames() ? table.getName() : table.getFullName();
        String tableType = "[" + table.getTableType() + "]";
        if (!this.colorMap.containsKey(schema)) {
            tableNameBgColor = Utility.pastelColorHTMLValue((String)schema.getFullName());
            this.colorMap.put(schema, tableNameBgColor);
        } else {
            tableNameBgColor = this.colorMap.get(schema);
        }
        this.out.append("  /* ").append(table.getFullName()).append(" -=-=-=-=-=-=-=-=-=-=-=-=-=- */").append(Utility.NEWLINE);
        this.out.append("  \"").append(this.nodeId((NamedObject)table)).append("\" [").append(Utility.NEWLINE).append("    label=<").append(Utility.NEWLINE);
        this.out.append("      <table border=\"1\" cellborder=\"0\" cellpadding=\"2\" cellspacing=\"0\" bgcolor=\"white\">").append(Utility.NEWLINE);
        this.out.append("        <tr>").append(Utility.NEWLINE);
        int colspan = ((SchemaTextOptions)this.options).isShowOrdinalNumbers() ? 3 : 2;
        this.out.append("          <td colspan=\"").append(String.valueOf(colspan)).append("\" bgcolor=\"").append(tableNameBgColor).append("\" align=\"left\"><b>").append(tableName).append("</b></td>").append(Utility.NEWLINE);
        this.out.append("          <td bgcolor=\"").append(tableNameBgColor).append("\" align=\"right\">").append(tableType).append("</td>").append(Utility.NEWLINE);
        this.out.append("        </tr>").append(Utility.NEWLINE);
        if (!this.isList) {
            List columns = table.getColumns();
            this.printTableColumns(columns);
        }
        this.out.append("      </table>").append(Utility.NEWLINE);
        this.out.append("    >").append(Utility.NEWLINE).append("  ];").append(Utility.NEWLINE).append(Utility.NEWLINE);
        if (!this.isList) {
            for (ForeignKey foreignKey : table.getForeignKeys()) {
                for (ColumnReference columnReference : foreignKey.getColumnReferences()) {
                    if (!table.equals(columnReference.getPrimaryKeyColumn().getParent())) continue;
                    this.out.write(this.printColumnReference(foreignKey.getName(), columnReference));
                }
            }
            if (this.isVerbose) {
                this.printWeakAssociations(table);
            }
        }
        this.out.append(Utility.NEWLINE).append(Utility.NEWLINE);
    }

    @Override
    public void handleColumnDataTypesEnd() {
    }

    @Override
    public void handleColumnDataTypesStart() {
    }

    @Override
    public void handleRoutinesEnd() throws SchemaCrawlerException {
    }

    @Override
    public void handleRoutinesStart() throws SchemaCrawlerException {
    }

    @Override
    public void handleSynonymsEnd() throws SchemaCrawlerException {
    }

    @Override
    public void handleSynonymsStart() throws SchemaCrawlerException {
    }

    @Override
    public void handleTablesEnd() throws SchemaCrawlerException {
    }

    @Override
    public void handleTablesStart() throws SchemaCrawlerException {
    }

    private String arrowhead(MetaDataUtility.Connectivity connectivity) {
        switch (connectivity) {
            case unknown: {
                return "vee";
            }
            case zero_one: {
                return "teeodot";
            }
            case zero_many: {
                return "crowodot";
            }
            case one_one: {
                return "teetee";
            }
        }
        return "vee";
    }

    private String[] getPortIds(Column column) {
        boolean isColumnReference;
        String[] portIds = new String[2];
        try {
            column.getColumnDataType();
            isColumnReference = false;
        }
        catch (Exception e) {
            isColumnReference = true;
        }
        if (!isColumnReference) {
            portIds[0] = String.format("\"%s\":\"%s.start\"", this.nodeId((NamedObject)column.getParent()), this.nodeId((NamedObject)column));
            portIds[1] = String.format("\"%s\":\"%s.end\"", this.nodeId((NamedObject)column.getParent()), this.nodeId((NamedObject)column));
        } else {
            String nodeId;
            portIds[0] = nodeId = this.printNewNode(column);
            portIds[1] = nodeId;
        }
        return portIds;
    }

    private String nodeId(NamedObject namedObject) {
        if (namedObject == null) {
            return "";
        }
        return Utility.convertForComparison((String)namedObject.getName()) + "_" + Integer.toHexString(namedObject.getFullName().hashCode());
    }

    private String printColumnReference(String associationName, ColumnReference columnReference) {
        Column primaryKeyColumn = columnReference.getPrimaryKeyColumn();
        Column foreignKeyColumn = columnReference.getForeignKeyColumn();
        String[] pkPortIds = this.getPortIds(primaryKeyColumn);
        String[] fkPortIds = this.getPortIds(foreignKeyColumn);
        MetaDataUtility.Connectivity connectivity = MetaDataUtility.getConnectivity((Column)foreignKeyColumn);
        String pkSymbol = "teetee";
        String fkSymbol = this.arrowhead(connectivity);
        String style = Utility.isBlank((String)associationName) ? "dashed" : "solid";
        return String.format("  %s:w -> %s:e [label=<%s> style=\"%s\" dir=\"both\" arrowhead=\"%s\" arrowtail=\"%s\"];%n", pkPortIds[0], fkPortIds[1], ((SchemaTextOptions)this.options).isHideForeignKeyNames() ? "" : associationName, style, fkSymbol, "teetee");
    }

    private String printNewNode(Column column) {
        String nodeId = "\"" + this.nodeId((NamedObject)column) + "\"";
        String columnName = ((SchemaTextOptions)this.options).isShowUnqualifiedNames() ? column.getShortName() : column.getFullName();
        String columnNode = String.format("  %s [label=<%s>];%n", nodeId, columnName);
        this.out.write(columnNode);
        return nodeId;
    }

    private void printTableColumns(List<Column> columns) {
        Collections.sort(columns, NamedObjectSort.getNamedObjectSort((boolean)((SchemaTextOptions)this.options).isAlphabeticalSortForTableColumns()));
        for (Column column : columns) {
            String columnTypeName = column.getColumnDataType().getDatabaseSpecificTypeName();
            if (((SchemaTextOptions)this.options).isShowStandardColumnTypeNames()) {
                columnTypeName = column.getColumnDataType().getTypeName();
            }
            String columnType = columnTypeName + column.getWidth();
            String nullable = column.isNullable() ? "" : " not null";
            String columnDetails = columnType + nullable;
            this.out.append("        <tr>").append(Utility.NEWLINE);
            this.out.append("          <td port=\"").append(this.nodeId((NamedObject)column)).append(".start\" ");
            if (((SchemaTextOptions)this.options).isShowOrdinalNumbers()) {
                this.out.append("align=\"right\">");
                String ordinalNumberString = String.valueOf(column.getOrdinalPosition());
                this.out.append(ordinalNumberString);
                this.out.append("</td>").append(Utility.NEWLINE).append("          <td ");
            }
            this.out.append("align=\"left\">");
            if (column.isPartOfPrimaryKey()) {
                this.out.append("<b><i><u>");
            }
            this.out.append(column.getName());
            if (column.isPartOfPrimaryKey()) {
                this.out.append("</u></i></b>");
            }
            this.out.append("</td>").append(Utility.NEWLINE);
            this.out.append("          <td> </td>").append(Utility.NEWLINE);
            this.out.append("          <td port=\"").append(this.nodeId((NamedObject)column)).append(".end\" align=\"right\">");
            this.out.append(columnDetails);
            this.out.append("</td>").append(Utility.NEWLINE);
            this.out.append("        </tr>").append(Utility.NEWLINE);
        }
    }

    private void printWeakAssociations(Table table) {
        Collection<ColumnReference> weakAssociations = DatabaseWithAssociations.getWeakAssociations(table);
        for (ColumnReference weakAssociation : weakAssociations) {
            this.out.write(this.printColumnReference("", weakAssociation));
        }
    }
}

