/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline;

import java.util.HashMap;
import java.util.Map;
import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.ConnectionOptions;
import schemacrawler.schemacrawler.DatabaseConfigConnectionOptions;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.commandline.BaseDatabaseConnectionOptionsParser;
import sf.util.CommandLineParser;
import sf.util.Utility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ConfigConnectionOptionsParser
extends BaseDatabaseConnectionOptionsParser {
    private final CommandLineParser.BooleanOption optionUseDefaultConnection = new CommandLineParser.BooleanOption('d', "default");
    private final CommandLineParser.StringOption optionConnection = new CommandLineParser.StringOption('c', "connection", null);

    private static Map<String, String> partition(Map<String, String> config, String prefix) {
        if (Utility.isBlank((String)prefix)) {
            return config;
        }
        String dottedPrefix = prefix + ".";
        HashMap<String, String> partition = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : config.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith(dottedPrefix)) continue;
            String unprefixed = key.substring(dottedPrefix.length());
            partition.put(unprefixed, entry.getValue());
        }
        return partition;
    }

    ConfigConnectionOptionsParser(String[] args, Config config) {
        super(args, config);
    }

    @Override
    public ConnectionOptions getOptions() throws SchemaCrawlerException {
        String password;
        this.parse(new CommandLineParser.Option[]{this.optionUseDefaultConnection, this.optionConnection, this.optionUser, this.optionPassword});
        String connectionName = (Boolean)this.optionUseDefaultConnection.getValue() != false ? (String)this.config.get((Object)"defaultconnection") : (String)this.optionConnection.getValue();
        if (this.config.isEmpty()) {
            throw new SchemaCrawlerException(String.format("No configuration provided for connection \"%s\"", connectionName));
        }
        Map<String, String> databaseConnectionConfig = ConfigConnectionOptionsParser.partition((Map<String, String>)this.config, connectionName);
        this.config.putAll(databaseConnectionConfig);
        DatabaseConfigConnectionOptions connectionOptions = new DatabaseConfigConnectionOptions(databaseConnectionConfig);
        String user = (String)this.optionUser.getValue();
        if (user != null && !databaseConnectionConfig.containsKey("user")) {
            connectionOptions.setUser(user);
        }
        if ((password = (String)this.optionPassword.getValue()) != null && !databaseConnectionConfig.containsKey("password")) {
            connectionOptions.setPassword(password);
        }
        return connectionOptions;
    }
}

