/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline;

import java.io.InputStream;
import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.ConnectionOptions;
import schemacrawler.schemacrawler.DatabaseConnectionOptions;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.tools.commandline.BundledDriverConnectionOptionsParser;
import schemacrawler.tools.commandline.CommandLine;
import schemacrawler.tools.commandline.CommandLineConnectionOptionsParser;
import schemacrawler.tools.commandline.CommandParser;
import schemacrawler.tools.commandline.ConfigConnectionOptionsParser;
import schemacrawler.tools.commandline.ConfigParser;
import schemacrawler.tools.commandline.OutputOptionsParser;
import schemacrawler.tools.commandline.SchemaCrawlerOptionsParser;
import schemacrawler.tools.executable.SchemaCrawlerExecutable;
import schemacrawler.tools.options.OutputOptions;
import sf.util.Utility;

public final class SchemaCrawlerCommandLine
implements CommandLine {
    private static final long serialVersionUID = -3748989545708155963L;
    private final String command;
    private final Config config;
    private final SchemaCrawlerOptions schemaCrawlerOptions;
    private final OutputOptions outputOptions;
    private final ConnectionOptions connectionOptions;

    public SchemaCrawlerCommandLine(ConnectionOptions connectionOptions, String ... args) throws SchemaCrawlerException {
        this(null, connectionOptions, args);
    }

    public SchemaCrawlerCommandLine(String configResource, String ... args) throws SchemaCrawlerException {
        this(configResource, (ConnectionOptions)null, args);
    }

    private SchemaCrawlerCommandLine(String configResource, ConnectionOptions connectionOptions, String ... args) throws SchemaCrawlerException {
        if (args == null) {
            throw new IllegalArgumentException("No command line arguments provided");
        }
        if (args.length > 0) {
            this.command = new CommandParser(args).getOptions().toString();
            this.outputOptions = new OutputOptionsParser(args).getOptions();
        } else {
            this.command = null;
            this.outputOptions = new OutputOptions();
        }
        if (!Utility.isBlank((String)configResource)) {
            this.config = Config.load((InputStream)SchemaCrawlerCommandLine.class.getResourceAsStream(configResource));
            this.connectionOptions = new BundledDriverConnectionOptionsParser(args, this.config).getOptions();
        } else {
            this.config = args != null && args.length > 0 ? new ConfigParser(args).getOptions() : new Config();
            if (connectionOptions != null) {
                this.connectionOptions = connectionOptions;
            } else {
                DatabaseConnectionOptions parsedConnectionOptions = new CommandLineConnectionOptionsParser(args, this.config).getOptions();
                if (parsedConnectionOptions == null) {
                    parsedConnectionOptions = new ConfigConnectionOptionsParser(args, this.config).getOptions();
                }
                this.connectionOptions = parsedConnectionOptions;
            }
        }
        this.schemaCrawlerOptions = new SchemaCrawlerOptionsParser(args, this.config).getOptions();
    }

    public void execute() throws Exception {
        SchemaCrawlerExecutable executable = new SchemaCrawlerExecutable(this.command);
        if (this.outputOptions != null) {
            executable.setOutputOptions(this.outputOptions);
        }
        if (this.schemaCrawlerOptions != null) {
            executable.setSchemaCrawlerOptions(this.schemaCrawlerOptions);
        }
        if (this.config != null) {
            executable.setAdditionalConfiguration(this.config);
        }
        if (this.connectionOptions == null) {
            throw new SchemaCrawlerException("No connection options provided");
        }
        executable.execute(this.connectionOptions.createConnection());
    }

    public final String getCommand() {
        return this.command;
    }

    public final Config getConfig() {
        return this.config;
    }

    public final ConnectionOptions getConnectionOptions() {
        return this.connectionOptions;
    }

    public final OutputOptions getOutputOptions() {
        return this.outputOptions;
    }

    public final SchemaCrawlerOptions getSchemaCrawlerOptions() {
        return this.schemaCrawlerOptions;
    }
}

