/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.executable;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schemacrawler.SchemaCrawlerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CommandRegistry {
    private static final Logger LOGGER = Logger.getLogger(CommandRegistry.class.getName());
    private final Map<String, String> commandRegistry = CommandRegistry.loadCommandRegistry();

    private static Map<String, String> loadCommandRegistry() throws SchemaCrawlerException {
        HashMap<String, String> commandRegistry = new HashMap<String, String>();
        HashSet<URL> commandRegistryUrls = new HashSet<URL>();
        try {
            ClassLoader classLoader = CommandRegistry.class.getClassLoader();
            Enumeration<URL> resources = classLoader.getResources("tools.command.properties");
            commandRegistryUrls.addAll(Collections.list(resources));
            resources = classLoader.getResources("command.properties");
            commandRegistryUrls.addAll(Collections.list(resources));
        }
        catch (IOException e) {
            throw new SchemaCrawlerException("Could not load command registry", (Throwable)e);
        }
        for (URL commandRegistryUrl : commandRegistryUrls) {
            try {
                Properties commandRegistryProperties = new Properties();
                commandRegistryProperties.load(commandRegistryUrl.openStream());
                ArrayList<String> propertyNames = Collections.list(commandRegistryProperties.propertyNames());
                for (String commandName : propertyNames) {
                    String executableClassName = commandRegistryProperties.getProperty(commandName);
                    commandRegistry.put(commandName, executableClassName);
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Could not load command registry, " + commandRegistryUrl, e);
            }
        }
        if (commandRegistry.isEmpty()) {
            throw new SchemaCrawlerException("Could not load any command registry");
        }
        return commandRegistry;
    }

    public String[] lookupAvailableCommands() {
        Set<String> availableCommandsList = this.commandRegistry.keySet();
        availableCommandsList.remove("default");
        Object[] availableCommands = availableCommandsList.toArray(new String[availableCommandsList.size()]);
        Arrays.sort(availableCommands);
        return availableCommands;
    }

    public String lookupCommandExecutableClassName(String command) {
        String commandExecutableClassName = this.commandRegistry.containsKey(command) ? this.commandRegistry.get(command) : this.commandRegistry.get("default");
        return commandExecutableClassName;
    }
}

