/*
 * Decompiled with CFR 0.152.
 */
package sf.util;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CommandLineParser {
    private static final String DASH = "-";
    private String[] remainingArgs = new String[0];
    private final Map<String, Option<?>> optionsMap = new HashMap();

    public void addOption(Option<?> option) {
        if (option.hasShortForm()) {
            this.optionsMap.put(DASH + option.getShortForm(), option);
        }
        if (option.hasLongForm()) {
            this.optionsMap.put(DASH + option.getLongForm(), option);
        }
    }

    public boolean getBooleanOptionValue(String optionName) {
        boolean optionValue = false;
        Option<?> option = this.getOption(optionName);
        if (option == null) {
            optionValue = false;
        } else if (option instanceof BooleanOption) {
            optionValue = (Boolean)((BooleanOption)option).getValue();
        }
        return optionValue;
    }

    public Option<?> getOption(String optionName) {
        return this.optionsMap.get(DASH + optionName);
    }

    public String[] getRemainingArgs() {
        String[] remainingArgsCopy = new String[this.remainingArgs.length];
        System.arraycopy(this.remainingArgs, 0, remainingArgsCopy, 0, this.remainingArgs.length);
        return remainingArgsCopy;
    }

    public String getStringOptionValue(String optionName) {
        Option<?> option = this.getOption(optionName);
        if (option == null || option.getValue() == null) {
            return null;
        }
        return option.getValue().toString();
    }

    public void parse(String[] args) {
        for (Option<?> element : this.optionsMap.values()) {
            ((BaseOption)element).reset();
        }
        ArrayList<String> otherArgs = new ArrayList<String>();
        int position = 0;
        while (position < args.length) {
            BaseOption option;
            String currentArg = args[position];
            String valueArg = null;
            int equalsPos = currentArg.indexOf(61);
            if (equalsPos != -1) {
                valueArg = currentArg.substring(equalsPos + 1);
                currentArg = currentArg.substring(0, equalsPos);
            }
            if ((option = (BaseOption)this.optionsMap.get(currentArg)) == null) {
                otherArgs.add(currentArg);
                ++position;
                continue;
            }
            if (valueArg == null && ++position < args.length && (valueArg = args[position]).startsWith(DASH)) {
                --position;
                valueArg = null;
            }
            if (valueArg == null && option instanceof BooleanOption) {
                valueArg = Boolean.TRUE.toString();
            }
            option.setValue(valueArg);
            ++position;
        }
        this.remainingArgs = otherArgs.toArray(new String[otherArgs.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class StringOption
    extends BaseOption<String> {
        public StringOption(char shortForm, String longForm, String defaultValue) {
            super(shortForm, longForm, defaultValue);
        }

        @Override
        protected String parseValue(String arg) {
            return arg;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Option<T> {
        public static final char NO_SHORT_FORM = '\u0000';
        public static final String NO_LONG_FORM = null;

        public T getDefaultValue();

        public String getLongForm();

        public String getShortForm();

        public T getValue();

        public boolean hasLongForm();

        public boolean hasShortForm();

        public boolean isFound();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class NumberOption
    extends BaseOption<Number> {
        public NumberOption(char shortForm, String longForm, Number defaultValue) {
            super(shortForm, longForm, defaultValue);
        }

        @Override
        protected Number parseValue(String arg) {
            try {
                return NumberFormat.getNumberInstance().parse(arg);
            }
            catch (ParseException e) {
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class BooleanOption
    extends BaseOption<Boolean> {
        public BooleanOption(char shortForm, String longForm) {
            super(shortForm, longForm, Boolean.FALSE);
            this.value = Boolean.FALSE;
        }

        @Override
        protected Boolean parseValue(String valueString) {
            if (valueString == null || valueString.length() == 0) {
                return Boolean.FALSE;
            }
            return Boolean.valueOf(valueString);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class BaseOption<T>
    implements Option<T> {
        private String shortForm;
        private String longForm;
        private boolean hasShortForm;
        private boolean hasLongForm;
        T value;
        private final T defaultValue;

        protected BaseOption(char shortForm, String longForm, T defaultValue) {
            if (shortForm != '\u0000') {
                this.shortForm = new String(new char[]{shortForm});
                this.hasShortForm = true;
            }
            if (!longForm.equals(NO_LONG_FORM)) {
                if (longForm.length() == 0) {
                    throw new IllegalArgumentException("Long form for option not specified");
                }
                this.longForm = longForm;
                this.hasLongForm = true;
            }
            if (!this.hasLongForm && !this.hasShortForm) {
                throw new IllegalArgumentException("Option cannot be defined");
            }
            this.defaultValue = defaultValue;
        }

        @Override
        public T getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public String getLongForm() {
            return this.longForm;
        }

        @Override
        public String getShortForm() {
            return this.shortForm;
        }

        @Override
        public T getValue() {
            T returnValue = !this.isFound() ? this.defaultValue : this.value;
            return returnValue;
        }

        @Override
        public boolean hasLongForm() {
            return this.hasLongForm;
        }

        @Override
        public boolean hasShortForm() {
            return this.hasShortForm;
        }

        @Override
        public boolean isFound() {
            return this.value != null;
        }

        public String toString() {
            String optionString = (this.hasLongForm ? this.longForm : "") + (this.hasShortForm ? " (" + this.shortForm + ")" : "") + "=" + this.value + " (" + this.defaultValue + ")";
            return optionString;
        }

        protected abstract T parseValue(String var1);

        void reset() {
            this.value = null;
        }

        void setValue(String valueString) {
            this.value = this.parseValue(valueString);
        }
    }
}

