/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.freemarker;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.log.Logger;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import java.io.File;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Connection;
import java.util.HashMap;
import java.util.logging.Level;
import schemacrawler.schema.Database;
import schemacrawler.tools.executable.BaseExecutable;

public final class FreeMarkerRenderer
extends BaseExecutable {
    private static final long serialVersionUID = 4029489563062547982L;
    private static final java.util.logging.Logger LOGGER = java.util.logging.Logger.getLogger(FreeMarkerRenderer.class.getName());

    public FreeMarkerRenderer() {
        super("freemarker");
    }

    public final void executeOn(Database database, Connection connection) throws Exception {
        String templateLocation = this.outputOptions.getOutputFormatValue();
        String templatePath = ".";
        File templateFilePath = new File(templateLocation);
        if (templateFilePath.exists()) {
            templatePath = templateFilePath.getAbsoluteFile().getParent();
            templateLocation = templateFilePath.getName();
        }
        Logger.selectLoggerLibrary((int)1);
        Configuration cfg = new Configuration();
        ClassTemplateLoader ctl = new ClassTemplateLoader(FreeMarkerRenderer.class, "/");
        FileTemplateLoader ftl = new FileTemplateLoader(new File(templatePath));
        MultiTemplateLoader mtl = new MultiTemplateLoader(new TemplateLoader[]{ctl, ftl});
        cfg.setTemplateLoader((TemplateLoader)mtl);
        cfg.setStrictSyntaxMode(true);
        cfg.setWhitespaceStripping(true);
        cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        LOGGER.log(Level.INFO, Configuration.getVersionNumber());
        LOGGER.log(Level.INFO, "FreeMarker configuration properties - " + cfg);
        HashMap<String, Database> objectMap = new HashMap<String, Database>();
        objectMap.put("database", database);
        PrintWriter writer = this.outputOptions.openOutputWriter();
        Template template = cfg.getTemplate(templateLocation);
        template.process(objectMap, (Writer)writer);
        this.outputOptions.closeOutputWriter((Writer)writer);
    }
}

