/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.graph;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnMap;
import schemacrawler.schema.DatabaseInfo;
import schemacrawler.schema.ForeignKeyColumnMap;
import schemacrawler.schema.JdbcDriverInfo;
import schemacrawler.schema.NamedObject;
import schemacrawler.schema.Schema;
import schemacrawler.schema.SchemaCrawlerInfo;
import schemacrawler.schema.Table;
import schemacrawler.schema.View;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.utility.MetaDataUtility;
import sf.util.Utility;

final class DotWriter {
    private static final Random random = new Random(DotWriter.class.getName().hashCode());
    private final PrintWriter out;
    private final Map<Schema, String> colorMap;

    private static String nextRandomHTMLPastelColorValue() {
        for (int i = 0; i < random.nextInt(2000); ++i) {
            random.nextFloat();
        }
        float hue = random.nextFloat();
        float saturation = (float)(random.nextInt(2000) + 1000) / 10000.0f;
        float luminance = 0.9f;
        Color color = Color.getHSBColor(hue, saturation, 0.9f);
        return "#" + Integer.toHexString(color.getRGB()).substring(2).toUpperCase();
    }

    DotWriter(File dotFile) throws SchemaCrawlerException {
        if (dotFile == null) {
            throw new SchemaCrawlerException("No dot file provided");
        }
        try {
            this.out = new PrintWriter(dotFile);
        }
        catch (IOException e) {
            throw new SchemaCrawlerException("Cannot open dot file for output", (Throwable)e);
        }
        this.colorMap = new HashMap<Schema, String>();
    }

    public void close() {
        this.out.println("}");
        this.out.flush();
        this.out.close();
    }

    public void open() {
        String text = Utility.readResourceFully((String)"/dot.header.txt");
        this.out.println(text);
    }

    public void print(ColumnMap[] weakAssociations) {
        if (weakAssociations != null) {
            this.out.write(Utility.NEWLINE);
            for (ColumnMap columnMap : weakAssociations) {
                Column primaryKeyColumn = columnMap.getPrimaryKeyColumn();
                Column foreignKeyColumn = columnMap.getForeignKeyColumn();
                this.out.write(this.printColumnAssociation("", primaryKeyColumn, foreignKeyColumn));
            }
        }
        this.out.write(Utility.NEWLINE);
        this.out.write(Utility.NEWLINE);
    }

    public void print(SchemaCrawlerInfo schemaCrawlerInfo, DatabaseInfo databaseInfo, JdbcDriverInfo jdbcDriverInfo) {
        StringBuilder graphInfo = new StringBuilder();
        graphInfo.append("      <table border=\"1\" cellborder=\"0\" cellspacing=\"0\">").append(Utility.NEWLINE);
        graphInfo.append("        <tr>").append(Utility.NEWLINE);
        graphInfo.append("          <td align=\"right\">Generated by:</td>").append(Utility.NEWLINE);
        graphInfo.append("          <td align=\"left\">").append(schemaCrawlerInfo.getSchemaCrawlerProductName()).append(" ").append(schemaCrawlerInfo.getSchemaCrawlerVersion()).append("</td>").append(Utility.NEWLINE);
        graphInfo.append("        </tr>").append(Utility.NEWLINE);
        graphInfo.append("        <tr>").append(Utility.NEWLINE);
        graphInfo.append("          <td align=\"right\">Database:</td>").append(Utility.NEWLINE);
        graphInfo.append("          <td align=\"left\">").append(databaseInfo.getProductName()).append("  ").append(databaseInfo.getProductVersion()).append("</td>").append(Utility.NEWLINE);
        graphInfo.append("        </tr>").append(Utility.NEWLINE);
        graphInfo.append("        <tr>").append(Utility.NEWLINE);
        graphInfo.append("          <td align=\"right\">JDBC Connection:</td>").append(Utility.NEWLINE);
        graphInfo.append("          <td align=\"left\">").append(jdbcDriverInfo.getConnectionUrl()).append("</td>").append(Utility.NEWLINE);
        graphInfo.append("        </tr>").append(Utility.NEWLINE);
        graphInfo.append("        <tr>").append(Utility.NEWLINE);
        graphInfo.append("          <td align=\"right\">JDBC Driver:</td>").append(Utility.NEWLINE);
        graphInfo.append("          <td align=\"left\">").append(jdbcDriverInfo.getDriverName()).append("  ").append(jdbcDriverInfo.getDriverVersion()).append("</td>").append(Utility.NEWLINE);
        graphInfo.append("        </tr>").append(Utility.NEWLINE);
        graphInfo.append("      </table>");
        String graphLabel = String.format("  graph [%n    label=<%n%s    >%n    labeljust=r%n    labelloc=b%n  ];%n%n", graphInfo.toString());
        this.out.println(graphLabel);
    }

    public void print(Table table) {
        String tableNameBgColor;
        Schema schema = table.getSchema();
        if (!this.colorMap.containsKey(schema)) {
            tableNameBgColor = DotWriter.nextRandomHTMLPastelColorValue();
            this.colorMap.put(schema, tableNameBgColor);
        } else {
            tableNameBgColor = this.colorMap.get(schema);
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("  /* ").append(table.getFullName()).append(" -=-=-=-=-=-=-=-=-=-=-=-=-=- */").append(Utility.NEWLINE);
        buffer.append("  \"").append(this.nodeId((NamedObject)table)).append("\" [").append(Utility.NEWLINE).append("    label=<").append(Utility.NEWLINE);
        buffer.append("      <table border=\"1\" cellborder=\"0\" cellspacing=\"0\" bgcolor=\"white\">").append(Utility.NEWLINE);
        buffer.append("        <tr>").append(Utility.NEWLINE);
        buffer.append("          <td colspan=\"2\" bgcolor=\"").append(tableNameBgColor).append("\" align=\"left\"><font face=\"Helvetica-Bold\" point-size=\"9\">").append(table.getFullName()).append("</font></td>").append(Utility.NEWLINE);
        buffer.append("          <td bgcolor=\"").append(tableNameBgColor).append("\" align=\"right\">").append(table instanceof View ? "[view]" : "[table]").append("</td>").append(Utility.NEWLINE);
        buffer.append("        </tr>").append(Utility.NEWLINE);
        for (Column column : table.getColumns()) {
            buffer.append("        <tr>").append(Utility.NEWLINE);
            buffer.append("          <td port=\"").append(this.nodeId((NamedObject)column)).append(".start\" align=\"left\">");
            if (column.isPartOfPrimaryKey()) {
                buffer.append("<font face=\"Helvetica-BoldOblique\">");
            }
            buffer.append(column.getName());
            if (column.isPartOfPrimaryKey()) {
                buffer.append("</font>");
            }
            buffer.append("</td>").append(Utility.NEWLINE);
            buffer.append("          <td> </td>").append(Utility.NEWLINE);
            buffer.append("          <td port=\"").append(this.nodeId((NamedObject)column)).append(".end\" align=\"right\">");
            buffer.append(column.getType().getDatabaseSpecificTypeName()).append(column.getWidth());
            buffer.append("</td>").append(Utility.NEWLINE);
            buffer.append("        </tr>").append(Utility.NEWLINE);
        }
        buffer.append("      </table>").append(Utility.NEWLINE);
        buffer.append("    >").append(Utility.NEWLINE).append("  ];").append(Utility.NEWLINE);
        for (Column column : table.getForeignKeys()) {
            for (ForeignKeyColumnMap foreignKeyColumnMap : column.getColumnPairs()) {
                Column primaryKeyColumn = foreignKeyColumnMap.getPrimaryKeyColumn();
                Column foreignKeyColumn = foreignKeyColumnMap.getForeignKeyColumn();
                if (!primaryKeyColumn.getParent().equals(table)) continue;
                buffer.append(this.printColumnAssociation(column.getName(), primaryKeyColumn, foreignKeyColumn));
            }
        }
        this.out.write(buffer.toString());
    }

    private String nodeId(NamedObject namedOjbect) {
        if (namedOjbect == null) {
            return "";
        }
        return Utility.convertForComparison((String)namedOjbect.getName()) + "_" + Integer.toHexString(namedOjbect.getFullName().hashCode());
    }

    private String printColumnAssociation(String associationName, Column primaryKeyColumn, Column foreignKeyColumn) {
        String fkSymbol;
        MetaDataUtility.Connectivity connectivity = MetaDataUtility.getConnectivity((Column)foreignKeyColumn);
        String pkSymbol = "teetee";
        if (connectivity != null) {
            switch (connectivity) {
                case OneToOne: {
                    fkSymbol = "teeodot";
                    break;
                }
                case OneToMany: {
                    fkSymbol = "crowodot";
                    break;
                }
                default: {
                    fkSymbol = "none";
                    break;
                }
            }
        } else {
            fkSymbol = "none";
        }
        String style = Utility.isBlank((String)associationName) ? "dashed" : "solid";
        return String.format("  \"%s\":\"%s.start\":w -> \"%s\":\"%s.end\":e [label=<%s> style=\"%s\" arrowhead=\"%s\" arrowtail=\"%s\"];%n", this.nodeId((NamedObject)primaryKeyColumn.getParent()), this.nodeId((NamedObject)primaryKeyColumn), this.nodeId((NamedObject)foreignKeyColumn.getParent()), this.nodeId((NamedObject)foreignKeyColumn), associationName, style, fkSymbol, "teetee");
    }
}

