/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.graph;

import java.io.File;
import java.sql.Connection;
import schemacrawler.schema.Database;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Table;
import schemacrawler.tools.analysis.AnalyzedDatabase;
import schemacrawler.tools.commandline.InfoLevel;
import schemacrawler.tools.executable.BaseExecutable;
import schemacrawler.tools.integration.graph.DotWriter;
import schemacrawler.tools.integration.graph.GraphGenerator;
import sf.util.Utility;

public final class GraphExecutable
extends BaseExecutable {
    private final GraphCommandType graphCommandType;

    public GraphExecutable() {
        this(null);
    }

    public GraphExecutable(String command) {
        super(command);
        this.graphCommandType = command == null ? GraphCommandType.graph : GraphCommandType.valueOf(command);
    }

    protected void executeOn(Database db, Connection connection) throws Exception {
        InfoLevel infoLevel;
        try {
            infoLevel = InfoLevel.valueOf((String)this.getSchemaCrawlerOptions().getSchemaInfoLevel().getTag());
        }
        catch (Exception e) {
            infoLevel = InfoLevel.unknown;
        }
        Object database = infoLevel.ordinal() >= InfoLevel.lint.ordinal() ? new AnalyzedDatabase(db, infoLevel) : db;
        File dotFile = File.createTempFile("schemacrawler.", ".dot");
        DotWriter dotWriter = new DotWriter(dotFile);
        dotWriter.open();
        dotWriter.print(database.getSchemaCrawlerInfo(), database.getDatabaseInfo(), database.getJdbcDriverInfo());
        for (Schema schema : database.getSchemas()) {
            for (Table table : schema.getTables()) {
                dotWriter.print(table);
                dotWriter.print(AnalyzedDatabase.getWeakAssociations((Table)table));
            }
        }
        dotWriter.close();
        GraphGenerator dot = new GraphGenerator(dotFile, this.outputOptions.getOutputFormatValue(), this.outputOptions.getOutputFile());
        try {
            dot.generateDiagram();
        }
        catch (Exception e) {
            System.out.println(Utility.readResourceFully((String)"/dot.error.txt"));
            throw e;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum GraphCommandType {
        graph,
        detailed_graph;

    }
}

