/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.serialization;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.collections.CollectionConverter;
import com.thoughtworks.xstream.converters.collections.MapConverter;
import com.thoughtworks.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.Database;
import schemacrawler.schema.DatabaseInfo;
import schemacrawler.schema.JdbcDriverInfo;
import schemacrawler.schema.NamedObject;
import schemacrawler.schema.Schema;
import schemacrawler.schema.SchemaCrawlerInfo;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.integration.serialization.SerializableDatabase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XmlDatabase
implements SerializableDatabase {
    private static final long serialVersionUID = 5314326260124511414L;
    private final Database database;

    private static XStream newXStream() throws SchemaCrawlerException {
        try {
            String[] xmlElements;
            XStream xStream = new XStream();
            xStream.setMode(1002);
            xStream.registerConverter((Converter)new CollectionConverter(xStream.getMapper()){

                public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
                    ArrayList collection = (ArrayList)source;
                    if (collection instanceof Set) {
                        ArrayList list = new ArrayList(collection);
                        Collections.sort(list);
                        collection = list;
                    }
                    for (Object item : collection) {
                        this.writeItem(item, context, writer);
                    }
                }
            }, 5000);
            xStream.registerConverter((Converter)new MapConverter(xStream.getMapper()){

                public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
                    Map map = (Map)source;
                    ArrayList entryList = new ArrayList(map.entrySet());
                    Collections.sort(entryList, new Comparator(){

                        public int compare(Object o1, Object o2) {
                            return ((Comparable)((Map.Entry)o1).getKey()).compareTo(((Map.Entry)o2).getKey());
                        }
                    });
                    for (Object e : entryList) {
                        Map.Entry entry = (Map.Entry)e;
                        ExtendedHierarchicalStreamWriterHelper.startNode((HierarchicalStreamWriter)writer, (String)this.mapper().serializedClass(Map.Entry.class), Map.Entry.class);
                        this.writeItem(entry.getKey(), context, writer);
                        this.writeItem(entry.getValue(), context, writer);
                        writer.endNode();
                    }
                }
            }, 5000);
            for (String xmlElement : xmlElements = new String[]{"checkConstraint", "column", "columnDataType", "database", "databaseProperty", "foreignKey", "foreignKeyColumnMap", "index", "indexColumn", "jdbcDriverProperty", "primaryKey", "privilege", "procedure", "procedureColumn", "resultsColumn", "resultsColumns", "schema", "table", "trigger", "view"}) {
                xStream.alias(xmlElement, Class.forName("schemacrawler.crawl.Mutable" + xmlElement.substring(0, 1).toUpperCase() + xmlElement.substring(1)));
            }
            xStream.alias("grant", Class.forName("schemacrawler.crawl.MutablePrivilege$PrivilegeGrant"));
            xStream.alias("schemaReference", Class.forName("schemacrawler.crawl.SchemaReference"));
            return xStream;
        }
        catch (ClassNotFoundException e) {
            throw new SchemaCrawlerException("Could not load internal classes", (Throwable)e);
        }
    }

    public XmlDatabase(Database database) {
        if (database == null) {
            throw new IllegalArgumentException("No database provided");
        }
        this.database = database;
    }

    public XmlDatabase(Reader reader) throws SchemaCrawlerException {
        this((Database)XmlDatabase.newXStream().fromXML(reader));
    }

    public int compareTo(NamedObject o) {
        return this.database.compareTo((Object)o);
    }

    public boolean equals(Object obj) {
        return this.database.equals(obj);
    }

    public Object getAttribute(String name) {
        return this.database.getAttribute(name);
    }

    public <T> T getAttribute(String name, T defaultValue) {
        return (T)this.database.getAttribute(name, defaultValue);
    }

    public Map<String, Object> getAttributes() {
        return this.database.getAttributes();
    }

    public DatabaseInfo getDatabaseInfo() {
        return this.database.getDatabaseInfo();
    }

    public String getFullName() {
        return this.database.getFullName();
    }

    public JdbcDriverInfo getJdbcDriverInfo() {
        return this.database.getJdbcDriverInfo();
    }

    public String getName() {
        return this.database.getName();
    }

    public String getRemarks() {
        return this.database.getRemarks();
    }

    public Schema getSchema(String schemaName) {
        return this.database.getSchema(schemaName);
    }

    public SchemaCrawlerInfo getSchemaCrawlerInfo() {
        return this.database.getSchemaCrawlerInfo();
    }

    public Schema[] getSchemas() {
        return this.database.getSchemas();
    }

    public ColumnDataType getSystemColumnDataType(String name) {
        return this.database.getSystemColumnDataType(name);
    }

    public ColumnDataType[] getSystemColumnDataTypes() {
        return this.database.getSystemColumnDataTypes();
    }

    public int hashCode() {
        return this.database.hashCode();
    }

    @Override
    public void save(Writer writer) throws SchemaCrawlerException {
        if (writer == null) {
            throw new SchemaCrawlerException("Writer not provided");
        }
        try {
            XmlDatabase.newXStream().toXML((Object)this.database, writer);
            writer.flush();
        }
        catch (IOException e) {
            throw new SchemaCrawlerException("Could not write XML", (Throwable)e);
        }
    }

    public void setAttribute(String name, Object value) {
        this.database.setAttribute(name, value);
    }
}

