/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.spring;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.commons.logging.impl.Jdk14Logger;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import schemacrawler.tools.commandline.ApplicationOptionsParser;
import schemacrawler.tools.executable.Executable;
import schemacrawler.tools.integration.spring.SpringOptions;
import schemacrawler.tools.integration.spring.SpringOptionsParser;
import schemacrawler.tools.options.ApplicationOptions;
import sf.util.Utility;

public final class Main {
    private static final Logger LOGGER = Logger.getLogger(Main.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Connection connection = null;
        try {
            ApplicationOptions applicationOptions = new ApplicationOptionsParser(args).getOptions();
            if (applicationOptions.isShowHelp()) {
                String text = Utility.readResourceFully((String)"/help/SchemaCrawler.spring.txt");
                System.out.println(text);
                System.exit(0);
            }
            System.setProperty("org.apache.commons.logging.Log", Jdk14Logger.class.getName());
            applicationOptions.applyApplicationLogLevel();
            SpringOptions springOptions = new SpringOptionsParser(args).getOptions();
            FileSystemXmlApplicationContext appContext = new FileSystemXmlApplicationContext(springOptions.getContextFileName());
            Executable executable = (Executable)appContext.getBean(springOptions.getExecutableName());
            DataSource dataSource = (DataSource)appContext.getBean(springOptions.getDataSourceName());
            connection = dataSource.getConnection();
            executable.execute(connection);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                    LOGGER.log(Level.INFO, "Closed database connection, " + connection);
                }
            }
            catch (SQLException e) {
                String errorMessage = e.getMessage();
                LOGGER.log(Level.WARNING, "Could not close the connection: " + errorMessage);
            }
        }
    }

    private Main() {
    }
}

