/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import schemacrawler.crawl.AbstractDependantObject;
import schemacrawler.crawl.JavaSqlType;
import schemacrawler.crawl.JavaSqlTypesUtility;
import schemacrawler.schema.BaseColumn;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.DatabaseObject;
import schemacrawler.schema.NamedObject;

abstract class AbstractColumn
extends AbstractDependantObject
implements BaseColumn {
    private static final long serialVersionUID = -8492662324895309485L;
    private ColumnDataType type;
    private int ordinalPosition;
    private int size;
    private int decimalDigits;
    private boolean nullable;

    AbstractColumn(DatabaseObject parent, String name) {
        super(parent, name);
    }

    public int compareTo(NamedObject obj) {
        if (obj == null) {
            return -1;
        }
        BaseColumn other = (BaseColumn)obj;
        int comparison = 0;
        if (comparison == 0) {
            comparison = this.ordinalPosition - other.getOrdinalPosition();
        }
        if (comparison == 0) {
            comparison = super.compareTo(other);
        }
        return comparison;
    }

    public final int getDecimalDigits() {
        return this.decimalDigits;
    }

    public final int getOrdinalPosition() {
        return this.ordinalPosition;
    }

    public final int getSize() {
        return this.size;
    }

    public final ColumnDataType getType() {
        return this.type;
    }

    public final String getWidth() {
        ColumnDataType columnDataType = this.getType();
        if (columnDataType == null) {
            return "";
        }
        if (this.size == 0 || this.size == Integer.MIN_VALUE || this.size == Integer.MAX_VALUE) {
            return "";
        }
        JavaSqlType.JavaSqlTypeGroup sqlDataTypeGroup = JavaSqlTypesUtility.lookupSqlDataType(columnDataType.getType()).getJavaSqlTypeGroup();
        boolean needWidth = sqlDataTypeGroup == JavaSqlType.JavaSqlTypeGroup.character || sqlDataTypeGroup == JavaSqlType.JavaSqlTypeGroup.real;
        StringBuilder columnWidthBuffer = new StringBuilder();
        if (needWidth) {
            columnWidthBuffer.append("(");
            columnWidthBuffer.append(this.size);
            if (sqlDataTypeGroup == JavaSqlType.JavaSqlTypeGroup.real) {
                columnWidthBuffer.append(", ").append(this.getDecimalDigits());
            }
            columnWidthBuffer.append(")");
        }
        return columnWidthBuffer.toString();
    }

    public final boolean isNullable() {
        return this.nullable;
    }

    final void setDecimalDigits(int decimalDigits) {
        this.decimalDigits = decimalDigits;
    }

    final void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    final void setOrdinalPosition(int ordinalPosition) {
        this.ordinalPosition = ordinalPosition;
    }

    final void setSize(int size) {
        this.size = size;
    }

    void setType(ColumnDataType type) {
        this.type = type;
    }
}

