/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schemacrawler.ConnectionOptions;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import sf.util.Utility;

abstract class BaseDatabaseConnectionOptions
implements ConnectionOptions {
    private static final long serialVersionUID = -8141436553988174836L;
    private static final Logger LOGGER = Logger.getLogger(BaseDatabaseConnectionOptions.class.getName());
    private String user;
    private String password;

    BaseDatabaseConnectionOptions() {
    }

    static void loadJdbcDriver(String jdbcDriverClassName) throws SchemaCrawlerException {
        try {
            Class.forName(jdbcDriverClassName);
        }
        catch (Exception e) {
            throw new SchemaCrawlerException("Could not load JDBC driver, " + jdbcDriverClassName, e);
        }
    }

    public final Connection createConnection() throws SchemaCrawlerException {
        String connectionUrl;
        if (this.user == null) {
            LOGGER.log(Level.WARNING, "Database user is not provided");
        }
        if (this.password == null) {
            LOGGER.log(Level.WARNING, "Database password is not provided");
        }
        try {
            connectionUrl = this.getConnectionUrl();
        }
        catch (Exception e) {
            throw new SchemaCrawlerException(String.format("Could not connect to database, for user %s", this.user), e);
        }
        try {
            return DriverManager.getConnection(connectionUrl, this.user, this.password);
        }
        catch (SQLException e) {
            throw new SchemaCrawlerException(String.format("Could not connect to %s, for user %s", connectionUrl, this.user), e);
        }
    }

    public final Driver getJdbcDriver() {
        try {
            return DriverManager.getDriver(this.getConnectionUrl());
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Could not get a database driver for database connection URL " + this.getConnectionUrl());
            return null;
        }
    }

    public final String getPassword() {
        return this.password;
    }

    public final String getUser() {
        return this.user;
    }

    public final void setPassword(String password) {
        this.password = password;
    }

    public final void setUser(String user) {
        this.user = user;
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("driver=").append(this.getJdbcDriver().getClass().getName()).append(Utility.NEWLINE);
        builder.append("url=").append(this.getConnectionUrl()).append(Utility.NEWLINE);
        builder.append("user=").append(this.getUser()).append(Utility.NEWLINE);
        return builder.toString();
    }
}

