/*
 * Decompiled with CFR 0.152.
 */
package sf.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sf.util.GraphException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectedGraph<T extends Comparable<? super T>> {
    private final Map<T, Vertex> verticesMap = new HashMap<T, Vertex>();
    private final Set<DirectedEdge> edges = new HashSet<DirectedEdge>();

    public void addDirectedEdge(T from, T to) {
        this.edges.add(new DirectedEdge(this.addVertex(from), this.addVertex(to)));
    }

    public Vertex addVertex(T value) {
        Vertex vertex;
        if (this.verticesMap.containsKey(value)) {
            vertex = this.verticesMap.get(value);
        } else {
            vertex = new Vertex(this, value);
            this.verticesMap.put(value, vertex);
        }
        return vertex;
    }

    public boolean containsCycle() {
        Collection<Vertex> vertices = this.verticesMap.values();
        for (Vertex vertex : vertices) {
            vertex.setTraversalState(TraversalState.notStarted);
        }
        for (Vertex vertex : vertices) {
            if (vertex.getTraversalState() != TraversalState.notStarted || !this.visit(vertex)) continue;
            return true;
        }
        return false;
    }

    public List<T> topologicalSort() throws GraphException {
        if (this.containsCycle()) {
            throw new GraphException("Graph contains a cycle, so cannot be topologically sorted");
        }
        int collectionSize = this.verticesMap.size();
        HashSet<Vertex> vertices = new HashSet<Vertex>(this.verticesMap.values());
        HashSet<DirectedEdge> edges = new HashSet<DirectedEdge>(this.edges);
        ArrayList<Object> sortedValues = new ArrayList<Object>(collectionSize);
        while (!vertices.isEmpty()) {
            ArrayList<Vertex> startNodes = new ArrayList<Vertex>(collectionSize);
            ArrayList unattachedNodeValues = new ArrayList(collectionSize);
            Iterator iterator = vertices.iterator();
            while (iterator.hasNext()) {
                Vertex vertex = (Vertex)iterator.next();
                if (!this.isUnattachedNode(vertex, edges)) continue;
                unattachedNodeValues.add(vertex.getValue());
                iterator.remove();
            }
            Collections.sort(unattachedNodeValues);
            sortedValues.addAll(unattachedNodeValues);
            for (Vertex vertex : vertices) {
                if (!this.isStartNode(vertex, edges)) continue;
                startNodes.add(vertex);
            }
            Collections.sort(startNodes, new Comparator<Vertex>(){

                @Override
                public int compare(Vertex vertex1, Vertex vertex2) {
                    if (vertex1 == null) {
                        return 1;
                    }
                    if (vertex2 == null) {
                        return -1;
                    }
                    return vertex1.getValue().compareTo(vertex2.getValue());
                }
            });
            for (Vertex vertex : startNodes) {
                sortedValues.add(vertex.getValue());
                this.dropOutEdges(vertex, edges);
                vertices.remove(vertex);
            }
        }
        return sortedValues;
    }

    private void dropOutEdges(Vertex vertex, Set<DirectedEdge> edges) {
        Iterator<DirectedEdge> iterator = edges.iterator();
        while (iterator.hasNext()) {
            DirectedEdge edge = iterator.next();
            if (!edge.isFrom(vertex)) continue;
            iterator.remove();
        }
    }

    private boolean isStartNode(Vertex vertex, Set<DirectedEdge> edges) {
        for (DirectedEdge edge : edges) {
            if (!edge.isTo(vertex)) continue;
            return false;
        }
        return true;
    }

    private boolean isUnattachedNode(Vertex vertex, Set<DirectedEdge> edges) {
        for (DirectedEdge edge : edges) {
            if (!edge.isTo(vertex) && !edge.isFrom(vertex)) continue;
            return false;
        }
        return true;
    }

    private boolean visit(Vertex vertex) {
        vertex.setTraversalState(TraversalState.inProgress);
        for (DirectedEdge edge : this.edges) {
            Vertex to = edge.getTo();
            if (!edge.isFrom(vertex)) continue;
            if (to.getTraversalState() == TraversalState.inProgress) {
                return true;
            }
            if (to.getTraversalState() != TraversalState.notStarted || !this.visit(edge.getTo())) continue;
            return true;
        }
        vertex.setTraversalState(TraversalState.complete);
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Vertex {
        private final T value;
        private TraversalState traversalState = TraversalState.notStarted;
        final /* synthetic */ DirectedGraph this$0;

        Vertex(T value) {
            this.this$0 = var1_1;
            this.value = value;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            Vertex other = (Vertex)obj;
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public String toString() {
            return this.value.toString();
        }

        TraversalState getTraversalState() {
            return this.traversalState;
        }

        T getValue() {
            return this.value;
        }

        void setTraversalState(TraversalState traversalState) {
            this.traversalState = traversalState;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TraversalState {
        notStarted,
        inProgress,
        complete;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DirectedEdge {
        private final Vertex from;
        private final Vertex to;

        DirectedEdge(Vertex from, Vertex to) {
            this.from = from;
            this.to = to;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            DirectedEdge other = (DirectedEdge)obj;
            if (this.from == null ? other.from != null : !this.from.equals(other.from)) {
                return false;
            }
            return !(this.to == null ? other.to != null : !this.to.equals(other.to));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.from == null ? 0 : this.from.hashCode());
            result = 31 * result + (this.to == null ? 0 : this.to.hashCode());
            return result;
        }

        public String toString() {
            return "(" + this.from + " --> " + this.to + ")";
        }

        Vertex getTo() {
            return this.to;
        }

        boolean isFrom(Vertex vertex) {
            return vertex != null && vertex.equals(this.from);
        }

        boolean isTo(Vertex vertex) {
            return vertex != null && vertex.equals(this.to);
        }
    }
}

