/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.analysis;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import schemacrawler.schema.Column;
import schemacrawler.schema.Table;
import schemacrawler.tools.analysis.BaseLinter;
import schemacrawler.tools.analysis.Lint;
import sf.util.ObjectToString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinterTableWithQuotedNames
extends BaseLinter<Table> {
    @Override
    public void lint(Table table) {
        if (table != null) {
            List<String> spacesInNamesList = this.findColumnsWithQuotedNames(table.getColumns());
            String tableName = table.getName();
            if (this.isQuotedName(tableName)) {
                spacesInNamesList.add(0, tableName);
            }
            if (!spacesInNamesList.isEmpty()) {
                final String[] spacesInNames = spacesInNamesList.toArray(new String[spacesInNamesList.size()]);
                this.addLint(table, new Lint("spaces in names, or reserved words", (Serializable)spacesInNames){
                    private static final long serialVersionUID = 4306137113072609086L;

                    public String getLintValueAsString() {
                        return ObjectToString.toString((Object)spacesInNames);
                    }
                });
            }
        }
    }

    private List<String> findColumnsWithQuotedNames(Column[] columns) {
        ArrayList<String> columnsWithQuotedNames = new ArrayList<String>();
        for (Column column : columns) {
            String columnName = column.getName();
            if (!this.isQuotedName(columnName)) continue;
            columnsWithQuotedNames.add(columnName);
        }
        return columnsWithQuotedNames;
    }

    private boolean isQuotedName(String name) {
        int nameLength = name.length();
        char[] namechars = new char[nameLength];
        name.getChars(0, nameLength, namechars, 0);
        return !Character.isJavaIdentifierStart(namechars[0]) && namechars[0] == namechars[nameLength - 1];
    }
}

