/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.operation;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schema.ResultsColumn;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.text.base.BaseFormatter;
import schemacrawler.tools.text.operation.Operation;
import schemacrawler.tools.text.operation.OperationOptions;
import schemacrawler.tools.text.util.TextFormattingHelper;
import schemacrawler.utility.SchemaCrawlerUtility;
import sf.util.Utility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DataTextFormatter
extends BaseFormatter<OperationOptions> {
    private static final Logger LOGGER = Logger.getLogger(DataTextFormatter.class.getName());
    private static final String NULL = "<null>";
    private static final String BINARY = "<binary>";
    private int dataBlockCount;
    private final Operation operation;

    DataTextFormatter(Operation operation, OperationOptions options, OutputOptions outputOptions) throws SchemaCrawlerException {
        super(options, false, outputOptions);
        this.operation = operation;
    }

    private String convertColumnDataToString(ResultsColumn[] resultsColumns, ResultSet rows, int i) throws SQLException {
        String columnDataString;
        int javaSqlType = resultsColumns[i].getType().getType();
        if (javaSqlType == 2005) {
            Clob clob = rows.getClob(i + 1);
            columnDataString = rows.wasNull() || clob == null ? NULL : this.readClob(clob);
        } else if (javaSqlType == 2007) {
            NClob nClob = rows.getNClob(i + 1);
            columnDataString = rows.wasNull() || nClob == null ? NULL : this.readClob(nClob);
        } else if (javaSqlType == 2004) {
            Blob blob = rows.getBlob(i + 1);
            columnDataString = rows.wasNull() || blob == null ? NULL : this.readBlob(blob);
        } else if (javaSqlType == -4) {
            InputStream stream = rows.getBinaryStream(i + 1);
            columnDataString = rows.wasNull() || stream == null ? NULL : this.readStream(stream);
        } else if (javaSqlType == -10 || javaSqlType == -1) {
            InputStream stream = rows.getAsciiStream(i + 1);
            columnDataString = rows.wasNull() || stream == null ? NULL : this.readStream(stream);
        } else {
            Object columnData = rows.getObject(i + 1);
            columnDataString = rows.wasNull() || columnData == null ? NULL : columnData.toString();
        }
        return columnDataString;
    }

    private void doHandleOneRow(List<String> row, String lastColumnData) {
        if (row.isEmpty()) {
            return;
        }
        ArrayList<String> outputRow = new ArrayList<String>();
        outputRow.addAll(row);
        outputRow.add(lastColumnData);
        String[] columnData = outputRow.toArray(new String[outputRow.size()]);
        this.out.println(this.formattingHelper.createRow(columnData));
    }

    private String getMessage(double aggregate) {
        Number number = Math.abs(aggregate - (double)((int)aggregate)) < 1.0E-10 ? (Number)((int)aggregate) : (Number)aggregate;
        String message = this.operation.getCountMessage(number);
        return message;
    }

    private void handleAggregateOperationForTable(String title, ResultSet results) throws SchemaCrawlerException {
        long aggregate = 0L;
        try {
            if (results.next()) {
                aggregate = results.getLong(1);
            }
        }
        catch (SQLException e) {
            throw new SchemaCrawlerException("Could not obtain aggregate data", (Throwable)e);
        }
        String message = this.getMessage(aggregate);
        this.out.println(this.formattingHelper.createNameRow(title, message, false));
    }

    private void iterateRows(ResultsColumn[] resultsColumns, ResultSet rows) throws SQLException {
        while (rows.next()) {
            int columnCount = resultsColumns.length;
            ArrayList<String> currentRow = new ArrayList<String>(columnCount);
            for (int i = 0; i < columnCount; ++i) {
                String columnDataString = this.convertColumnDataToString(resultsColumns, rows, i);
                currentRow.add(columnDataString);
            }
            String[] columnData = currentRow.toArray(new String[currentRow.size()]);
            this.out.println(this.formattingHelper.createRow(columnData));
        }
    }

    private void iterateRowsAndMerge(ResultsColumn[] resultsColumns, ResultSet rows) throws SQLException {
        int columnCount = resultsColumns.length;
        ArrayList<String> previousRow = new ArrayList<String>();
        StringBuilder currentRowLastColumn = new StringBuilder();
        while (rows.next()) {
            ArrayList<String> currentRow = new ArrayList<String>(columnCount - 1);
            for (int i = 0; i < columnCount - 1; ++i) {
                String columnDataString = this.convertColumnDataToString(resultsColumns, rows, i);
                currentRow.add(columnDataString);
            }
            String lastColumnDataString = this.convertColumnDataToString(resultsColumns, rows, resultsColumns.length - 1);
            if (((Object)currentRow).equals(previousRow)) {
                currentRowLastColumn.append(lastColumnDataString);
            } else {
                this.doHandleOneRow(previousRow, currentRowLastColumn.toString());
                currentRowLastColumn = new StringBuilder();
                currentRowLastColumn.append(lastColumnDataString);
            }
            previousRow = currentRow;
        }
        this.doHandleOneRow(previousRow, currentRowLastColumn.toString());
    }

    private void printHeader() {
        if (this.operation != null) {
            this.out.println(this.formattingHelper.createHeader(TextFormattingHelper.DocumentHeaderType.subTitle, this.operation.getDescription()));
        } else {
            this.out.println(this.formattingHelper.createHeader(TextFormattingHelper.DocumentHeaderType.subTitle, "Query"));
        }
        if (this.operation == Operation.count) {
            this.out.println(this.formattingHelper.createObjectStart(this.operation.getDescription()));
        }
    }

    private String readBlob(Blob blob) {
        if (blob == null) {
            return NULL;
        }
        if (((OperationOptions)this.options).isShowLobs()) {
            String lobData;
            InputStream in = null;
            try {
                try {
                    in = blob.getBinaryStream();
                }
                catch (SQLFeatureNotSupportedException e) {
                    in = null;
                }
                lobData = in != null ? Utility.readFully((InputStream)in) : BINARY;
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, "Could not read BLOB data", e);
                lobData = BINARY;
            }
            return lobData;
        }
        return BINARY;
    }

    private String readClob(Clob clob) {
        if (clob == null) {
            return NULL;
        }
        if (((OperationOptions)this.options).isShowLobs()) {
            String lobData;
            Reader rdr = null;
            try {
                try {
                    rdr = new InputStreamReader(clob.getAsciiStream());
                }
                catch (SQLFeatureNotSupportedException e) {
                    rdr = null;
                }
                if (rdr == null) {
                    try {
                        rdr = clob.getCharacterStream();
                    }
                    catch (SQLFeatureNotSupportedException e) {
                        rdr = null;
                    }
                }
                if (rdr != null) {
                    lobData = Utility.readFully((Reader)rdr);
                    if (lobData.length() == 0) {
                        long clobLength = clob.length();
                        lobData = clob.getSubString(1L, (int)clobLength);
                    }
                } else {
                    lobData = BINARY;
                }
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, "Could not read CLOB data", e);
                lobData = BINARY;
            }
            return lobData;
        }
        return BINARY;
    }

    private String readStream(InputStream stream) {
        if (stream == null) {
            return NULL;
        }
        if (((OperationOptions)this.options).isShowLobs()) {
            BufferedInputStream in = new BufferedInputStream(stream);
            String lobData = Utility.readFully((InputStream)in);
            return lobData;
        }
        return BINARY;
    }

    void begin() {
        if (!this.outputOptions.isNoHeader()) {
            this.out.println(this.formattingHelper.createDocumentStart());
        }
    }

    void end() {
        if (this.operation == Operation.count) {
            this.out.println(this.formattingHelper.createObjectEnd());
        }
        if (!this.outputOptions.isNoFooter()) {
            this.out.println(this.formattingHelper.createDocumentEnd());
        }
        this.out.flush();
        this.outputOptions.closeOutputWriter((Writer)this.out);
    }

    void handleData(String title, ResultSet rows) throws SchemaCrawlerException {
        if (this.dataBlockCount == 0) {
            this.printHeader();
        }
        if (this.operation == Operation.count) {
            this.handleAggregateOperationForTable(title, rows);
        } else {
            this.out.println(this.formattingHelper.createObjectStart(title));
            try {
                ResultsColumn[] resultsColumns = SchemaCrawlerUtility.getResultColumns((ResultSet)rows).getColumns();
                int columnCount = resultsColumns.length;
                String[] columnNames = new String[columnCount];
                for (int i = 0; i < columnCount; ++i) {
                    columnNames[i] = resultsColumns[i].getName();
                }
                this.out.println(this.formattingHelper.createRowHeader(columnNames));
                if (((OperationOptions)this.options).isMergeRows() && columnCount > 1) {
                    this.iterateRowsAndMerge(resultsColumns, rows);
                } else {
                    this.iterateRows(resultsColumns, rows);
                }
            }
            catch (SQLException e) {
                throw new SchemaCrawlerException(e.getMessage(), (Throwable)e);
            }
            this.out.println(this.formattingHelper.createObjectEnd());
        }
        ++this.dataBlockCount;
    }
}

