/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline;

import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.InclusionRule;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaInfoLevel;
import schemacrawler.tools.commandline.BaseOptionsParser;
import schemacrawler.tools.options.InfoLevel;
import sf.util.clparser.BooleanOption;
import sf.util.clparser.NumberOption;
import sf.util.clparser.StringOption;

final class SchemaCrawlerOptionsParser
extends BaseOptionsParser<SchemaCrawlerOptions> {
    private static final String DEFAULT_TABLE_TYPES = "TABLE,VIEW";
    private static final String DEFAULT_ROUTINE_TYPES = "PROCEDURE,FUNCTION";
    private final SchemaCrawlerOptions options;

    SchemaCrawlerOptionsParser(Config config) {
        super(new StringOption("infolevel", "standard"), new StringOption("schemas", ""), new StringOption("table_types", DEFAULT_TABLE_TYPES), new StringOption("tables", ".*"), new StringOption("excludecolumns", ""), new StringOption("synonyms", ".*"), new StringOption("routine_types", DEFAULT_ROUTINE_TYPES), new StringOption("routines", ".*"), new StringOption("excludeinout", ""), new StringOption("grepcolumns", ""), new StringOption("grepinout", ""), new StringOption("grepdef", ""), new BooleanOption(Character.valueOf('v'), "invert-match"), new NumberOption("parents", (Number)0), new NumberOption("children", (Number)0));
        this.options = new SchemaCrawlerOptions(config);
    }

    @Override
    protected SchemaCrawlerOptions getOptions() throws SchemaCrawlerException {
        if (this.hasOptionValue("infolevel")) {
            try {
                String infoLevel = this.getStringValue("infolevel");
                SchemaInfoLevel schemaInfoLevel = InfoLevel.valueOf((String)infoLevel).getSchemaInfoLevel();
                this.options.setSchemaInfoLevel(schemaInfoLevel);
            }
            catch (IllegalArgumentException e) {
                this.options.setSchemaInfoLevel(SchemaInfoLevel.standard());
            }
        } else {
            throw new SchemaCrawlerException("No infolevel specified");
        }
        if (this.hasOptionValue("schemas")) {
            InclusionRule schemaInclusionRule = new InclusionRule(this.getStringValue("schemas"), "");
            this.options.setSchemaInclusionRule(schemaInclusionRule);
        }
        if (this.hasOptionValue("table_types")) {
            this.options.setTableTypes(this.getStringValue("table_types"));
        }
        if (this.hasOptionValue("tables")) {
            InclusionRule tableInclusionRule = new InclusionRule(this.getStringValue("tables"), "");
            this.options.setTableInclusionRule(tableInclusionRule);
        }
        if (this.hasOptionValue("excludecolumns")) {
            InclusionRule columnInclusionRule = new InclusionRule(".*", this.getStringValue("excludecolumns"));
            this.options.setColumnInclusionRule(columnInclusionRule);
        }
        if (this.hasOptionValue("routine_types")) {
            this.options.setRoutineTypes(this.getStringValue("routine_types"));
        }
        if (this.hasOptionValue("routines")) {
            InclusionRule routineInclusionRule = new InclusionRule(this.getStringValue("routines"), "");
            this.options.setRoutineInclusionRule(routineInclusionRule);
        }
        if (this.hasOptionValue("excludeinout")) {
            InclusionRule routineColumnInclusionRule = new InclusionRule(".*", this.getStringValue("excludeinout"));
            this.options.setRoutineColumnInclusionRule(routineColumnInclusionRule);
        }
        if (this.hasOptionValue("synonyms")) {
            InclusionRule synonymInclusionRule = new InclusionRule(this.getStringValue("synonyms"), "");
            this.options.setSynonymInclusionRule(synonymInclusionRule);
        }
        if (this.hasOptionValue("v")) {
            this.options.setGrepInvertMatch(this.getBooleanValue("v"));
        }
        if (this.hasOptionValue("grepcolumns")) {
            InclusionRule grepColumnInclusionRule = new InclusionRule(this.getStringValue("grepcolumns"), "");
            this.options.setGrepColumnInclusionRule(grepColumnInclusionRule);
        } else {
            this.options.setGrepColumnInclusionRule(null);
        }
        if (this.hasOptionValue("grepinout")) {
            InclusionRule grepRoutineColumnInclusionRule = new InclusionRule(this.getStringValue("grepinout"), "");
            this.options.setGrepRoutineColumnInclusionRule(grepRoutineColumnInclusionRule);
        } else {
            this.options.setGrepRoutineColumnInclusionRule(null);
        }
        if (this.hasOptionValue("grepdef")) {
            InclusionRule grepDefinitionInclusionRule = new InclusionRule(this.getStringValue("grepdef"), "");
            this.options.setGrepDefinitionInclusionRule(grepDefinitionInclusionRule);
        } else {
            this.options.setGrepDefinitionInclusionRule(null);
        }
        if (this.hasOptionValue("parents")) {
            int parentTableFilterDepth = this.getIntegerValue("parents");
            this.options.setParentTableFilterDepth(parentTableFilterDepth);
        } else {
            this.options.setParentTableFilterDepth(0);
        }
        if (this.hasOptionValue("children")) {
            int childTableFilterDepth = this.getIntegerValue("children");
            this.options.setChildTableFilterDepth(childTableFilterDepth);
        } else {
            this.options.setParentTableFilterDepth(0);
        }
        return this.options;
    }
}

