/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.graph;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import sf.util.Utility;

public final class ProcessExecutor {
    private static final Logger LOGGER = Logger.getLogger(ProcessExecutor.class.getName());
    private final List<String> command;
    private String processOutput;
    private String processError;

    private static String createCommandLine(List<String> command) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String arg : command) {
            if (first) {
                first = false;
            } else {
                sb.append(" ");
            }
            if (Utility.containsWhitespace((String)arg)) {
                sb.append("\"").append(arg).append("\"");
                continue;
            }
            sb.append(arg);
        }
        return sb.toString();
    }

    public ProcessExecutor(List<String> command) throws IOException {
        if (command == null || command.isEmpty()) {
            throw new RuntimeException("No command provided");
        }
        this.command = command;
    }

    public int execute() throws IOException {
        LOGGER.log(Level.CONFIG, "Executing:\n" + ProcessExecutor.createCommandLine(this.command));
        ExecutorService threadPool = Executors.newFixedThreadPool(2);
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(this.command);
            Process process = processBuilder.start();
            FutureTask<String> inReaderTask = new FutureTask<String>(new StreamReader(process.getInputStream()));
            threadPool.execute(inReaderTask);
            FutureTask<String> errReaderTask = new FutureTask<String>(new StreamReader(process.getErrorStream()));
            threadPool.execute(errReaderTask);
            int exitCode = process.waitFor();
            this.processOutput = inReaderTask.get();
            this.processError = errReaderTask.get();
            int n = exitCode;
            return n;
        }
        catch (SecurityException e) {
            throw new IOException(e.getMessage(), e);
        }
        catch (ExecutionException e) {
            throw new IOException(e.getMessage(), e);
        }
        catch (InterruptedException e) {
            throw new IOException(e.getMessage(), e);
        }
        finally {
            threadPool.shutdown();
        }
    }

    public String getProcessError() {
        return this.processError;
    }

    public String getProcessOutput() {
        return this.processOutput;
    }

    final class StreamReader
    implements Callable<String> {
        private final InputStream in;

        private StreamReader(InputStream in) {
            if (in == null) {
                throw new RuntimeException("No input stream provided");
            }
            this.in = in;
        }

        @Override
        public String call() throws Exception {
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.in));
            return Utility.readFully((Reader)reader);
        }
    }
}

