/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.traversal;

import java.util.Collection;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.Database;
import schemacrawler.schema.Routine;
import schemacrawler.schema.Synonym;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.traversal.SchemaTraversalHandler;

public class SchemaTraverser {
    private Database database;
    private SchemaTraversalHandler handler;

    public Database getDatabase() {
        return this.database;
    }

    public SchemaTraversalHandler getFormatter() {
        return this.handler;
    }

    public void setDatabase(Database database) {
        this.database = database;
    }

    public void setFormatter(SchemaTraversalHandler formatter) {
        this.handler = formatter;
    }

    public final void traverse() throws SchemaCrawlerException {
        if (this.database == null || this.handler == null) {
            throw new SchemaCrawlerException("Cannot traverse database");
        }
        this.handler.begin();
        this.handler.handleInfoStart();
        this.handler.handle(this.database.getSchemaCrawlerInfo());
        this.handler.handle(this.database.getDatabaseInfo());
        this.handler.handle(this.database.getJdbcDriverInfo());
        this.handler.handleInfoEnd();
        Collection columnDataTypes = this.database.getColumnDataTypes();
        Collection tables = this.database.getTables();
        Collection routines = this.database.getRoutines();
        Collection synonyms = this.database.getSynonyms();
        if (!columnDataTypes.isEmpty()) {
            this.handler.handleColumnDataTypesStart();
            for (ColumnDataType columnDataType : columnDataTypes) {
                this.handler.handle(columnDataType);
            }
            this.handler.handleColumnDataTypesEnd();
        }
        if (!tables.isEmpty()) {
            this.handler.handleTablesStart();
            for (Table table : tables) {
                this.handler.handle(table);
            }
            this.handler.handleTablesEnd();
        }
        if (!routines.isEmpty()) {
            this.handler.handleRoutinesStart();
            for (Routine routine : routines) {
                this.handler.handle(routine);
            }
            this.handler.handleRoutinesEnd();
        }
        if (!synonyms.isEmpty()) {
            this.handler.handleSynonymsStart();
            for (Synonym synonym : synonyms) {
                this.handler.handle(synonym);
            }
            this.handler.handleSynonymsEnd();
        }
        this.handler.end();
    }
}

