/*
 * Decompiled with CFR 0.152.
 */
package net.sozal.stackwriter.agent;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.sozal.stackwriter.agent.logger.Logger;
import net.sozal.stackwriter.api.ErrorListener;
import net.sozal.stackwriter.api.domain.Frame;

public final class ExceptionSnapshotSupport {
    private static final ThreadLocal<WeakHashMap<Throwable, Frame[]>> cache = new ThreadLocal<WeakHashMap<Throwable, Frame[]>>(){

        @Override
        protected WeakHashMap<Throwable, Frame[]> initialValue() {
            return new WeakHashMap<Throwable, Frame[]>();
        }
    };
    private static final ThreadLocal<Boolean> onErrorInProgress = new ThreadLocal();
    private static final Set<String> appPackages = new HashSet<String>();
    private static ErrorListener errorListener;

    private ExceptionSnapshotSupport() {
    }

    public static boolean shouldTakeSnapshot(Throwable error, int numFrames) {
        if (Boolean.TRUE.equals(onErrorInProgress.get())) {
            return false;
        }
        try {
            if (appPackages.isEmpty()) {
                return false;
            }
            Map weakMap = cache.get();
            Frame[] existing = (Frame[])weakMap.get(error);
            if (existing != null && numFrames <= existing.length) {
                return false;
            }
            boolean inAppPackages = false;
            block2: for (StackTraceElement stackTraceElement : error.getStackTrace()) {
                for (String appFrame : appPackages) {
                    if (!stackTraceElement.getClassName().startsWith(appFrame)) continue;
                    inAppPackages = true;
                    continue block2;
                }
            }
            if (!inAppPackages) {
                return false;
            }
            ErrorListener ec = errorListener;
            if (ec == null) {
                return true;
            }
            return ec.shouldTakeSnapshot(error);
        }
        catch (Throwable t) {
            Logger.error("Error occurred while checking whether snapshot should be take on error: " + error.getMessage(), t);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onError(Throwable error, Frame[] frames) {
        if (Boolean.TRUE.equals(onErrorInProgress.get())) {
            return;
        }
        try {
            onErrorInProgress.set(true);
            Map weakMap = cache.get();
            weakMap.put(error, frames);
            ErrorListener el = errorListener;
            if (el != null) {
                el.onError(error, frames);
            }
        }
        catch (Throwable t) {
            Logger.error("Error occurred on error: " + error.getMessage(), t);
        }
        finally {
            onErrorInProgress.set(false);
        }
    }

    public static void addAppPackage(String appPackage) {
        appPackages.add(appPackage);
    }

    public static void setErrorListener(ErrorListener errorListener) {
        ExceptionSnapshotSupport.errorListener = errorListener;
    }
}

