/*
 * Decompiled with CFR 0.152.
 */
package net.sozal.stackwriter.agent.logger;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import net.sozal.stackwriter.agent.util.ExceptionUtils;

public final class Logger {
    private static final String STACKWRITER_PREFIX = "[STACKWRITER] ";
    private static final String DEBUG_LEVEL = "DEBUG ";
    private static final String INFO_LEVEL = "INFO  ";
    private static final String ERROR_LEVEL = "ERROR ";
    private static final String DEBUG_ENABLE_CONFIG_NAME = "stackwriter.debug.enable";
    private static final DateFormat TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    public static final boolean DEBUG_ENABLE = Logger.isDebugEnabled();

    private Logger() {
    }

    private static boolean isDebugEnabled() {
        for (String string : System.getProperties().stringPropertyNames()) {
            String sysPropName = string.trim();
            String sysPropValue = System.getProperty(string);
            if (!DEBUG_ENABLE_CONFIG_NAME.equalsIgnoreCase(sysPropName)) continue;
            return Boolean.parseBoolean(sysPropValue);
        }
        for (Map.Entry entry : System.getenv().entrySet()) {
            String envVarName = ((String)entry.getKey()).trim();
            String envVarValue = ((String)entry.getValue()).trim();
            if (!DEBUG_ENABLE_CONFIG_NAME.equalsIgnoreCase(envVarName.replace("_", "."))) continue;
            return Boolean.parseBoolean(envVarValue);
        }
        return false;
    }

    private static String getTime() {
        return TIME_FORMAT.format(new Date());
    }

    private static String getLogPrefix(String level) {
        return STACKWRITER_PREFIX + level + Logger.getTime() + " [" + Thread.currentThread().getName() + "] : ";
    }

    public static void debug(String message) {
        if (DEBUG_ENABLE) {
            System.out.println(Logger.getLogPrefix(DEBUG_LEVEL) + message);
        }
    }

    public static void info(String message) {
        System.out.println(Logger.getLogPrefix(INFO_LEVEL) + message);
    }

    public static void error(String message) {
        System.err.println(Logger.getLogPrefix(ERROR_LEVEL) + message);
    }

    public static void error(String message, Throwable error) {
        System.err.println(Logger.getLogPrefix(ERROR_LEVEL) + message);
        System.err.println(ExceptionUtils.toString(error));
    }
}

