/*
 * Decompiled with CFR 0.152.
 */
package net.sozal.stackwriter.agent.logger;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.sozal.stackwriter.agent.util.ExceptionUtils;

public final class Logger {
    private static final String STACKWRITER_PREFIX = "[STACKWRITER] ";
    private static final String TRACE_LEVEL = "TRACE ";
    private static final String DEBUG_LEVEL = "DEBUG ";
    private static final String INFO_LEVEL = "INFO  ";
    private static final String WARN_LEVEL = "WARN  ";
    private static final String ERROR_LEVEL = "ERROR ";
    private static final int TRACE_LEVEL_CODE = 0;
    private static final int DEBUG_LEVEL_CODE = 1;
    private static final int INFO_LEVEL_CODE = 2;
    private static final int WARN_LEVEL_CODE = 3;
    private static final int ERROR_LEVEL_CODE = 4;
    private static final Map<String, Integer> LOG_LEVEL_CODES = new HashMap<String, Integer>(){
        {
            this.put(Logger.TRACE_LEVEL.trim(), 0);
            this.put(Logger.DEBUG_LEVEL.trim(), 1);
            this.put(Logger.INFO_LEVEL.trim(), 2);
            this.put(Logger.WARN_LEVEL.trim(), 3);
            this.put(Logger.ERROR_LEVEL.trim(), 4);
        }
    };
    private static final String LOG_LEVEL_CONFIG_NAME = "stackwriter.log.level";
    private static final DateFormat TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static final int LOG_LEVEL = Logger.getLogLevel();

    private Logger() {
    }

    private static int getLogLevel() {
        Integer logLevelCode;
        for (String string : System.getProperties().stringPropertyNames()) {
            String sysPropName = string.trim();
            String sysPropValue = System.getProperty(string);
            if (!LOG_LEVEL_CONFIG_NAME.equalsIgnoreCase(sysPropName) || (logLevelCode = LOG_LEVEL_CODES.get(sysPropValue.toUpperCase())) == null) continue;
            return logLevelCode;
        }
        for (Map.Entry entry : System.getenv().entrySet()) {
            String envVarName = ((String)entry.getKey()).trim();
            String envVarValue = ((String)entry.getValue()).trim();
            if (!LOG_LEVEL_CONFIG_NAME.equalsIgnoreCase(envVarName.replace("_", ".")) || (logLevelCode = LOG_LEVEL_CODES.get(envVarValue.toUpperCase())) == null) continue;
            return logLevelCode;
        }
        return 4;
    }

    private static String getTime() {
        return TIME_FORMAT.format(new Date());
    }

    private static String getLogPrefix(String level) {
        return STACKWRITER_PREFIX + level + Logger.getTime() + " [" + Thread.currentThread().getName() + "] : ";
    }

    public static void trace(String message) {
        if (LOG_LEVEL <= 0) {
            System.out.println(Logger.getLogPrefix(TRACE_LEVEL) + message);
        }
    }

    public static void debug(String message) {
        if (LOG_LEVEL <= 1) {
            System.out.println(Logger.getLogPrefix(DEBUG_LEVEL) + message);
        }
    }

    public static void info(String message) {
        if (LOG_LEVEL <= 2) {
            System.out.println(Logger.getLogPrefix(INFO_LEVEL) + message);
        }
    }

    public static void warn(String message) {
        if (LOG_LEVEL <= 3) {
            System.out.println(Logger.getLogPrefix(WARN_LEVEL) + message);
        }
    }

    public static void error(String message) {
        if (LOG_LEVEL <= 4) {
            System.err.println(Logger.getLogPrefix(ERROR_LEVEL) + message);
        }
    }

    public static void error(String message, Throwable error) {
        if (LOG_LEVEL <= 4) {
            System.err.println(Logger.getLogPrefix(ERROR_LEVEL) + message);
            System.err.println(ExceptionUtils.toString(error));
        }
    }
}

