/*
 * Decompiled with CFR 0.152.
 */
package net.spals.appbuilder.mapstore.dynamodb;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.document.DynamoDB;
import com.amazonaws.services.dynamodbv2.document.Index;
import com.amazonaws.services.dynamodbv2.document.Item;
import com.amazonaws.services.dynamodbv2.document.Table;
import com.amazonaws.services.dynamodbv2.document.spec.QuerySpec;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.CreateGlobalSecondaryIndexAction;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeyType;
import com.amazonaws.services.dynamodbv2.model.Projection;
import com.amazonaws.services.dynamodbv2.model.ProjectionType;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.TableDescription;
import com.amazonaws.services.dynamodbv2.model.TableStatus;
import com.google.inject.Inject;
import com.netflix.governator.annotations.Configuration;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PreDestroy;
import javax.validation.constraints.NotNull;
import net.spals.appbuilder.annotations.service.AutoBindInMap;
import net.spals.appbuilder.mapstore.core.MapStoreIndexPlugin;
import net.spals.appbuilder.mapstore.core.model.MapQueryOptions;
import net.spals.appbuilder.mapstore.core.model.MapStoreIndexName;
import net.spals.appbuilder.mapstore.core.model.MapStoreKey;
import net.spals.appbuilder.mapstore.core.model.MapStoreTableKey;
import net.spals.appbuilder.mapstore.dynamodb.DynamoDBMapStoreUtil$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@AutoBindInMap(baseClass=MapStoreIndexPlugin.class, key="dynamoDB")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015e!B\u0001\u0003\u0001\ta!a\u0007#z]\u0006lw\u000e\u0012\"NCB\u001cFo\u001c:f\u0013:$W\r\u001f)mk\u001eLgN\u0003\u0002\u0004\t\u0005AA-\u001f8b[>$'M\u0003\u0002\u0006\r\u0005AQ.\u00199ti>\u0014XM\u0003\u0002\b\u0011\u0005Q\u0011\r\u001d9ck&dG-\u001a:\u000b\u0005%Q\u0011!B:qC2\u001c(\"A\u0006\u0002\u00079,GoE\u0002\u0001\u001bU\u0001\"AD\n\u000e\u0003=Q!\u0001E\t\u0002\t1\fgn\u001a\u0006\u0002%\u0005!!.\u0019<b\u0013\t!rB\u0001\u0004PE*,7\r\u001e\t\u0003-ei\u0011a\u0006\u0006\u00031\u0011\tAaY8sK&\u0011!d\u0006\u0002\u0014\u001b\u0006\u00048\u000b^8sK&sG-\u001a=QYV<\u0017N\u001c\u0005\t9\u0001\u0011\t\u0011)A\u0005=\u0005qA-\u001f8b[>$%i\u00117jK:$8\u0001\u0001\t\u0003?!j\u0011\u0001\t\u0006\u0003C\t\n!\u0002Z=oC6|GM\u0019<3\u0015\t\u0019C%\u0001\u0005tKJ4\u0018nY3t\u0015\t)c%A\u0005b[\u0006TxN\\1xg*\tq%A\u0002d_6L!!\u000b\u0011\u0003\u001d\u0005k\u0017M_8o\tft\u0017-\\8E\u0005\")1\u0006\u0001C\u0001Y\u00051A(\u001b8jiz\"\"!L\u0018\u0011\u00059\u0002Q\"\u0001\u0002\t\u000bqQ\u0003\u0019\u0001\u0010)\u0005)\n\u0004C\u0001\u001a8\u001b\u0005\u0019$B\u0001\u001b6\u0003\u0019IgN[3di*\u0011aGJ\u0001\u0007O>|w\r\\3\n\u0005a\u001a$AB%oU\u0016\u001cG\u000f\u0003\u0005;\u0001\u0001\u0007I\u0011\u0001\u0002<\u00039\u0019\u0018P\\2ie>tw.^:E\t2+\u0012\u0001\u0010\t\u0003{\u0001k\u0011A\u0010\u0006\u0002\u007f\u0005)1oY1mC&\u0011\u0011I\u0010\u0002\b\u0005>|G.Z1o\u0011!\u0019\u0005\u00011A\u0005\u0002\t!\u0015AE:z]\u000eD'o\u001c8pkN$E\tT0%KF$\"!\u0012%\u0011\u0005u2\u0015BA$?\u0005\u0011)f.\u001b;\t\u000f%\u0013\u0015\u0011!a\u0001y\u0005\u0019\u0001\u0010J\u0019\t\r-\u0003\u0001\u0015)\u0003=\u0003=\u0019\u0018P\\2ie>tw.^:E\t2\u0003\u0003\u0006\u0002&N/b\u0003\"AT+\u000e\u0003=S!\u0001U)\u0002\u0017\u0005tgn\u001c;bi&|gn\u001d\u0006\u0003%N\u000b!bZ8wKJt\u0017\r^8s\u0015\t!f%A\u0004oKR4G.\u001b=\n\u0005Y{%!D\"p]\u001aLw-\u001e:bi&|g.A\u0003wC2,X-I\u0001Z\u0003\u0001j\u0017\r]*u_J,g\u0006Z=oC6|GI\u0011\u0018ts:\u001c\u0007N]8o_V\u001cH\t\u0012')\u0005)[\u0006C\u0001/d\u001b\u0005i&B\u00010`\u0003-\u0019wN\\:ue\u0006Lg\u000e^:\u000b\u0005\u0001\f\u0017A\u0003<bY&$\u0017\r^5p]*\t!-A\u0003kCZ\f\u00070\u0003\u0002e;\n9aj\u001c;Ok2d\u0007b\u00024\u0001\u0005\u0004%IaZ\u0001\tIft\u0017-\\8E\u0005V\t\u0001\u000e\u0005\u0002jY6\t!N\u0003\u0002lA\u0005AAm\\2v[\u0016tG/\u0003\u0002nU\nAA)\u001f8b[>$%\t\u0003\u0004p\u0001\u0001\u0006I\u0001[\u0001\nIft\u0017-\\8E\u0005\u0002BQ!\u001d\u0001\u0005BI\fQa\u00197pg\u0016$\u0012!\u0012\u0015\u0003aR\u0004\"!\u001e=\u000e\u0003YT!a^1\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002zm\nQ\u0001K]3EKN$(o\\=\t\u000bm\u0004A\u0011\t?\u0002\u0017\r\u0014X-\u0019;f\u0013:$W\r\u001f\u000b\u0005yu\fY\u0001C\u0003\u007fu\u0002\u0007q0A\u0005j]\u0012,\u0007PT1nKB!\u0011\u0011AA\u0004\u001b\t\t\u0019AC\u0002\u0002\u0006]\tQ!\\8eK2LA!!\u0003\u0002\u0004\t\tR*\u00199Ti>\u0014X-\u00138eKbt\u0015-\\3\t\u000f\u00055!\u00101\u0001\u0002\u0010\u0005A\u0011N\u001c3fq.+\u0017\u0010\u0005\u0003\u0002\u0002\u0005E\u0011\u0002BA\n\u0003\u0007\u0011\u0001#T1q'R|'/\u001a+bE2,7*Z=\t\u000f\u0005]\u0001\u0001\"\u0011\u0002\u001a\u0005IAM]8q\u0013:$W\r\u001f\u000b\u0004y\u0005m\u0001B\u0002@\u0002\u0016\u0001\u0007q\u0010C\u0004\u0002 \u0001!\t%!\t\u0002\u000f\u001d,G/\u0013;f[R1\u00111EA%\u0003\u0017\u0002b!!\n\u0002,\u0005=RBAA\u0014\u0015\r\tI#E\u0001\u0005kRLG.\u0003\u0003\u0002.\u0005\u001d\"\u0001C(qi&|g.\u00197\u0011\u0011\u0005\u0015\u0012\u0011GA\u001b\u0003\u0007JA!a\r\u0002(\t\u0019Q*\u00199\u0011\t\u0005]\u0012Q\b\b\u0004{\u0005e\u0012bAA\u001e}\u00051\u0001K]3eK\u001aLA!a\u0010\u0002B\t11\u000b\u001e:j]\u001eT1!a\u000f?!\ri\u0014QI\u0005\u0004\u0003\u000fr$AB!osJ+g\r\u0003\u0004\u007f\u0003;\u0001\ra \u0005\t\u0003\u001b\ni\u00021\u0001\u0002P\u0005\u00191.Z=\u0011\t\u0005\u0005\u0011\u0011K\u0005\u0005\u0003'\n\u0019AA\u0006NCB\u001cFo\u001c:f\u0017\u0016L\bbBA,\u0001\u0011\u0005\u0013\u0011L\u0001\tO\u0016$\u0018\n^3ngRA\u00111LA1\u0003G\n)\u0007\u0005\u0004\u0002&\u0005u\u0013qF\u0005\u0005\u0003?\n9C\u0001\u0003MSN$\bB\u0002@\u0002V\u0001\u0007q\u0010\u0003\u0005\u0002N\u0005U\u0003\u0019AA(\u0011!\t9'!\u0016A\u0002\u0005%\u0014aB8qi&|gn\u001d\t\u0005\u0003\u0003\tY'\u0003\u0003\u0002n\u0005\r!aD'baF+XM]=PaRLwN\\:)\u0017\u0001\t\t(a \u0002\u0002\u00065\u00131\u0011\t\u0005\u0003g\nY(\u0004\u0002\u0002v)!\u0011qOA=\u0003\u001d\u0019XM\u001d<jG\u0016T!\u0001\u0015\u0004\n\t\u0005u\u0014Q\u000f\u0002\u000e\u0003V$xNQ5oI&sW*\u00199\u0002\u0013\t\f7/Z\"mCN\u001c8%A\u000b\"\u0003\u0019\u0004")
public class DynamoDBMapStoreIndexPlugin
implements MapStoreIndexPlugin {
    @NotNull
    @Configuration(value="mapStore.dynamoDB.synchronousDDL")
    private boolean synchronousDDL = false;
    private final DynamoDB dynamoDB;

    public boolean synchronousDDL() {
        return this.synchronousDDL;
    }

    public void synchronousDDL_$eq(boolean x$1) {
        this.synchronousDDL = x$1;
    }

    private DynamoDB dynamoDB() {
        return this.dynamoDB;
    }

    @PreDestroy
    public void close() {
        this.dynamoDB().shutdown();
    }

    public boolean createIndex(MapStoreIndexName indexName, MapStoreTableKey indexKey) {
        Option option;
        block4: {
            boolean bl;
            block7: {
                boolean bl2;
                block6: {
                    Index index;
                    block5: {
                        Index index2;
                        block3: {
                            Table table;
                            CreateGlobalSecondaryIndexAction createGSIAction;
                            AttributeDefinition hashKeyAttrDef;
                            block2: {
                                hashKeyAttrDef = new AttributeDefinition().withAttributeName(indexKey.getHashField()).withAttributeType(DynamoDBMapStoreUtil$.MODULE$.createAttributeType(indexKey.getHashFieldType()));
                                KeySchemaElement hashKeySchema = new KeySchemaElement(indexKey.getHashField(), KeyType.HASH);
                                createGSIAction = new CreateGlobalSecondaryIndexAction().withIndexName(indexName.getIndexName()).withProjection(new Projection().withProjectionType(ProjectionType.ALL)).withKeySchema(new KeySchemaElement[]{hashKeySchema});
                                Option rangeKeyAttrDefOpt = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(indexKey.getRangeField())).map((Function1)new Serializable(this, indexKey){
                                    public static final long serialVersionUID = 0L;
                                    private final MapStoreTableKey indexKey$1;

                                    public final AttributeDefinition apply(String rangeField) {
                                        return new AttributeDefinition().withAttributeName(rangeField).withAttributeType(DynamoDBMapStoreUtil$.MODULE$.createAttributeType((Class)this.indexKey$1.getRangeFieldType().get()));
                                    }
                                    {
                                        this.indexKey$1 = indexKey$1;
                                    }
                                });
                                rangeKeyAttrDefOpt.foreach((Function1)new Serializable(this, createGSIAction){
                                    public static final long serialVersionUID = 0L;
                                    private final CreateGlobalSecondaryIndexAction createGSIAction$1;

                                    public final CreateGlobalSecondaryIndexAction apply(AttributeDefinition rangeKey) {
                                        KeySchemaElement rangeKeySchema = new KeySchemaElement(rangeKey.getAttributeName(), KeyType.RANGE);
                                        return this.createGSIAction$1.withKeySchema(new KeySchemaElement[]{rangeKeySchema});
                                    }
                                    {
                                        this.createGSIAction$1 = createGSIAction$1;
                                    }
                                });
                                ProvisionedThroughput provisionedThroughput = new ProvisionedThroughput().withReadCapacityUnits(Predef$.MODULE$.long2Long(1L)).withWriteCapacityUnits(Predef$.MODULE$.long2Long(1L));
                                createGSIAction.withProvisionedThroughput(provisionedThroughput);
                                table = this.dynamoDB().getTable(indexName.getTableName());
                                option = rangeKeyAttrDefOpt;
                                if (!(option instanceof Some)) break block2;
                                Some some = (Some)option;
                                AttributeDefinition rangeKeyAttrDef = (AttributeDefinition)some.x();
                                index2 = table.createGSI(createGSIAction, hashKeyAttrDef, rangeKeyAttrDef);
                                break block3;
                            }
                            if (!None$.MODULE$.equals(option)) break block4;
                            index2 = table.createGSI(createGSIAction, hashKeyAttrDef);
                        }
                        index = index2;
                        bl = this.synchronousDDL();
                        if (bl) break block5;
                        bl2 = true;
                        break block6;
                    }
                    if (!bl) break block7;
                    TableDescription indexDescription = index.waitForActive();
                    bl2 = TableStatus.ACTIVE.toString().equals(indexDescription.getTableStatus());
                }
                return bl2;
            }
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        throw new MatchError((Object)option);
    }

    public boolean dropIndex(MapStoreIndexName indexName) {
        boolean bl;
        block4: {
            block3: {
                boolean bl2;
                Index index;
                block2: {
                    Table table = this.dynamoDB().getTable(indexName.getTableName());
                    index = table.getIndex(indexName.getIndexName());
                    index.deleteGSI();
                    bl = this.synchronousDDL();
                    if (bl) break block2;
                    bl2 = true;
                    break block3;
                }
                if (!bl) break block4;
                TableDescription indexDescription = index.waitForDelete();
                bl2 = TableStatus.ACTIVE.toString().equals(indexDescription.getTableStatus());
            }
            return true;
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    public Optional<Map<String, Object>> getItem(MapStoreIndexName indexName, MapStoreKey key) {
        Table table = this.dynamoDB().getTable(indexName.getTableName());
        Index index = table.getIndex(indexName.getIndexName());
        MapQueryOptions singleOptions = new MapQueryOptions.Builder().setLimit(1).build();
        QuerySpec querySpec = DynamoDBMapStoreUtil$.MODULE$.createQuerySpec(key, singleOptions);
        return OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(Option$.MODULE$.apply((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)index.query(querySpec)).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Map<String, Object> apply(Item x$1) {
                return x$1.asMap();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toList()).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(List<Map<String, Object>> x$2) {
                return !x$2.isEmpty();
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Map<String, Object> apply(List<Map<String, Object>> x$3) {
                return (Map)x$3.head();
            }
        })));
    }

    public java.util.List<Map<String, Object>> getItems(MapStoreIndexName indexName, MapStoreKey key, MapQueryOptions options) {
        Table table = this.dynamoDB().getTable(indexName.getTableName());
        Index index = table.getIndex(indexName.getIndexName());
        QuerySpec querySpec = DynamoDBMapStoreUtil$.MODULE$.createQuerySpec(key, options);
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)index.query(querySpec)).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Map<String, Object> apply(Item x$4) {
                return x$4.asMap();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toList()).asJava();
    }

    @Inject
    public DynamoDBMapStoreIndexPlugin(AmazonDynamoDB dynamoDBClient) {
        this.dynamoDB = new DynamoDB(dynamoDBClient);
    }
}

