/*
 * Decompiled with CFR 0.152.
 */
package net.spals.appbuilder.mapstore.dynamodb;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.document.AttributeUpdate;
import com.amazonaws.services.dynamodbv2.document.DeleteItemOutcome;
import com.amazonaws.services.dynamodbv2.document.DynamoDB;
import com.amazonaws.services.dynamodbv2.document.GetItemOutcome;
import com.amazonaws.services.dynamodbv2.document.Item;
import com.amazonaws.services.dynamodbv2.document.PrimaryKey;
import com.amazonaws.services.dynamodbv2.document.PutItemOutcome;
import com.amazonaws.services.dynamodbv2.document.Table;
import com.amazonaws.services.dynamodbv2.document.UpdateItemOutcome;
import com.amazonaws.services.dynamodbv2.document.spec.QuerySpec;
import com.amazonaws.services.dynamodbv2.document.spec.ScanSpec;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteTableRequest;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeyType;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.TableDescription;
import com.amazonaws.services.dynamodbv2.model.TableStatus;
import com.amazonaws.services.dynamodbv2.util.TableUtils;
import com.google.inject.Inject;
import com.netflix.governator.annotations.Configuration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PreDestroy;
import javax.validation.constraints.NotNull;
import net.spals.appbuilder.annotations.service.AutoBindInMap;
import net.spals.appbuilder.mapstore.core.MapStorePlugin;
import net.spals.appbuilder.mapstore.core.model.MapQueryOptions;
import net.spals.appbuilder.mapstore.core.model.MapStoreKey;
import net.spals.appbuilder.mapstore.core.model.MapStoreTableKey;
import net.spals.appbuilder.mapstore.dynamodb.DynamoDBMapStoreUtil$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@AutoBindInMap(baseClass=MapStorePlugin.class, key="dynamoDB")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015g!B\u0001\u0003\u0001\ta!A\u0006#z]\u0006lw\u000e\u0012\"NCB\u001cFo\u001c:f!2,x-\u001b8\u000b\u0005\r!\u0011\u0001\u00033z]\u0006lw\u000e\u001a2\u000b\u0005\u00151\u0011\u0001C7baN$xN]3\u000b\u0005\u001dA\u0011AC1qa\n,\u0018\u000e\u001c3fe*\u0011\u0011BC\u0001\u0006gB\fGn\u001d\u0006\u0002\u0017\u0005\u0019a.\u001a;\u0014\u0007\u0001iQ\u0003\u0005\u0002\u000f'5\tqB\u0003\u0002\u0011#\u0005!A.\u00198h\u0015\u0005\u0011\u0012\u0001\u00026bm\u0006L!\u0001F\b\u0003\r=\u0013'.Z2u!\t1\u0012$D\u0001\u0018\u0015\tAB!\u0001\u0003d_J,\u0017B\u0001\u000e\u0018\u00059i\u0015\r]*u_J,\u0007\u000b\\;hS:D\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006IAH\u0001\u000fIft\u0017-\\8E\u0005\u000ec\u0017.\u001a8u\u0007\u0001\u0001\"a\b\u0015\u000e\u0003\u0001R!!\t\u0012\u0002\u0015\u0011Lh.Y7pI\n4(G\u0003\u0002$I\u0005A1/\u001a:wS\u000e,7O\u0003\u0002&M\u0005I\u0011-\\1{_:\fwo\u001d\u0006\u0002O\u0005\u00191m\\7\n\u0005%\u0002#AD!nCj|g\u000eR=oC6|GI\u0011\u0005\u0006W\u0001!\t\u0001L\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00055z\u0003C\u0001\u0018\u0001\u001b\u0005\u0011\u0001\"\u0002\u000f+\u0001\u0004q\u0002F\u0001\u00162!\t\u0011t'D\u00014\u0015\t!T'\u0001\u0004j]*,7\r\u001e\u0006\u0003m\u0019\naaZ8pO2,\u0017B\u0001\u001d4\u0005\u0019IeN[3di\"9!\b\u0001b\u0001\n\u0013Y\u0014A\u0002'P\u000f\u001e+%+F\u0001=!\ti$)D\u0001?\u0015\ty\u0004)A\u0003tY\u001a$$NC\u0001B\u0003\ry'oZ\u0005\u0003\u0007z\u0012a\u0001T8hO\u0016\u0014\bBB#\u0001A\u0003%A(A\u0004M\u001f\u001e;UI\u0015\u0011\t\u0011\u001d\u0003\u0001\u0019!C\u0001\u0005!\u000bab]=oG\"\u0014xN\\8vg\u0012#E*F\u0001J!\tQU*D\u0001L\u0015\u0005a\u0015!B:dC2\f\u0017B\u0001(L\u0005\u001d\u0011un\u001c7fC:D\u0001\u0002\u0015\u0001A\u0002\u0013\u0005!!U\u0001\u0013gft7\r\u001b:p]>,8\u000f\u0012#M?\u0012*\u0017\u000f\u0006\u0002S+B\u0011!jU\u0005\u0003).\u0013A!\u00168ji\"9akTA\u0001\u0002\u0004I\u0015a\u0001=%c!1\u0001\f\u0001Q!\n%\u000bqb]=oG\"\u0014xN\\8vg\u0012#E\n\t\u0015\u0005/j#W\r\u0005\u0002\\E6\tAL\u0003\u0002^=\u0006Y\u0011M\u001c8pi\u0006$\u0018n\u001c8t\u0015\ty\u0006-\u0001\u0006h_Z,'O\\1u_JT!!\u0019\u0014\u0002\u000f9,GO\u001a7jq&\u00111\r\u0018\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\u000bY\fG.^3\"\u0003\u0019\f\u0001%\\1q'R|'/\u001a\u0018es:\fWn\u001c#C]MLhn\u00195s_:|Wo\u001d#E\u0019\"\u0012q\u000b\u001b\t\u0003SBl\u0011A\u001b\u0006\u0003W2\f1bY8ogR\u0014\u0018-\u001b8ug*\u0011QN\\\u0001\u000bm\u0006d\u0017\u000eZ1uS>t'\"A8\u0002\u000b)\fg/\u0019=\n\u0005ET'a\u0002(pi:+H\u000e\u001c\u0005\bg\u0002\u0011\r\u0011\"\u0003u\u0003!!\u0017P\\1n_\u0012\u0013U#A;\u0011\u0005YLX\"A<\u000b\u0005a\u0004\u0013\u0001\u00033pGVlWM\u001c;\n\u0005i<(\u0001\u0003#z]\u0006lw\u000e\u0012\"\t\rq\u0004\u0001\u0015!\u0003v\u0003%!\u0017P\\1n_\u0012\u0013\u0005\u0005C\u0003\u007f\u0001\u0011\u0005s0A\u0003dY>\u001cX\rF\u0001SQ\ri\u00181\u0001\t\u0005\u0003\u000b\tY!\u0004\u0002\u0002\b)\u0019\u0011\u0011\u00028\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u000e\u0005\u001d!A\u0003)sK\u0012+7\u000f\u001e:ps\"9\u0011\u0011\u0003\u0001\u0005B\u0005M\u0011aC2sK\u0006$X\rV1cY\u0016$R!SA\u000b\u0003OA\u0001\"a\u0006\u0002\u0010\u0001\u0007\u0011\u0011D\u0001\ni\u0006\u0014G.\u001a(b[\u0016\u0004B!a\u0007\u0002\"9\u0019!*!\b\n\u0007\u0005}1*\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003G\t)C\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003?Y\u0005\u0002CA\u0015\u0003\u001f\u0001\r!a\u000b\u0002\u0011Q\f'\r\\3LKf\u0004B!!\f\u000245\u0011\u0011q\u0006\u0006\u0004\u0003c9\u0012!B7pI\u0016d\u0017\u0002BA\u001b\u0003_\u0011\u0001#T1q'R|'/\u001a+bE2,7*Z=\t\u000f\u0005e\u0002\u0001\"\u0011\u0002<\u0005IAM]8q)\u0006\u0014G.\u001a\u000b\u0004\u0013\u0006u\u0002\u0002CA\f\u0003o\u0001\r!!\u0007\t\u000f\u0005\u0005\u0003\u0001\"\u0011\u0002D\u0005QA-\u001a7fi\u0016LE/Z7\u0015\u000bI\u000b)%a\u0012\t\u0011\u0005]\u0011q\ba\u0001\u00033A\u0001\"!\u0013\u0002@\u0001\u0007\u00111J\u0001\u0004W\u0016L\b\u0003BA\u0017\u0003\u001bJA!a\u0014\u00020\tYQ*\u00199Ti>\u0014XmS3z\u0011\u001d\t\u0019\u0006\u0001C!\u0003+\n1bZ3u\u00032d\u0017\n^3ngR!\u0011qKA8!\u0019\tI&a\u0018\u0002d5\u0011\u00111\f\u0006\u0004\u0003;\n\u0012\u0001B;uS2LA!!\u0019\u0002\\\t!A*[:u!!\tI&!\u001a\u0002\u001a\u0005%\u0014\u0002BA4\u00037\u00121!T1q!\rQ\u00151N\u0005\u0004\u0003[Z%AB!osJ+g\r\u0003\u0005\u0002\u0018\u0005E\u0003\u0019AA\r\u0011\u001d\t\u0019\b\u0001C!\u0003k\nqaZ3u\u0013R,W\u000e\u0006\u0004\u0002x\u0005u\u0014q\u0010\t\u0007\u00033\nI(a\u0019\n\t\u0005m\u00141\f\u0002\t\u001fB$\u0018n\u001c8bY\"A\u0011qCA9\u0001\u0004\tI\u0002\u0003\u0005\u0002J\u0005E\u0004\u0019AA&\u0011\u001d\t\u0019\t\u0001C!\u0003\u000b\u000b\u0001bZ3u\u0013R,Wn\u001d\u000b\t\u0003/\n9)!#\u0002\f\"A\u0011qCAA\u0001\u0004\tI\u0002\u0003\u0005\u0002J\u0005\u0005\u0005\u0019AA&\u0011!\ti)!!A\u0002\u0005=\u0015aB8qi&|gn\u001d\t\u0005\u0003[\t\t*\u0003\u0003\u0002\u0014\u0006=\"aD'baF+XM]=PaRLwN\\:\t\u000f\u0005]\u0005\u0001\"\u0011\u0002\u001a\u00069\u0001/\u001e;Ji\u0016lG\u0003CA2\u00037\u000bi*a(\t\u0011\u0005]\u0011Q\u0013a\u0001\u00033A\u0001\"!\u0013\u0002\u0016\u0002\u0007\u00111\n\u0005\t\u0003C\u000b)\n1\u0001\u0002d\u00059\u0001/Y=m_\u0006$\u0007bBAS\u0001\u0011\u0005\u0013qU\u0001\u000bkB$\u0017\r^3Ji\u0016lG\u0003CA2\u0003S\u000bY+!,\t\u0011\u0005]\u00111\u0015a\u0001\u00033A\u0001\"!\u0013\u0002$\u0002\u0007\u00111\n\u0005\t\u0003C\u000b\u0019\u000b1\u0001\u0002d!Z\u0001!!-\u0002@\u0006\u0005\u0017\u0011JAb!\u0011\t\u0019,a/\u000e\u0005\u0005U&\u0002BA\\\u0003s\u000bqa]3sm&\u001cWM\u0003\u0002^\r%!\u0011QXA[\u00055\tU\u000f^8CS:$\u0017J\\'ba\u0006I!-Y:f\u00072\f7o]\u0012\u0002+\u0005\n1\u000f")
public class DynamoDBMapStorePlugin
implements MapStorePlugin {
    private final AmazonDynamoDB dynamoDBClient;
    private final Logger LOGGER;
    @NotNull
    @Configuration(value="mapStore.dynamoDB.synchronousDDL")
    private boolean synchronousDDL;
    private final DynamoDB dynamoDB;

    private Logger LOGGER() {
        return this.LOGGER;
    }

    public boolean synchronousDDL() {
        return this.synchronousDDL;
    }

    public void synchronousDDL_$eq(boolean x$1) {
        this.synchronousDDL = x$1;
    }

    private DynamoDB dynamoDB() {
        return this.dynamoDB;
    }

    @PreDestroy
    public void close() {
        this.dynamoDBClient.shutdown();
    }

    public boolean createTable(String tableName, MapStoreTableKey tableKey) {
        boolean bl;
        AttributeDefinition hashKeyAttrDef = new AttributeDefinition().withAttributeName(tableKey.getHashField()).withAttributeType(DynamoDBMapStoreUtil$.MODULE$.createAttributeType(tableKey.getHashFieldType()));
        KeySchemaElement hashKeySchema = new KeySchemaElement(tableKey.getHashField(), KeyType.HASH);
        CreateTableRequest createTableRequest = new CreateTableRequest().withTableName(tableName).withAttributeDefinitions(new AttributeDefinition[]{hashKeyAttrDef}).withKeySchema(new KeySchemaElement[]{hashKeySchema});
        OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(tableKey.getRangeField())).foreach((Function1)new Serializable(this, tableKey, createTableRequest){
            public static final long serialVersionUID = 0L;
            private final MapStoreTableKey tableKey$1;
            private final CreateTableRequest createTableRequest$1;

            public final CreateTableRequest apply(String rangeField) {
                AttributeDefinition rangeKeyAttrDef = new AttributeDefinition().withAttributeName(rangeField).withAttributeType(DynamoDBMapStoreUtil$.MODULE$.createAttributeType((Class)this.tableKey$1.getRangeFieldType().get()));
                KeySchemaElement rangeKeySchema = new KeySchemaElement(rangeField, KeyType.RANGE);
                return this.createTableRequest$1.withAttributeDefinitions(new AttributeDefinition[]{rangeKeyAttrDef}).withKeySchema(new KeySchemaElement[]{rangeKeySchema});
            }
            {
                this.tableKey$1 = tableKey$1;
                this.createTableRequest$1 = createTableRequest$1;
            }
        });
        ProvisionedThroughput provisionedThroughput = new ProvisionedThroughput().withReadCapacityUnits(Predef$.MODULE$.long2Long(1L)).withWriteCapacityUnits(Predef$.MODULE$.long2Long(1L));
        createTableRequest.withProvisionedThroughput(provisionedThroughput);
        try {
            boolean bl2;
            TableUtils.createTableIfNotExists((AmazonDynamoDB)this.dynamoDBClient, (CreateTableRequest)createTableRequest);
            boolean bl3 = this.synchronousDDL();
            if (!bl3) {
                bl2 = true;
            } else if (bl3) {
                TableDescription tableDescription = this.dynamoDB().getTable(tableName).waitForActive();
                bl2 = TableStatus.ACTIVE.toString().equals(tableDescription.getTableStatus());
            } else {
                throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl3));
            }
            bl = bl2;
        }
        catch (RuntimeException runtimeException) {
            bl = false;
        }
        return bl;
    }

    public boolean dropTable(String tableName) {
        boolean bl;
        Table table = this.dynamoDB().getTable(tableName);
        DeleteTableRequest deleteTableRequest = new DeleteTableRequest().withTableName(tableName);
        try {
            boolean bl2;
            TableUtils.deleteTableIfExists((AmazonDynamoDB)this.dynamoDBClient, (DeleteTableRequest)deleteTableRequest);
            boolean bl3 = this.synchronousDDL();
            if (!bl3) {
                bl2 = true;
            } else if (bl3) {
                table.waitForDelete();
                bl2 = true;
            } else {
                throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl3));
            }
            bl = bl2;
        }
        catch (RuntimeException runtimeException) {
            bl = false;
        }
        return bl;
    }

    public void deleteItem(String tableName, MapStoreKey key) {
        Table table = this.dynamoDB().getTable(tableName);
        PrimaryKey primaryKey = DynamoDBMapStoreUtil$.MODULE$.createPrimaryKey(key);
        DeleteItemOutcome deleteItemOutcome = table.deleteItem(primaryKey);
        if (this.LOGGER().isTraceEnabled()) {
            this.LOGGER().trace(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Capacity used for deleteItem on table ", ": "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{deleteItemOutcome.getDeleteItemResult().getConsumedCapacity()}))).toString());
        }
    }

    public List<Map<String, Object>> getAllItems(String tableName) {
        Table table = this.dynamoDB().getTable(tableName);
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)table.scan(new ScanSpec())).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Map<String, Object> apply(Item x$1) {
                return x$1.asMap();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toList()).asJava();
    }

    public Optional<Map<String, Object>> getItem(String tableName, MapStoreKey key) {
        Table table = this.dynamoDB().getTable(tableName);
        PrimaryKey primaryKey = DynamoDBMapStoreUtil$.MODULE$.createPrimaryKey(key);
        GetItemOutcome getItemOutcome = table.getItemOutcome(primaryKey);
        if (this.LOGGER().isTraceEnabled()) {
            this.LOGGER().trace(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Capacity used for getItem on table ", ": "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{getItemOutcome.getGetItemResult().getConsumedCapacity()}))).toString());
        }
        return OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(Option$.MODULE$.apply((Object)getItemOutcome.getItem()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Map<String, Object> apply(Item x$2) {
                return x$2.asMap();
            }
        })));
    }

    public List<Map<String, Object>> getItems(String tableName, MapStoreKey key, MapQueryOptions options) {
        Table table = this.dynamoDB().getTable(tableName);
        QuerySpec querySpec = DynamoDBMapStoreUtil$.MODULE$.createQuerySpec(key, options);
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)table.query(querySpec)).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Map<String, Object> apply(Item x$3) {
                return x$3.asMap();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toList()).asJava();
    }

    public Map<String, Object> putItem(String tableName, MapStoreKey key, Map<String, Object> payload) {
        Table table = this.dynamoDB().getTable(tableName);
        PrimaryKey primaryKey = DynamoDBMapStoreUtil$.MODULE$.createPrimaryKey(key);
        MapStorePlugin.stripKey((MapStoreKey)key, payload);
        Item item = Item.fromMap(payload).withPrimaryKey(primaryKey);
        PutItemOutcome putItemOutcome = table.putItem(item);
        if (this.LOGGER().isTraceEnabled()) {
            this.LOGGER().trace(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Capacity used for putItem on table ", ": "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{putItemOutcome.getPutItemResult().getConsumedCapacity()}))).toString());
        }
        return (Map)Option$.MODULE$.apply((Object)putItemOutcome.getItem()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Map<String, Object> apply(Item x$4) {
                return x$4.asMap();
            }
        }).getOrElse((Function0)new Serializable(this, item){
            public static final long serialVersionUID = 0L;
            private final Item item$1;

            public final Map<String, Object> apply() {
                return this.item$1.asMap();
            }
            {
                this.item$1 = item$1;
            }
        });
    }

    public Map<String, Object> updateItem(String tableName, MapStoreKey key, Map<String, Object> payload) {
        Table table = this.dynamoDB().getTable(tableName);
        PrimaryKey primaryKey = DynamoDBMapStoreUtil$.MODULE$.createPrimaryKey(key);
        MapStorePlugin.stripKey((MapStoreKey)key, payload);
        AttributeUpdate[] attrUpdates = (AttributeUpdate[])((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(payload.entrySet()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final AttributeUpdate apply(Map.Entry<String, Object> entry) {
                AttributeUpdate attributeUpdate;
                AttributeUpdate attrUpdate = new AttributeUpdate(entry.getKey());
                Object object = entry.getValue();
                boolean bl = object == null ? true : "".equals(object);
                if (bl) {
                    attributeUpdate = attrUpdate.delete();
                } else if (object instanceof Number) {
                    Number number = (Number)object;
                    attributeUpdate = attrUpdate.addNumeric(number);
                } else {
                    attributeUpdate = attrUpdate.put(object);
                }
                return attributeUpdate;
            }
        }, Set$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(AttributeUpdate.class));
        UpdateItemOutcome updateItemOutcome = table.updateItem(primaryKey, attrUpdates);
        if (this.LOGGER().isTraceEnabled()) {
            this.LOGGER().trace(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Capacity used for updateItem on table ", ": "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{updateItemOutcome.getUpdateItemResult().getConsumedCapacity()}))).toString());
        }
        return (Map)Option$.MODULE$.apply((Object)updateItemOutcome.getItem()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Map<String, Object> apply(Item x$5) {
                return x$5.asMap();
            }
        }).getOrElse((Function0)new Serializable(this, table, primaryKey){
            public static final long serialVersionUID = 0L;
            private final Table table$1;
            private final PrimaryKey primaryKey$1;

            public final Map<String, Object> apply() {
                return this.table$1.getItem(this.primaryKey$1).asMap();
            }
            {
                this.table$1 = table$1;
                this.primaryKey$1 = primaryKey$1;
            }
        });
    }

    @Inject
    public DynamoDBMapStorePlugin(AmazonDynamoDB dynamoDBClient) {
        this.dynamoDBClient = dynamoDBClient;
        this.LOGGER = LoggerFactory.getLogger(DynamoDBMapStorePlugin.class);
        this.synchronousDDL = false;
        this.dynamoDB = new DynamoDB(dynamoDBClient);
    }
}

