/*
 * Decompiled with CFR 0.152.
 */
package net.spals.appbuilder.mapstore.dynamodb;

import com.amazonaws.services.dynamodbv2.document.PrimaryKey;
import com.amazonaws.services.dynamodbv2.document.RangeKeyCondition;
import com.amazonaws.services.dynamodbv2.document.spec.QuerySpec;
import com.amazonaws.services.dynamodbv2.model.ScalarAttributeType;
import com.google.common.annotations.VisibleForTesting;
import net.spals.appbuilder.mapstore.core.model.MapQueryOptions;
import net.spals.appbuilder.mapstore.core.model.MapRangeOperator;
import net.spals.appbuilder.mapstore.core.model.MapStoreKey;
import net.spals.appbuilder.mapstore.core.model.TwoValueMapRangeKey;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;

public final class DynamoDBMapStoreUtil$ {
    public static final DynamoDBMapStoreUtil$ MODULE$;

    static {
        new DynamoDBMapStoreUtil$();
    }

    public ScalarAttributeType createAttributeType(Class<?> fieldType) {
        Class<?> clazz = fieldType;
        ScalarAttributeType scalarAttributeType = clazz.equals(Boolean.TYPE) ? ScalarAttributeType.B : (clazz.equals(Byte.TYPE) ? ScalarAttributeType.N : (clazz.equals(Double.TYPE) ? ScalarAttributeType.N : (clazz.equals(Float.TYPE) ? ScalarAttributeType.N : (clazz.equals(Integer.TYPE) ? ScalarAttributeType.N : (clazz.equals(Boolean.class) ? ScalarAttributeType.B : (Number.class.isAssignableFrom(clazz) ? ScalarAttributeType.N : (clazz.equals(Long.TYPE) ? ScalarAttributeType.N : (clazz.equals(Short.TYPE) ? ScalarAttributeType.N : ScalarAttributeType.S))))))));
        return scalarAttributeType;
    }

    @VisibleForTesting
    public PrimaryKey createPrimaryKey(MapStoreKey key) {
        return (PrimaryKey)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(key.getRangeField())).map((Function1)new Serializable(key){
            public static final long serialVersionUID = 0L;
            private final MapStoreKey key$1;

            public final PrimaryKey apply(String rangeField) {
                return new PrimaryKey(this.key$1.getHashField(), this.key$1.getHashValue(), rangeField, (Object)this.key$1.getRangeKey().getValue());
            }
            {
                this.key$1 = key$1;
            }
        }).getOrElse((Function0)new Serializable(key){
            public static final long serialVersionUID = 0L;
            private final MapStoreKey key$1;

            public final PrimaryKey apply() {
                return new PrimaryKey(this.key$1.getHashField(), this.key$1.getHashValue());
            }
            {
                this.key$1 = key$1;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public QuerySpec createQuerySpec(MapStoreKey key, MapQueryOptions options) {
        void var3_3;
        QuerySpec querySpec = new QuerySpec().withHashKey(key.getHashField(), key.getHashValue());
        this.createRangeKeyCondition(key).foreach((Function1)new Serializable(querySpec){
            public static final long serialVersionUID = 0L;
            private final QuerySpec querySpec$1;

            public final QuerySpec apply(RangeKeyCondition rangeKeyCondition) {
                return this.querySpec$1.withRangeKeyCondition(rangeKeyCondition);
            }
            {
                this.querySpec$1 = querySpec$1;
            }
        });
        MapQueryOptions.Order order = options.getOrder();
        MapQueryOptions.Order order2 = MapQueryOptions.Order.ASC;
        querySpec.withScanIndexForward(!(order != null ? !order.equals(order2) : order2 != null));
        OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(options.getLimit())).foreach((Function1)new Serializable(querySpec){
            public static final long serialVersionUID = 0L;
            private final QuerySpec querySpec$1;

            public final QuerySpec apply(Integer limit) {
                return this.querySpec$1.withMaxResultSize(limit);
            }
            {
                this.querySpec$1 = querySpec$1;
            }
        });
        return var3_3;
    }

    @VisibleForTesting
    public Option<RangeKeyCondition> createRangeKeyCondition(MapStoreKey key) {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(key.getRangeField())).flatMap((Function1)new Serializable(key){
            public static final long serialVersionUID = 0L;
            private final MapStoreKey key$2;

            public final Option<RangeKeyCondition> apply(String rangeField) {
                Tuple2 tuple2;
                block13: {
                    Option option;
                    block5: {
                        RangeKeyCondition rangeKeyCondition;
                        block12: {
                            block11: {
                                block10: {
                                    block9: {
                                        block8: {
                                            block7: {
                                                block6: {
                                                    MapRangeOperator mapRangeOperator;
                                                    block4: {
                                                        MapRangeOperator mapRangeOperator2;
                                                        rangeKeyCondition = new RangeKeyCondition(rangeField);
                                                        tuple2 = new Tuple2((Object)this.key$2.getRangeKey().getOperator(), (Object)this.key$2.getRangeKey().getValue());
                                                        if (tuple2 == null || !MapRangeOperator.Standard.ALL.equals(mapRangeOperator2 = (MapRangeOperator)tuple2._1())) break block4;
                                                        option = Option$.MODULE$.empty();
                                                        break block5;
                                                    }
                                                    if (tuple2 == null || !MapRangeOperator.Standard.NONE.equals(mapRangeOperator = (MapRangeOperator)tuple2._1())) break block6;
                                                    option = Option$.MODULE$.empty();
                                                    break block5;
                                                }
                                                if (tuple2 == null) break block7;
                                                MapRangeOperator mapRangeOperator = (MapRangeOperator)tuple2._1();
                                                Comparable rValue = (Comparable)tuple2._2();
                                                if (!MapRangeOperator.Standard.BETWEEN.equals(mapRangeOperator)) break block7;
                                                option = Option$.MODULE$.apply((Object)rangeKeyCondition.between((Object)((TwoValueMapRangeKey.TwoValueHolder)rValue).getValue1(), (Object)((TwoValueMapRangeKey.TwoValueHolder)rValue).getValue2()));
                                                break block5;
                                            }
                                            if (tuple2 == null) break block8;
                                            MapRangeOperator mapRangeOperator = (MapRangeOperator)tuple2._1();
                                            Comparable rValue = (Comparable)tuple2._2();
                                            if (!MapRangeOperator.Standard.EQUAL_TO.equals(mapRangeOperator)) break block8;
                                            option = Option$.MODULE$.apply((Object)rangeKeyCondition.eq((Object)rValue));
                                            break block5;
                                        }
                                        if (tuple2 == null) break block9;
                                        MapRangeOperator mapRangeOperator = (MapRangeOperator)tuple2._1();
                                        Comparable rValue = (Comparable)tuple2._2();
                                        if (!MapRangeOperator.Standard.GREATER_THAN.equals(mapRangeOperator)) break block9;
                                        option = Option$.MODULE$.apply((Object)rangeKeyCondition.gt((Object)rValue));
                                        break block5;
                                    }
                                    if (tuple2 == null) break block10;
                                    MapRangeOperator mapRangeOperator = (MapRangeOperator)tuple2._1();
                                    Comparable rValue = (Comparable)tuple2._2();
                                    if (!MapRangeOperator.Standard.GREATER_THAN_OR_EQUAL_TO.equals(mapRangeOperator)) break block10;
                                    option = Option$.MODULE$.apply((Object)rangeKeyCondition.ge((Object)rValue));
                                    break block5;
                                }
                                if (tuple2 == null) break block11;
                                MapRangeOperator mapRangeOperator = (MapRangeOperator)tuple2._1();
                                Comparable rValue = (Comparable)tuple2._2();
                                if (!MapRangeOperator.Standard.LESS_THAN.equals(mapRangeOperator)) break block11;
                                option = Option$.MODULE$.apply((Object)rangeKeyCondition.lt((Object)rValue));
                                break block5;
                            }
                            if (tuple2 == null) break block12;
                            MapRangeOperator mapRangeOperator = (MapRangeOperator)tuple2._1();
                            Comparable rValue = (Comparable)tuple2._2();
                            if (!MapRangeOperator.Standard.LESS_THAN_OR_EQUAL_TO.equals(mapRangeOperator)) break block12;
                            option = Option$.MODULE$.apply((Object)rangeKeyCondition.le((Object)rValue));
                            break block5;
                        }
                        if (tuple2 == null) break block13;
                        MapRangeOperator mapRangeOperator = (MapRangeOperator)tuple2._1();
                        Comparable rValue = (Comparable)tuple2._2();
                        if (!MapRangeOperator.Extended.STARTS_WITH.equals(mapRangeOperator)) break block13;
                        option = Option$.MODULE$.apply((Object)rangeKeyCondition.beginsWith((String)((Object)rValue)));
                    }
                    return option;
                }
                if (tuple2 != null) {
                    MapRangeOperator operator = (MapRangeOperator)tuple2._1();
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DynamoDB cannot support the operator ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operator})));
                }
                throw new MatchError((Object)tuple2);
            }
            {
                this.key$2 = key$2;
            }
        });
    }

    private DynamoDBMapStoreUtil$() {
        MODULE$ = this;
    }
}

