package net.sqlind;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.Query;



/**
 * SQLind4EJB
 * @since 2011
 * @author Rives Davy
 */
public class EJBQueryMapper extends SQLQueryMapper {
	
	private static EJBQueryMapper instance;

	/**
	 * @return the singleton manager instance of SQLQueryMapper
	 */
	public static EJBQueryMapper getInstance() {
		if (instance == null){
			instance = new EJBQueryMapper();
		}
		return instance;
	}
	
	public EJBQueryMapper(String file) throws SQLMapperException {
		super(file);
	}

	public EJBQueryMapper() {}

	
	public class EJBQueryHandler extends GenericQueryHandler {
		protected EJBQueryHandler(SQLQueryTemplate template) {
			super(template);
		}
		
		
		
		protected void fillInPreparedStatement(Query query, HashMap<String, Object> pValues) throws SQLException {
			for (String paramId : template.getParameters())
				query.setParameter(paramId, pValues.get(paramId));
		}
		
		
		
		
		/**
		 * Perform a query using the 'one bean per rupture' wiring behavior
		 * @param EntityManager
		 * @throws SQLMapperException
		 * @return a T bean list
		 */
		@SuppressWarnings("unchecked")
		public <T> List<T> getBeanList(EntityManager manager,Class beanTypeClazz) throws SQLMapperException {
			List<T> list = new ArrayList<T>();
			performSelectQuery(manager, new BeanListWiringBehavior<T>(beanTypeClazz, list));
			return list;
		}

	
		/**
		 * Perform a query using the 'one bean per record' wiring behavior
		 * @param EntityManager
		 * @throws SQLMapperException
		 * @return a T bean list
		 */
		@SuppressWarnings("unchecked")
		public <T> List<T> getSingleBeanList(EntityManager manager,Class beanTypeClazz) throws SQLMapperException {
			List<T> list = new ArrayList<T>();
			performSelectQuery(manager, new SingleBeanListWiringBehavior<T>(beanTypeClazz, list));
			return list;
		}
		
		/**
		 * Perform a query and return a simple type result list
		 * @param EntityManager
		 * @throws SQLMapperException
		 * @return a List of T type instances.
		 */
		@SuppressWarnings("unchecked")
		public <T>List<T> getSimpleResultList(EntityManager manager,Class simpleTypeClazz) throws SQLMapperException {
			try {
				dumpQuery();
				Query query = manager.createQuery(performInjection(injectPointValues));
				fillInPreparedStatement(query, parameterValues);
				EJBResultSet rs = new EJBResultSet(query,template.getColumns());
				List<T> list = new ArrayList<T>();
				while(rs.next())
					list.add((T)rs.getObject(1));
				return list;
			} catch (Exception e) {
				throw template.getException(Errors.ERROR_SQL, e,getSQLWithParameters());
			} finally {
				close();
			}
		}
		
		/**
		 * Perform a query and return a single result from the first record
		 * @param EntityManager
		 * @throws SQLMapperException
		 * @return an instance of T if found, null otherwise
		 */
		@SuppressWarnings("unchecked")
		public <T>T getSimpleResult(EntityManager manager) throws SQLMapperException {
			try {
			
				dumpQuery();
				Query query = manager.createQuery(performInjection(injectPointValues));
				fillInPreparedStatement(query, parameterValues);
				EJBResultSet rs = new EJBResultSet(query,template.getColumns());
				if (rs.next())
					return (T)rs.getObject(1);
				return null;
			} catch (Exception e) {
				throw template.getException(Errors.ERROR_SQL, e,getSQLWithParameters());
			} finally {
				close();
			}
		}
		
		/**
		 * Perform a query using the given query fetching behavior
		 * @param EntityManager
		 * @param behavior
		 * @throws SQLMapperException
		 */
		public void performSelectQuery(EntityManager manager, QueryBehavior behaviour) throws SQLMapperException {
			try {
				dumpQuery();
				Query query = manager.createQuery(performInjection(injectPointValues));
				
				fillInPreparedStatement(query, parameterValues);
				EJBResultSet rs = new EJBResultSet(query,template.getColumns());
				
				values = new Object[template.getColumns().size()];
				getContext().lastValues = new String[values.length];
				while (rs.next())
					behaviour.fetch(rs);
			} catch (SQLMapperException sqlme) {
				throw sqlme;
			} catch (Exception e) {
				throw template.getException(Errors.ERROR_SQL, e,getSQLWithParameters());
			} finally {
				close();
			}
		}

		/**
		 * Perform an update query 
		 * @param EntityManager
		 * @throws SQLMapperException
		 */
		public void performUpdateQuery(EntityManager manager) throws SQLMapperException {
			try {
				dumpQuery();
				Query query = manager.createQuery(performInjection(injectPointValues));			
				fillInPreparedStatement(query, parameterValues);
				query.executeUpdate();
			} catch (Exception e) {
				throw template.getException(Errors.ERROR_SQL, e,getSQLWithParameters());
			} finally {
				close();
			}
			
		}
	}
	
	/**
	 * Retrieve a given EJB QL query
	 * @param file the template file
	 * @param id the query id
	 * @param params optional sections id to enable
	 * @return SQLQuery object
	 */
	public EJBQueryHandler getEJBQuery(String file, String id, String... params)
			throws SQLMapperException {
		if (!instances.containsKey(file))
			synchronized (instances) {
				if (!instances.containsKey(file))
					instances.put(file, new EJBQueryMapper(file));
			}
		return new EJBQueryHandler(instances.get(file).getQuery(null, id, params));
	}
	
	 protected String getParamBindingString(String paramId) {
		
			return ":"+paramId;
		}
}
