/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.xml;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.ParseException;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import net.time4j.Duration;
import net.time4j.IsoUnit;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.PlainTimestamp;
import net.time4j.SI;
import net.time4j.TemporalType;
import net.time4j.ZonalDateTime;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoException;
import net.time4j.scale.LeapSeconds;
import net.time4j.tz.TZID;
import net.time4j.tz.ZonalOffset;

public abstract class XMLAdapter<S, T>
extends TemporalType<S, T> {
    private static final int MIO = 1000000;
    private static final int MRD = 1000000000;
    private static final BigDecimal MRD_D = BigDecimal.valueOf(1000000000L);
    private static final BigInteger MRD_I = BigInteger.valueOf(1000000000L);
    private static final XmlDateTimeRule XML_TIMESTAMP = new XmlDateTimeRule();
    public static final XMLAdapter<XMLGregorianCalendar, PlainDate> XML_DATE = new XmlDateRule();
    public static final XMLAdapter<XMLGregorianCalendar, PlainTime> XML_TIME = new XmlTimeRule();
    public static final XMLAdapter<XMLGregorianCalendar, PlainTimestamp> XML_DATE_TIME = XML_TIMESTAMP;
    public static final XMLAdapter<XMLGregorianCalendar, ZonalDateTime> XML_DATE_TIME_OFFSET = new XmlDateTimeOffsetRule();
    public static final XMLAdapter<javax.xml.datatype.Duration, Duration<IsoUnit>> XML_DURATION = new XmlDurationRule();

    private XMLAdapter() {
    }

    private static DatatypeFactory getXMLFactory() {
        try {
            return DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            throw new ChronoException("XML-conversion not available.", (Exception)datatypeConfigurationException);
        }
    }

    private static XMLGregorianCalendar toXML(ChronoDisplay chronoDisplay, int n) {
        PlainDate plainDate = (PlainDate)chronoDisplay.get((ChronoElement)PlainDate.COMPONENT);
        int n2 = plainDate.getYear();
        int n3 = plainDate.getMonth();
        int n4 = plainDate.getDayOfMonth();
        PlainTime plainTime = (PlainTime)chronoDisplay.get((ChronoElement)PlainTime.COMPONENT);
        int n5 = plainTime.getHour();
        int n6 = plainTime.getMinute();
        int n7 = (Integer)chronoDisplay.get((ChronoElement)PlainTime.SECOND_OF_MINUTE);
        int n8 = plainTime.getNanosecond();
        DatatypeFactory datatypeFactory = XMLAdapter.getXMLFactory();
        if (n8 % 1000000 == 0) {
            int n9 = n8 / 1000000;
            return datatypeFactory.newXMLGregorianCalendar(n2, n3, n4, n5, n6, n7, n9, n);
        }
        BigInteger bigInteger = BigInteger.valueOf(n2);
        BigDecimal bigDecimal = BigDecimal.valueOf(n8).setScale(9, RoundingMode.UNNECESSARY).divide(MRD_D, RoundingMode.UNNECESSARY);
        return datatypeFactory.newXMLGregorianCalendar(bigInteger, n3, n4, n5, n6, n7, bigDecimal, n);
    }

    private static class XmlDurationRule
    extends XMLAdapter<javax.xml.datatype.Duration, Duration<IsoUnit>> {
        private XmlDurationRule() {
        }

        public Duration<IsoUnit> translate(javax.xml.datatype.Duration duration) {
            if (duration.getSign() == 0) {
                return Duration.ofZero();
            }
            try {
                return Duration.parsePeriod((String)duration.toString());
            }
            catch (ParseException parseException) {
                if (parseException.getCause() instanceof NumberFormatException) {
                    ArithmeticException arithmeticException = new ArithmeticException();
                    arithmeticException.initCause(parseException);
                    throw arithmeticException;
                }
                throw new ChronoException("Cannot translate: " + duration, (Exception)parseException);
            }
        }

        public javax.xml.datatype.Duration from(Duration<IsoUnit> duration) {
            DatatypeFactory datatypeFactory = XMLAdapter.getXMLFactory();
            return datatypeFactory.newDuration(duration.toStringXML());
        }

        public Class<javax.xml.datatype.Duration> getSourceType() {
            return javax.xml.datatype.Duration.class;
        }
    }

    private static class XmlDateTimeOffsetRule
    extends XMLAdapter<XMLGregorianCalendar, ZonalDateTime> {
        private XmlDateTimeOffsetRule() {
        }

        public ZonalDateTime translate(XMLGregorianCalendar xMLGregorianCalendar) {
            PlainTimestamp plainTimestamp = XML_TIMESTAMP.translate(xMLGregorianCalendar, true);
            int n = xMLGregorianCalendar.getTimezone();
            if (n == Integer.MIN_VALUE) {
                throw new ChronoException("Missing timezone offset: " + xMLGregorianCalendar);
            }
            ZonalOffset zonalOffset = ZonalOffset.ofTotalSeconds((int)(n * 60));
            Moment moment = plainTimestamp.at(zonalOffset);
            if (xMLGregorianCalendar.getSecond() == 60 && LeapSeconds.getInstance().isEnabled()) {
                Moment moment2 = moment.plus(1L, SI.SECONDS);
                if (moment2.isLeapSecond()) {
                    return moment2.inZonalView((TZID)zonalOffset);
                }
                throw new ChronoException("Leap second not registered: " + xMLGregorianCalendar);
            }
            return moment.inZonalView((TZID)zonalOffset);
        }

        public XMLGregorianCalendar from(ZonalDateTime zonalDateTime) {
            ZonalOffset zonalOffset = zonalDateTime.getOffset();
            int n = zonalOffset.getIntegralAmount() / 60;
            try {
                return XMLAdapter.toXML((ChronoDisplay)zonalDateTime, n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (zonalDateTime.isLeapSecond()) {
                    ZonalDateTime zonalDateTime2 = zonalDateTime.toMoment().minus(1L, SI.SECONDS).inZonalView((TZID)zonalOffset);
                    return XMLAdapter.toXML((ChronoDisplay)zonalDateTime2, n);
                }
                throw illegalArgumentException;
            }
        }

        public Class<XMLGregorianCalendar> getSourceType() {
            return XMLGregorianCalendar.class;
        }
    }

    private static class XmlDateTimeRule
    extends XMLAdapter<XMLGregorianCalendar, PlainTimestamp> {
        private XmlDateTimeRule() {
        }

        public PlainTimestamp translate(XMLGregorianCalendar xMLGregorianCalendar) {
            return this.translate(xMLGregorianCalendar, false);
        }

        PlainTimestamp translate(XMLGregorianCalendar xMLGregorianCalendar, boolean bl) {
            int n;
            BigInteger bigInteger;
            BigInteger bigInteger2 = xMLGregorianCalendar.getEon();
            if (bigInteger2 != null && (bigInteger = bigInteger2.abs()).compareTo(MRD_I) >= 0) {
                throw new ArithmeticException("Year out of supported range: " + xMLGregorianCalendar);
            }
            int n2 = xMLGregorianCalendar.getYear();
            int n3 = xMLGregorianCalendar.getMonth();
            int n4 = xMLGregorianCalendar.getDay();
            if (n2 == Integer.MIN_VALUE || n3 == Integer.MIN_VALUE || n4 == Integer.MIN_VALUE) {
                throw new ChronoException("Missing date component: " + xMLGregorianCalendar);
            }
            int n5 = xMLGregorianCalendar.getHour();
            if (n5 == Integer.MIN_VALUE) {
                throw new ChronoException("Missing hour component: " + xMLGregorianCalendar);
            }
            int n6 = xMLGregorianCalendar.getMinute();
            if (n6 == Integer.MIN_VALUE) {
                n6 = 0;
            }
            if ((n = xMLGregorianCalendar.getSecond()) == Integer.MIN_VALUE) {
                n = 0;
            } else if (bl && n == 60) {
                n = 59;
            }
            int n7 = 0;
            BigDecimal bigDecimal = xMLGregorianCalendar.getFractionalSecond();
            if (bigDecimal != null) {
                n7 = bigDecimal.movePointRight(9).intValue();
            }
            PlainTimestamp plainTimestamp = PlainTimestamp.of((int)n2, (int)n3, (int)n4, (int)n5, (int)n6, (int)n);
            if (n7 != 0) {
                plainTimestamp = (PlainTimestamp)plainTimestamp.with((ChronoElement)PlainTime.NANO_OF_SECOND, n7);
            }
            return plainTimestamp;
        }

        public XMLGregorianCalendar from(PlainTimestamp plainTimestamp) {
            return XMLAdapter.toXML((ChronoDisplay)plainTimestamp, Integer.MIN_VALUE);
        }

        public Class<XMLGregorianCalendar> getSourceType() {
            return XMLGregorianCalendar.class;
        }
    }

    private static class XmlTimeRule
    extends XMLAdapter<XMLGregorianCalendar, PlainTime> {
        private XmlTimeRule() {
        }

        public PlainTime translate(XMLGregorianCalendar xMLGregorianCalendar) {
            int n;
            int n2 = xMLGregorianCalendar.getHour();
            if (n2 == Integer.MIN_VALUE) {
                throw new ChronoException("Missing hour component: " + xMLGregorianCalendar);
            }
            int n3 = xMLGregorianCalendar.getMinute();
            if (n3 == Integer.MIN_VALUE) {
                n3 = 0;
            }
            if ((n = xMLGregorianCalendar.getSecond()) == Integer.MIN_VALUE) {
                n = 0;
            }
            int n4 = 0;
            BigDecimal bigDecimal = xMLGregorianCalendar.getFractionalSecond();
            if (bigDecimal != null) {
                n4 = bigDecimal.movePointRight(9).intValue();
            }
            return PlainTime.of((int)n2, (int)n3, (int)n, (int)n4);
        }

        public XMLGregorianCalendar from(PlainTime plainTime) {
            int n = plainTime.getHour();
            int n2 = plainTime.getMinute();
            int n3 = plainTime.getSecond();
            int n4 = plainTime.getNanosecond();
            DatatypeFactory datatypeFactory = XMLAdapter.getXMLFactory();
            int n5 = Integer.MIN_VALUE;
            if (n4 % 1000000 == 0) {
                int n6 = n4 / 1000000;
                return datatypeFactory.newXMLGregorianCalendarTime(n, n2, n3, n6, n5);
            }
            BigDecimal bigDecimal = BigDecimal.valueOf(n4).setScale(9, RoundingMode.UNNECESSARY).divide(MRD_D, RoundingMode.UNNECESSARY);
            return datatypeFactory.newXMLGregorianCalendarTime(n, n2, n3, bigDecimal, n5);
        }

        public Class<XMLGregorianCalendar> getSourceType() {
            return XMLGregorianCalendar.class;
        }
    }

    private static class XmlDateRule
    extends XMLAdapter<XMLGregorianCalendar, PlainDate> {
        private XmlDateRule() {
        }

        public PlainDate translate(XMLGregorianCalendar xMLGregorianCalendar) {
            BigInteger bigInteger;
            BigInteger bigInteger2 = xMLGregorianCalendar.getEon();
            if (bigInteger2 != null && (bigInteger = bigInteger2.abs()).compareTo(MRD_I) >= 0) {
                throw new ArithmeticException("Year out of supported range: " + xMLGregorianCalendar);
            }
            int n = xMLGregorianCalendar.getYear();
            int n2 = xMLGregorianCalendar.getMonth();
            int n3 = xMLGregorianCalendar.getDay();
            if (n == Integer.MIN_VALUE || n2 == Integer.MIN_VALUE || n3 == Integer.MIN_VALUE) {
                throw new ChronoException("Missing date component: " + xMLGregorianCalendar);
            }
            return PlainDate.of((int)n, (int)n2, (int)n3);
        }

        public XMLGregorianCalendar from(PlainDate plainDate) {
            int n = plainDate.getYear();
            int n2 = plainDate.getMonth();
            int n3 = plainDate.getDayOfMonth();
            DatatypeFactory datatypeFactory = XMLAdapter.getXMLFactory();
            return datatypeFactory.newXMLGregorianCalendarDate(n, n2, n3, Integer.MIN_VALUE);
        }

        public Class<XMLGregorianCalendar> getSourceType() {
            return XMLGregorianCalendar.class;
        }
    }
}

