/*
 * Decompiled with CFR 0.152.
 */
package net.turnbig.jdbcx;

import java.beans.PropertyDescriptor;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.NotWritablePropertyException;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.TypeMismatchException;
import org.springframework.core.convert.ConversionService;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class JdbcxBeanPropertyRowMapper<T>
extends BeanPropertyRowMapper<T> {
    private Class<T> mappedClass;
    private Map<String, PropertyDescriptor> mappedFields;
    private Set<String> mappedProperties;
    private ConversionService cs;

    public JdbcxBeanPropertyRowMapper() {
    }

    public JdbcxBeanPropertyRowMapper(Class<T> mappedClass, boolean checkFullyPopulated) {
        super(mappedClass, checkFullyPopulated);
    }

    public JdbcxBeanPropertyRowMapper(Class<T> mappedClass) {
        super(mappedClass);
    }

    public JdbcxBeanPropertyRowMapper(Class<T> mappedClass, ConversionService cs) {
        super(mappedClass);
        this.cs = cs;
    }

    protected String underscoreName(String name) {
        if (!StringUtils.hasLength((String)name)) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        result.append(this.lowerCaseName(name.substring(0, 1)));
        for (int i = 1; i < name.length(); ++i) {
            String slc;
            String s = name.substring(i, i + 1);
            if (!s.equals(slc = this.lowerCaseName(s))) {
                result.append("_").append(slc);
                continue;
            }
            result.append(s);
        }
        return result.toString();
    }

    protected String lowerCaseName(String name) {
        return name.toLowerCase(Locale.US);
    }

    protected void initialize(Class<T> mappedClass) {
        PropertyDescriptor[] pds;
        this.mappedClass = mappedClass;
        this.mappedFields = new HashMap<String, PropertyDescriptor>();
        this.mappedProperties = new HashSet<String>();
        for (PropertyDescriptor pd : pds = BeanUtils.getPropertyDescriptors(mappedClass)) {
            if (pd.getWriteMethod() == null) continue;
            this.mappedFields.put(this.lowerCaseName(pd.getName()), pd);
            String underscoredName = this.underscoreName(pd.getName());
            if (!this.lowerCaseName(pd.getName()).equals(underscoredName)) {
                this.mappedFields.put(underscoredName, pd);
            }
            this.mappedProperties.add(pd.getName());
        }
    }

    protected void initBeanWrapper(BeanWrapper bw) {
        super.initBeanWrapper(bw);
        if (this.cs == null) {
            this.cs = new DefaultFormattingConversionService(true);
        }
        bw.setConversionService(this.cs);
        bw.setAutoGrowNestedPaths(true);
    }

    public T mapRow(ResultSet rs, int rowNumber) throws SQLException {
        Assert.state((this.mappedClass != null ? 1 : 0) != 0, (String)"Mapped class was not specified");
        Object mappedObject = BeanUtils.instantiate(this.mappedClass);
        BeanWrapper bw = PropertyAccessorFactory.forBeanPropertyAccess((Object)mappedObject);
        this.initBeanWrapper(bw);
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        HashSet<String> populatedProperties = this.isCheckFullyPopulated() ? new HashSet<String>() : null;
        for (int index = 1; index <= columnCount; ++index) {
            Object value;
            String column = JdbcUtils.lookupColumnName((ResultSetMetaData)rsmd, (int)index);
            String field = column.replaceAll(" ", "");
            PropertyDescriptor pd = this.mappedFields.get(this.lowerCaseName(field));
            if (pd != null) {
                try {
                    value = this.getColumnValue(rs, index, pd);
                    if (rowNumber == 0 && this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Mapping column '" + column + "' to property '" + pd.getName() + "' of type [" + ClassUtils.getQualifiedName(pd.getPropertyType()) + "]"));
                    }
                    try {
                        bw.setPropertyValue(pd.getName(), value);
                    }
                    catch (TypeMismatchException ex) {
                        if (value == null && this.isPrimitivesDefaultedForNullValue()) {
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug((Object)("Intercepted TypeMismatchException for row " + rowNumber + " and column '" + column + "' with null value when setting property '" + pd.getName() + "' of type [" + ClassUtils.getQualifiedName(pd.getPropertyType()) + "] on object: " + mappedObject), (Throwable)ex);
                            }
                        }
                        throw ex;
                    }
                    if (populatedProperties == null) continue;
                    populatedProperties.add(pd.getName());
                    continue;
                }
                catch (NotWritablePropertyException ex) {
                    throw new DataRetrievalFailureException("Unable to map column '" + column + "' to property '" + pd.getName() + "'", (Throwable)ex);
                }
            }
            if (field.contains(".")) {
                value = JdbcUtils.getResultSetValue((ResultSet)rs, (int)index);
                try {
                    String camelCaseName = this.camelCaseName(field);
                    bw.setPropertyValue(camelCaseName, value);
                }
                catch (TypeMismatchException ex) {
                    this.logger.debug((Object)("Could not set property for column " + column));
                }
                continue;
            }
            if (rowNumber != 0 || !this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("No property found for column '" + column + "' mapped to field '" + field + "'"));
        }
        if (populatedProperties != null && !populatedProperties.equals(this.mappedProperties)) {
            throw new InvalidDataAccessApiUsageException("Given ResultSet does not contain all fields necessary to populate object of class [" + this.mappedClass.getName() + "]: " + this.mappedProperties);
        }
        return (T)mappedObject;
    }

    protected String camelCaseName(String name) {
        String[] splitted;
        if (!StringUtils.hasLength((String)name)) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (String split : splitted = name.split("_")) {
            result.append(StringUtils.capitalize((String)split));
        }
        return StringUtils.uncapitalize((String)result.toString());
    }
}

