/*
 * Decompiled with CFR 0.152.
 */
package net.turnbig.jdbcx;

import com.google.common.base.CaseFormat;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import net.turnbig.jdbcx.JdbcxPagingDaoSupport;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class JdbcxService<Entity, PK extends Serializable> {
    private static final Logger logger = LoggerFactory.getLogger(JdbcxService.class);
    protected Class<Entity> entityClazz;
    protected String tableName;
    protected String idColumnName;
    protected Field idField;
    @Autowired
    protected JdbcxPagingDaoSupport DAO;
    String getAllSql;
    String getByIdSql;
    String listByIdSql;
    String deleteByIdSql;
    String insertSql;

    public JdbcxService() {
        this.entityClazz = this.getSuperClassGenricType(this.getClass(), 0);
        this.initial(this.entityClazz);
    }

    public JdbcxService(Class<Entity> EntityClazz) {
        this.initial(EntityClazz);
    }

    private void initial(Class<Entity> EntityClazz) {
        this.entityClazz = EntityClazz;
        try {
            this.guessTableMeta();
            this.generateSql();
        }
        catch (NoSuchFieldException | SecurityException e) {
            logger.error("initial jdbcx service failed", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void generateSql() {
        this.getAllSql = MessageFormat.format("select * from {0}", this.tableName);
        this.getByIdSql = MessageFormat.format("select * from {0} where {1} = :id", this.tableName, this.idColumnName);
        this.listByIdSql = MessageFormat.format("select * from {0} where {1} in (:id)", this.tableName, this.idColumnName);
        this.deleteByIdSql = MessageFormat.format("delete from {0} where {1} = :id", this.tableName, this.idColumnName);
    }

    public Entity get(PK id) {
        try {
            HashMap<String, PK> param = new HashMap<String, PK>();
            param.put("id", id);
            return this.DAO.queryForBean(this.getByIdSql, param, this.entityClazz);
        }
        catch (Exception e) {
            return null;
        }
    }

    public List<Entity> list(List<PK> list) {
        try {
            HashMap<String, List<PK>> param = new HashMap<String, List<PK>>();
            param.put("id", list);
            return this.DAO.queryForListBean(this.listByIdSql, param, this.entityClazz);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Page<Entity> getAll(Pageable p) {
        return this.DAO.queryForListBean(this.getAllSql, this.entityClazz, p);
    }

    public List<Entity> getAll() {
        return this.DAO.queryForListBean(this.getAllSql, this.entityClazz);
    }

    public Entity findByFields(FieldValue ... fvs) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        StringBuffer sb = new StringBuffer("select * from ").append(this.tableName).append(" where 1=1 ");
        for (FieldValue fv : fvs) {
            String dbFieldName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, fv.getFieldName());
            sb.append(" and ").append(dbFieldName).append(" = :").append(fv.getFieldName());
            param.put(fv.getFieldName(), fv.getFieldValue());
        }
        sb.append(" limit 1");
        List<Entity> result = this.DAO.queryForListBean(sb.toString(), param, this.entityClazz);
        if (CollectionUtils.isEmpty(result)) {
            return null;
        }
        return result.get(0);
    }

    public List<Entity> findListByFields(FieldValue ... fvs) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        StringBuffer sb = new StringBuffer("select * from ").append(this.tableName).append(" where 1=1 ");
        for (FieldValue fv : fvs) {
            String dbFieldName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, fv.getFieldName());
            sb.append(" and ").append(dbFieldName);
            if (fv.getFieldValue() == null) {
                sb.append(" is null");
                continue;
            }
            sb.append(" = :").append(fv.getFieldName());
            param.put(fv.getFieldName(), fv.getFieldValue());
        }
        return this.DAO.queryForListBean(sb.toString(), param, this.entityClazz);
    }

    public Page<Entity> findListByFields(List<FieldValue> fvs, Pageable p) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        StringBuffer sb = new StringBuffer("select * from ").append(this.tableName).append(" where 1=1 ");
        for (FieldValue fv : fvs) {
            String dbFieldName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, fv.getFieldName());
            sb.append(" and ").append(dbFieldName).append(" = :").append(fv.getFieldName());
            param.put(fv.getFieldName(), fv.getFieldValue());
        }
        return this.DAO.queryForListBean(sb.toString(), param, this.entityClazz, p);
    }

    public Integer countByFields(FieldValue ... fvs) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        StringBuffer sb = new StringBuffer("select count(*) from ").append(this.tableName).append(" where 1=1 ");
        for (FieldValue fv : fvs) {
            String dbFieldName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, fv.getFieldName());
            sb.append(" and ").append(dbFieldName).append(" = :").append(fv.getFieldName());
            param.put(fv.getFieldName(), fv.getFieldValue());
        }
        return this.DAO.queryForObject(sb.toString(), param, Integer.class);
    }

    public int updateFields(PK id, FieldValue ... fvs) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("id", id);
        StringBuffer sb = new StringBuffer("update ").append(this.tableName).append(" set ");
        boolean addComma = false;
        for (FieldValue fv : fvs) {
            sb.append(addComma ? "," : "");
            String dbFieldName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, fv.getFieldName());
            sb.append(dbFieldName);
            if (fv.getFieldValue() == null) {
                sb.append(" = null");
            } else {
                sb.append(" = :").append(fv.getFieldName());
                param.put(fv.getFieldName(), fv.getFieldValue());
            }
            addComma = true;
        }
        sb.append(" where ").append(this.idColumnName).append(" = :id");
        return this.DAO.update(sb.toString(), param);
    }

    public Entity insert(Entity entity) {
        KeyHolder insert = this.DAO.insert(this.insertSql, entity, this.idColumnName);
        ReflectionUtils.setField((Field)this.idField, entity, (Object)insert.getKey());
        return entity;
    }

    public int delete(PK id) {
        HashMap<String, PK> paramMap = new HashMap<String, PK>();
        paramMap.put("id", id);
        int count = this.DAO.update(this.deleteByIdSql, paramMap);
        return count;
    }

    private Class<?> getSuperClassGenricType(Class<?> targetClass, int index) {
        Assert.notNull(targetClass, (String)"targetClass\u4e0d\u80fd\u4e3a\u7a7a");
        Type genType = targetClass.getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            logger.warn(targetClass.getSimpleName() + "'s superclass not ParameterizedType");
            return Object.class;
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            logger.warn("Index: " + index + ", Size of " + targetClass.getSimpleName() + "'s Parameterized Type: " + params.length);
            return Object.class;
        }
        if (!(params[index] instanceof Class)) {
            logger.warn(targetClass.getSimpleName() + " not set the actual Class targetClassn superclass generic parameter");
            return Object.class;
        }
        return (Class)params[index];
    }

    private void guessTableMeta() throws NoSuchFieldException, SecurityException {
        Table table = (Table)AnnotationUtils.findAnnotation(this.entityClazz, Table.class);
        if (table != null) {
            this.tableName = table.name();
        }
        if (StringUtils.isEmpty((Object)this.tableName)) {
            logger.info("[{}] not @Table annotation with name is fould", this.entityClazz);
            String clazz = this.entityClazz.getName();
            int lastIndexOf = clazz.lastIndexOf(".");
            String className = clazz.substring(lastIndexOf + 1);
            this.tableName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, className);
        }
        Field[] fields = FieldUtils.getAllFields(this.entityClazz);
        ArrayList<String> fieldNames = new ArrayList<String>(fields.length);
        for (Field field : fields) {
            int modifiers = field.getModifiers();
            if (field.isAnnotationPresent(Id.class) || field.getName().equals("id")) {
                Column column;
                if (field.isAnnotationPresent(Column.class) && (column = field.getAnnotation(Column.class)) != null) {
                    this.idColumnName = column.name();
                }
                if (StringUtils.isEmpty((Object)this.idColumnName)) {
                    this.idColumnName = this.upperCamelToUnderscore(field.getName());
                }
                this.idField = field;
                continue;
            }
            if (field.isAnnotationPresent(Transient.class) || Modifier.isFinal(modifiers) || Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers)) continue;
            fieldNames.add(field.getName());
        }
        if (StringUtils.isEmpty((Object)this.idColumnName)) {
            logger.info("[{}] not @Id annotation is fould, will use *id* as id column name", this.entityClazz);
            this.idColumnName = "id";
            this.idField = this.entityClazz.getDeclaredField(this.idColumnName);
        }
        this.idField.setAccessible(true);
        logger.info("[{}] detected table meta: table-name `{}`, id-column-name `{}`", new Object[]{this.entityClazz, this.tableName, this.idColumnName});
        this.insertSql = this.generateInsertSql(fieldNames);
        logger.debug("[{}] generated insert sql is `{}`", this.entityClazz, (Object)this.insertSql);
    }

    protected String generateInsertSql(List<String> fieldNames) {
        String valueKeys = StringUtils.collectionToDelimitedString(fieldNames, (String)",", (String)":", (String)"");
        CollectionUtils.transform(fieldNames, (Transformer)new Transformer<String, String>(){

            public String transform(String input) {
                return JdbcxService.this.upperCamelToUnderscore(input);
            }
        });
        String insertKeys = StringUtils.collectionToDelimitedString(fieldNames, (String)",");
        return String.format("insert into %s (%s) values (%s)", this.tableName, insertKeys, valueKeys);
    }

    protected String upperCamelToUnderscore(String value) {
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, value);
    }

    public HashMap<PK, Entity> mapped(List<Entity> list) {
        HashMap<Serializable, Entity> mapped = new HashMap<Serializable, Entity>(list.size());
        for (Entity entity : list) {
            try {
                mapped.put((Serializable)this.idField.get(entity), entity);
            }
            catch (Exception e) {
                logger.warn("could not get id field value for entity {}", entity.getClass());
            }
        }
        return mapped;
    }

    public static void main(String[] args) {
        Class<String> clazz = String.class;
        System.out.println(clazz.getName());
    }

    public static class FieldValue {
        private String fieldName;
        private Object fieldValue;

        public FieldValue(String fieldName, Object fieldValue) {
            this.fieldName = fieldName;
            this.fieldValue = fieldValue;
        }

        public static FieldValue of(String name, Object value) {
            return new FieldValue(name, value);
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public Object getFieldValue() {
            return this.fieldValue;
        }
    }
}

