/*
 * Decompiled with CFR 0.152.
 */
package net.turnbig.jdbcx.convertor;

import java.lang.reflect.Array;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;

public class PGArrayConverter
implements ConditionalGenericConverter {
    private static final Logger logger = LoggerFactory.getLogger(PGArrayConverter.class);
    private ConversionService conversionService;

    public PGArrayConverter(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        HashSet<GenericConverter.ConvertiblePair> convertables = new HashSet<GenericConverter.ConvertiblePair>();
        convertables.add(new GenericConverter.ConvertiblePair(java.sql.Array.class, List.class));
        convertables.add(new GenericConverter.ConvertiblePair(java.sql.Array.class, Object[].class));
        return convertables;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source != null && source instanceof java.sql.Array) {
            java.sql.Array jdbc4Array = (java.sql.Array)source;
            try {
                ResolvableType resolvableType = targetType.getResolvableType();
                Object[] array = (Object[])jdbc4Array.getArray();
                if (resolvableType.getRawClass().isAssignableFrom(List.class)) {
                    List<Object> asList = Arrays.asList(array);
                    return asList;
                }
                Object target = Array.newInstance(targetType.getElementTypeDescriptor().getType(), array.length);
                for (int i = 0; i < array.length; ++i) {
                    Object object = array[i];
                    Array.set(target, i, object);
                }
                return target;
            }
            catch (SQLException e) {
                logger.error("Could not convert jdbc4 array to List<?>", (Throwable)e);
            }
        }
        return null;
    }

    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        return PGArrayConverter.canConvertElements(sourceType.getElementTypeDescriptor(), targetType.getElementTypeDescriptor(), this.conversionService);
    }

    public static boolean canConvertElements(TypeDescriptor sourceElementType, TypeDescriptor targetElementType, ConversionService conversionService) {
        if (targetElementType == null) {
            return true;
        }
        if (sourceElementType == null) {
            return true;
        }
        if (conversionService.canConvert(sourceElementType, targetElementType)) {
            return true;
        }
        return sourceElementType.getType().isAssignableFrom(targetElementType.getType());
    }
}

