/*
 * Decompiled with CFR 0.152.
 */
package net.turnbig.jdbcx.pageable;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;

public class PaginationHelper {
    private static final int DEFAULT_PAGE_SIZE = 15;
    public static final String PAGINATION_ATTRNAME_PAGE = "page";
    public static final String PAGINATION_ATTRNAME_PAGESIZE = "pagesize";
    public static final String PAGINATION_ATTRNAME_SORT = "sortby";
    @Autowired
    private HttpServletRequest context;

    private Sort buildSortBy(String sortby) {
        Sort sort = null;
        if (StringUtils.isNotBlank((CharSequence)sortby)) {
            String[] split;
            for (String s : split = StringUtils.split((String)sortby, (String)",")) {
                String field;
                boolean isDesc = StringUtils.startsWith((CharSequence)s, (CharSequence)"-");
                String string = field = isDesc ? StringUtils.removeStart((String)s, (String)"-") : s;
                sort = sort == null ? new Sort(isDesc ? Sort.Direction.DESC : Sort.Direction.ASC, new String[]{field}) : sort.and(new Sort(isDesc ? Sort.Direction.DESC : Sort.Direction.ASC, new String[]{field}));
            }
        }
        return sort;
    }

    public PageRequest getPagination(String sortby) {
        return this.getPagination(15, sortby);
    }

    public PageRequest getPagination(Integer pageSize, String sortby) {
        String _sortby = this.context.getParameter(PAGINATION_ATTRNAME_SORT);
        if (StringUtils.isNotBlank((CharSequence)_sortby)) {
            sortby = _sortby;
        }
        String page = StringUtils.defaultString((String)this.context.getParameter(PAGINATION_ATTRNAME_PAGE), (String)"1");
        String size = StringUtils.defaultString((String)this.context.getParameter(PAGINATION_ATTRNAME_PAGESIZE), (String)String.valueOf(pageSize));
        PageRequest pageRequest = null;
        Sort sort = this.buildSortBy(sortby);
        pageRequest = sort != null ? new PageRequest(Integer.parseInt(page) - 1, Integer.parseInt(size), sort) : new PageRequest(Integer.parseInt(page) - 1, Integer.parseInt(size));
        return pageRequest;
    }

    public PageRequest getPagination() {
        return this.getPagination(null);
    }
}

